/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.base.Preconditions;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.ITickEvent;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;

public class RumbleHandler {
    private static RumbleHandler instance;

    @ApiStatus.Internal
    public RumbleHandler() {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Only one instance of RumbleHandler is allowed");
        TickEvents.START_PLAYER.register((IFrameworkEvent)((ITickEvent.StartPlayer)this::onUseItem));
        instance = this;
    }

    @ApiStatus.Internal
    public void onDamage(class_746 player, float damage) {
        if (!((Boolean)Config.CLIENT.client.options.rumble.get()).booleanValue()) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null || !Controllable.getInput().isControllerInUse() || !controller.supportsRumble()) {
            return;
        }
        float scale = damage / player.method_6063();
        float maxFreq = class_3532.method_15363((float)scale, (float)0.1f, (float)1.0f);
        float minFreq = class_3532.method_15363((float)(maxFreq - 0.2f), (float)0.1f, (float)1.0f);
        int time = class_3532.method_15340((int)((int)(scale * 800.0f)), (int)100, (int)800);
        controller.rumble(minFreq, maxFreq, time);
    }

    private void onUseItem(class_1657 player) {
        if (!((Boolean)Config.CLIENT.client.options.rumble.get()).booleanValue()) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null || !Controllable.getInput().isControllerInUse() || !controller.supportsRumble()) {
            return;
        }
        if (!player.method_6115()) {
            return;
        }
        int ticks = player.method_6048();
        class_1799 stack = player.method_6030();
        switch (stack.method_7976()) {
            case field_8950: 
            case field_8946: {
                if (ticks < 4) break;
                float maxFreq = class_3532.method_15379((float)(class_3532.method_15362((float)((float)ticks / 4.0f * (float)Math.PI)) * 0.1f));
                controller.rumble(0.0f, maxFreq, 80);
                break;
            }
            case field_8949: {
                float maxFreq = Math.min((float)ticks / 3.0f, 1.0f);
                controller.rumble(0.0f, maxFreq *= 0.15f, 80);
                break;
            }
            case field_8953: {
                float maxFreq = (float)ticks / 20.0f;
                maxFreq = (maxFreq * maxFreq + maxFreq * 2.0f) / 3.0f;
                maxFreq = class_3532.method_15363((float)maxFreq, (float)0.0f, (float)1.0f);
                controller.rumble(0.0f, maxFreq *= 0.15f, 80);
                break;
            }
            case field_8951: {
                float maxFreq = (float)ticks / 10.0f;
                maxFreq = class_3532.method_15363((float)maxFreq, (float)0.0f, (float)1.0f);
                controller.rumble(0.0f, maxFreq *= 0.15f, 80);
                break;
            }
            case field_8947: {
                if (ticks > 24) break;
                float maxFreq = (float)ticks / 20.0f;
                controller.rumble(0.0f, maxFreq *= 0.15f, 80);
                break;
            }
            case field_42717: {
                float maxFreq = (float)(ticks % 5) / 5.0f;
                maxFreq = class_3532.method_15363((float)maxFreq, (float)0.0f, (float)1.0f);
                controller.rumble(0.0f, maxFreq *= 0.2f, 80);
            }
        }
    }
}

