/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.binding;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.mrcrayfish.controllable.Constants;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.binding.KeyAdapterBinding;
import com.mrcrayfish.controllable.client.input.Buttons;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_304;
import net.minecraft.class_310;
import org.apache.commons.lang3.StringUtils;

public class BindingRegistry {
    private static BindingRegistry instance;
    private final List<ButtonBinding> bindings = new ArrayList<ButtonBinding>();
    private final Map<String, ButtonBinding> registeredBindings = new HashMap<String, ButtonBinding>();
    private final Map<String, KeyAdapterBinding> keyAdapters = new HashMap<String, KeyAdapterBinding>();
    private final Map<Integer, List<ButtonBinding>> idToButtonList = new HashMap<Integer, List<ButtonBinding>>();

    public static BindingRegistry getInstance() {
        if (instance == null) {
            instance = new BindingRegistry();
        }
        return instance;
    }

    private BindingRegistry() {
    }

    List<ButtonBinding> getRegisteredBindings() {
        return this.bindings;
    }

    List<ButtonBinding> getBindingListForButton(int button) {
        List<ButtonBinding> list = this.idToButtonList.get(button);
        return list != null ? ImmutableList.copyOf(list) : ImmutableList.of();
    }

    @Nullable
    public ButtonBinding getBindingByDescriptionKey(String key) {
        return Stream.concat(this.registeredBindings.values().stream(), this.keyAdapters.values().stream()).filter(binding -> binding.getDescription().equals(key)).findFirst().orElse(null);
    }

    public List<ButtonBinding> getBindings() {
        return ImmutableList.copyOf(this.bindings);
    }

    public Map<String, KeyAdapterBinding> getKeyAdapters() {
        return this.keyAdapters;
    }

    @Nullable
    public KeyAdapterBinding getKeyAdapterByDescriptionKey(String key) {
        return this.keyAdapters.get(key);
    }

    public void register(ButtonBinding binding) {
        Preconditions.checkArgument((!(binding instanceof KeyAdapterBinding) ? 1 : 0) != 0, (Object)"A key adapter binding can not be registered");
        if (this.registeredBindings.putIfAbsent(binding.getDescription(), binding) == null) {
            this.bindings.add(binding);
            if (binding.getButton() != -1) {
                this.idToButtonList.computeIfAbsent(binding.getButton(), i -> new ArrayList()).add(binding);
            }
        }
    }

    public void addKeyAdapter(KeyAdapterBinding binding) {
        if (this.keyAdapters.putIfAbsent(binding.getDescription(), binding) == null) {
            this.bindings.add(binding);
            if (binding.getButton() != -1) {
                this.idToButtonList.computeIfAbsent(binding.getButton(), i -> new ArrayList()).add(binding);
            }
            this.save();
        }
    }

    public void removeKeyAdapter(KeyAdapterBinding binding) {
        if (this.bindings.remove(binding)) {
            this.keyAdapters.remove(binding.getDescription());
            this.idToButtonList.remove(binding.getButton());
            this.save();
        }
    }

    public void resetBindingHash() {
        this.idToButtonList.clear();
        this.bindings.stream().filter(binding -> binding.getButton() != -1).forEach(binding -> this.idToButtonList.computeIfAbsent(binding.getButton(), i -> new ArrayList()).add(binding));
    }

    public void load() {
        BufferedReader reader;
        try {
            reader = Files.newReader((File)new File(Controllable.getConfigFolder(), "controllable/bindings.properties"), (Charset)Charsets.UTF_8);
            try {
                Properties properties = new Properties();
                properties.load(reader);
                this.registeredBindings.values().stream().filter(ButtonBinding::isNotReserved).forEach(binding -> {
                    String name = properties.getProperty(binding.getDescription(), Buttons.getNameForButton(binding.getButton()));
                    if (name != null) {
                        binding.setButton(Buttons.getButtonFromName(name));
                    }
                });
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            Constants.LOG.info("Skipped loading bindings.properties since it doesn't exist");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            reader = Files.newReader((File)new File(Controllable.getConfigFolder(), "controllable/key_adapters.properties"), (Charset)Charsets.UTF_8);
            try {
                HashMap<String, class_304> bindings = new HashMap<String, class_304>();
                for (class_304 mapping : class_310.method_1551().field_1690.field_1839) {
                    bindings.put(mapping.method_1431(), mapping);
                }
                Properties properties = new Properties();
                properties.load(reader);
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                    int button;
                    KeyAdapterBinding keyAdapter;
                    class_304 mapping = (class_304)bindings.get(key.toString());
                    if (mapping != null && this.keyAdapters.putIfAbsent((keyAdapter = new KeyAdapterBinding(button = Buttons.getButtonFromName((String)StringUtils.defaultIfEmpty((CharSequence)value.toString(), (CharSequence)"")), mapping)).getDescription(), keyAdapter) == null) {
                        this.bindings.add(keyAdapter);
                        if (keyAdapter.getButton() != -1) {
                            this.idToButtonList.computeIfAbsent(keyAdapter.getButton(), i -> new ArrayList()).add(keyAdapter);
                        }
                    }
                }));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            Constants.LOG.info("Skipped loading key_adapters.properties since it doesn't exist");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.resetBindingHash();
    }

    public void save() {
        File file;
        Properties properties;
        try {
            properties = new Properties();
            this.registeredBindings.values().stream().filter(ButtonBinding::isNotReserved).forEach(binding -> {
                String name = (String)StringUtils.defaultIfEmpty((CharSequence)Buttons.getNameForButton(binding.getButton()), (CharSequence)"");
                properties.put(binding.getDescription(), name);
            });
            file = new File(Controllable.getConfigFolder(), "controllable/bindings.properties");
            properties.store(new FileOutputStream(file), "Button Bindings");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            properties = new Properties();
            this.keyAdapters.values().stream().filter(ButtonBinding::isNotReserved).forEach(binding -> {
                String name = (String)StringUtils.defaultIfEmpty((CharSequence)Buttons.getNameForButton(binding.getButton()), (CharSequence)"");
                properties.put(binding.getKeyMapping().method_1431(), name);
            });
            file = new File(Controllable.getConfigFolder(), "controllable/key_adapters.properties");
            properties.store(new FileOutputStream(file), "Key Adapters");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        BindingRegistry.getInstance().register(ButtonBindings.JUMP);
        BindingRegistry.getInstance().register(ButtonBindings.SNEAK);
        BindingRegistry.getInstance().register(ButtonBindings.SPRINT);
        BindingRegistry.getInstance().register(ButtonBindings.OPEN_INVENTORY);
        BindingRegistry.getInstance().register(ButtonBindings.CLOSE_INVENTORY);
        BindingRegistry.getInstance().register(ButtonBindings.SWAP_HANDS);
        BindingRegistry.getInstance().register(ButtonBindings.DROP_ITEM);
        BindingRegistry.getInstance().register(ButtonBindings.USE_ITEM);
        BindingRegistry.getInstance().register(ButtonBindings.ATTACK);
        BindingRegistry.getInstance().register(ButtonBindings.PICK_BLOCK);
        BindingRegistry.getInstance().register(ButtonBindings.PLAYER_LIST);
        BindingRegistry.getInstance().register(ButtonBindings.TOGGLE_PERSPECTIVE);
        BindingRegistry.getInstance().register(ButtonBindings.SCREENSHOT);
        BindingRegistry.getInstance().register(ButtonBindings.SCROLL_LEFT);
        BindingRegistry.getInstance().register(ButtonBindings.SCROLL_RIGHT);
        BindingRegistry.getInstance().register(ButtonBindings.PAUSE_GAME);
        BindingRegistry.getInstance().register(ButtonBindings.NEXT_CREATIVE_TAB);
        BindingRegistry.getInstance().register(ButtonBindings.PREVIOUS_CREATIVE_TAB);
        BindingRegistry.getInstance().register(ButtonBindings.NEXT_RECIPE_TAB);
        BindingRegistry.getInstance().register(ButtonBindings.PREVIOUS_RECIPE_TAB);
        BindingRegistry.getInstance().register(ButtonBindings.NAVIGATE_UP);
        BindingRegistry.getInstance().register(ButtonBindings.NAVIGATE_DOWN);
        BindingRegistry.getInstance().register(ButtonBindings.NAVIGATE_LEFT);
        BindingRegistry.getInstance().register(ButtonBindings.NAVIGATE_RIGHT);
        BindingRegistry.getInstance().register(ButtonBindings.PICKUP_ITEM);
        BindingRegistry.getInstance().register(ButtonBindings.QUICK_MOVE);
        BindingRegistry.getInstance().register(ButtonBindings.SPLIT_STACK);
        BindingRegistry.getInstance().register(ButtonBindings.SOCIAL_INTERACTIONS);
        BindingRegistry.getInstance().register(ButtonBindings.ADVANCEMENTS);
        BindingRegistry.getInstance().register(ButtonBindings.HIGHLIGHT_PLAYERS);
        BindingRegistry.getInstance().register(ButtonBindings.CINEMATIC_CAMERA);
        BindingRegistry.getInstance().register(ButtonBindings.FULLSCREEN);
        BindingRegistry.getInstance().register(ButtonBindings.DEBUG_INFO);
        BindingRegistry.getInstance().register(ButtonBindings.RADIAL_MENU);
        Stream.of(ButtonBindings.HOTBAR_SLOTS).forEach(binding -> BindingRegistry.getInstance().register((ButtonBinding)binding));
        BindingRegistry.getInstance().register(ButtonBindings.TOGGLE_CRAFT_BOOK);
        BindingRegistry.getInstance().register(ButtonBindings.OPEN_CONTROLLABLE_SETTINGS);
        BindingRegistry.getInstance().register(ButtonBindings.OPEN_CHAT);
    }
}

