/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.binding;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.BindingRegistry;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.binding.IBindingContext;
import java.util.List;
import net.minecraft.class_1074;

public class ButtonBinding
implements Comparable<ButtonBinding> {
    private final int defaultButton;
    private final String descriptionKey;
    private final String category;
    private final IBindingContext context;
    private final boolean reserved;
    private int button;
    private boolean pressed;
    private int pressedTime;
    private boolean active;

    public ButtonBinding(int button, String descriptionKey, String category, IBindingContext context) {
        this(button, descriptionKey, category, context, false);
    }

    ButtonBinding(int button, String descriptionKey, String category, IBindingContext context, boolean reserved) {
        this.button = button;
        this.defaultButton = button;
        this.descriptionKey = descriptionKey;
        this.category = category;
        this.context = context;
        this.reserved = reserved;
    }

    public int getButton() {
        return this.button;
    }

    public void setButton(int button) {
        this.button = button;
    }

    public String getLabelKey() {
        return this.descriptionKey;
    }

    public String getDescription() {
        return this.descriptionKey;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isDefault() {
        return this.button == this.defaultButton;
    }

    protected void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public boolean isButtonPressed() {
        return this.pressed && this.pressedTime == 0 && this.isActiveAndValidContext();
    }

    public boolean isNotReserved() {
        return !this.reserved;
    }

    public boolean isButtonDown() {
        return this.pressed && this.isActiveAndValidContext();
    }

    public void reset() {
        this.button = this.defaultButton;
    }

    protected void onPressTick() {
    }

    public static void tick() {
        for (ButtonBinding binding : BindingRegistry.getInstance().getRegisteredBindings()) {
            if (binding.isButtonDown() || binding.active && ButtonBindings.RADIAL_MENU.isButtonDown()) {
                --binding.pressedTime;
            }
            if (!binding.active || ButtonBindings.RADIAL_MENU.isButtonDown()) continue;
            Controllable.getInput().handleButtonInput(Controllable.getController(), -1, false, true);
            binding.active = false;
            binding.setPressed(false);
        }
    }

    public static void setButtonState(int button, boolean state) {
        List<ButtonBinding> bindings = BindingRegistry.getInstance().getBindingListForButton(button);
        for (ButtonBinding binding : bindings) {
            binding.setPressed(state);
            if (!state) continue;
            binding.pressedTime = 0;
        }
    }

    public static void resetButtonStates() {
        for (ButtonBinding binding : BindingRegistry.getInstance().getRegisteredBindings()) {
            binding.pressed = false;
        }
    }

    @Override
    public int compareTo(ButtonBinding o) {
        return class_1074.method_4662((String)this.descriptionKey, (Object[])new Object[0]).compareTo(class_1074.method_4662((String)o.descriptionKey, (Object[])new Object[0]));
    }

    public boolean isConflictingContext() {
        List<ButtonBinding> bindings = BindingRegistry.getInstance().getBindingListForButton(this.button);
        if (bindings == null) {
            return false;
        }
        for (ButtonBinding binding : bindings) {
            if (!this.conflicts(binding)) continue;
            return true;
        }
        return false;
    }

    private boolean isActiveAndValidContext() {
        return this.context.isActive() && !this.isConflictingContext();
    }

    private boolean conflicts(ButtonBinding binding) {
        return this != binding && this.button == binding.getButton() && this.context.conflicts(binding.context);
    }

    public int hashCode() {
        return this.descriptionKey.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public void setActiveAndPressed() {
        this.active = true;
        this.setPressed(true);
        this.pressedTime = 0;
    }
}

