/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.ButtonBindingData;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.widget.ColorButton;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

public class RadialItemList
extends class_350<ButtonBindingEntry> {
    private final List<ButtonBindingData> bindings;
    private ButtonBinding selectedBinding;

    public RadialItemList(class_310 mc, int width, int height, int top, int bottom, List<ButtonBindingData> bindings) {
        super(mc, width, height, top, bottom, 36);
        this.bindings = bindings;
        this.updateEntries();
    }

    private void updateEntries() {
        this.method_25339();
        this.bindings.forEach(binding -> this.method_25321((class_350.class_351)new ButtonBindingEntry((ButtonBindingData)binding)));
        ButtonBindingEntry selected = this.method_25396().stream().filter(data -> data.getData().getBinding() == this.selectedBinding).findFirst().orElse(null);
        if (selected == null && this.method_25396().size() > 0) {
            selected = (ButtonBindingEntry)((Object)this.method_25396().get(0));
            this.selectedBinding = selected.getData().getBinding();
        }
        this.method_25313((class_350.class_351)selected);
    }

    public int method_25322() {
        return 260;
    }

    public int method_25342() {
        return super.method_25342();
    }

    public void method_37020(class_6382 output) {
    }

    class ButtonBindingEntry
    extends class_4265.class_4266<ButtonBindingEntry> {
        private final ButtonBindingData data;
        private final class_2561 description;
        private final class_4185 moveUpButton;
        private final class_4185 moveDownButton;
        private class_2561 label;
        private ColorButton colorButton;

        public ButtonBindingEntry(ButtonBindingData data) {
            this.data = data;
            this.description = class_2561.method_43471((String)data.getBinding().getCategory());
            this.moveUpButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 98, 35, 10, 10, button -> this.shiftBinding(false));
            this.moveDownButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 88, 35, 10, 10, button -> this.shiftBinding(true));
            this.label = class_2561.method_43471((String)data.getBinding().getLabelKey()).method_27692(data.getColor());
            this.colorButton = new ColorButton(0, 0, button -> {
                data.setColor(this.colorButton.getColor());
                this.label = this.label.method_27661().method_27692(this.colorButton.getColor());
            });
            this.colorButton.setColor(data.getColor());
            this.updateButtons();
        }

        public ButtonBindingData getData() {
            return this.data;
        }

        private void shiftBinding(boolean down) {
            List<ButtonBindingData> bindings = RadialItemList.this.bindings;
            int index = bindings.indexOf(this.data);
            bindings.remove(this.data);
            index = class_3532.method_15340((int)(index + (down ? 1 : -1)), (int)0, (int)bindings.size());
            bindings.add(index, this.data);
            this.updateButtons();
            RadialItemList.this.updateEntries();
        }

        private void updateButtons() {
            int index = RadialItemList.this.bindings.indexOf(this.data);
            this.moveUpButton.field_22763 = index > 0;
            this.moveDownButton.field_22763 = index < RadialItemList.this.bindings.size() - 1;
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)((Object)this.colorButton), (Object)this.moveUpButton, (Object)this.moveDownButton);
        }

        public void method_25343(class_332 graphics, int slotIndex, int top, int left, int listWidth, int slotHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            class_327 font = ((RadialItemList)RadialItemList.this).field_22740.field_1772;
            graphics.method_27535(font, this.label, left + 5, top + 5, 0xFFFFFF);
            graphics.method_27535(font, this.description, left + 5, top + 18, 0xFFFFFF);
            this.colorButton.field_22764 = RadialItemList.this.method_25334() == this;
            this.colorButton.method_46421(left + RadialItemList.this.method_25322() - 78);
            this.colorButton.method_46419(top + 6);
            this.colorButton.method_25394(graphics, mouseX, mouseY, partialTicks);
            this.moveUpButton.field_22764 = RadialItemList.this.method_25334() == this;
            this.moveUpButton.method_46421(left + RadialItemList.this.method_25322() - 34);
            this.moveUpButton.method_46419(top + 6);
            this.moveUpButton.method_25394(graphics, mouseX, mouseY, partialTicks);
            this.moveDownButton.field_22764 = RadialItemList.this.method_25334() == this;
            this.moveDownButton.method_46421(left + RadialItemList.this.method_25322() - 56);
            this.moveDownButton.method_46419(top + 6);
            this.moveDownButton.method_25394(graphics, mouseX, mouseY, partialTicks);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            RadialItemList.this.method_25313((class_350.class_351)this);
            RadialItemList.this.selectedBinding = this.data.getBinding();
            return super.method_25402(mouseX, mouseY, button);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 output) {
                    output.method_37034(class_6381.field_33788, ButtonBindingEntry.this.label);
                }
            });
        }
    }
}

