/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Icons;
import com.mrcrayfish.controllable.client.binding.BindingRegistry;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.ISearchable;
import com.mrcrayfish.controllable.client.gui.components.TabOptionBaseItem;
import com.mrcrayfish.controllable.client.gui.components.TabSelectionList;
import com.mrcrayfish.controllable.client.gui.screens.ConfirmationScreen;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.screens.SelectKeyBindingScreen;
import com.mrcrayfish.controllable.client.gui.screens.SettingsScreen;
import com.mrcrayfish.controllable.client.gui.widget.ButtonBindingButton;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

public class ButtonBindingList
extends TabSelectionList<TabSelectionList.BaseItem> {
    private final SettingsScreen settingsScreen;
    protected Map<String, List<ButtonBinding>> categories = new LinkedHashMap<String, List<ButtonBinding>>();

    public ButtonBindingList(SettingsScreen settingsScreen, class_310 mc, int itemHeight) {
        super(mc, itemHeight);
        this.settingsScreen = settingsScreen;
        this.categories.put("key.categories.movement", new ArrayList());
        this.categories.put("key.categories.gameplay", new ArrayList());
        this.categories.put("key.categories.inventory", new ArrayList());
        this.categories.put("key.categories.creative", new ArrayList());
        this.categories.put("key.categories.multiplayer", new ArrayList());
        this.categories.put("key.categories.ui", new ArrayList());
        this.categories.put("key.categories.misc", new ArrayList());
        this.categories.put("key.categories.controllable_custom", new ArrayList());
        this.repopulateBindings(false);
    }

    private void repopulateBindings(boolean showUnbound) {
        this.method_25339();
        class_5250 addKeybind = class_2561.method_43473().method_10852((class_2561)ClientHelper.getIconComponent(Icons.ADD)).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"controllable.gui.add_key_bind"));
        class_5250 restoreDefaults = class_2561.method_43473().method_10852((class_2561)ClientHelper.getIconComponent(Icons.RESET)).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"controllable.gui.restore_defaults"));
        this.addEntry(new TwoWidgetItem((class_339)class_4185.method_46430((class_2561)addKeybind, btn -> this.field_22740.method_1507((class_437)new SelectKeyBindingScreen(this.settingsScreen, () -> this.repopulateBindings(false)))).method_46431(), (class_339)class_4185.method_46430((class_2561)restoreDefaults, btn -> this.field_22740.method_1507((class_437)new ConfirmationScreen(this.settingsScreen, (class_2561)class_2561.method_43471((String)"controllable.gui.reset_selected_bindings"), result -> {
            if (result.booleanValue()) {
                BindingRegistry registry = BindingRegistry.getInstance();
                registry.getBindings().forEach(ButtonBinding::reset);
                registry.resetBindingHash();
                registry.save();
            }
            return true;
        }))).method_46431()));
        this.categories.forEach((category, list) -> list.clear());
        BindingRegistry.getInstance().getBindings().stream().filter(ButtonBinding::isNotReserved).forEach(binding -> {
            if (showUnbound && binding.getButton() != -1) {
                return;
            }
            List list = this.categories.computeIfAbsent(binding.getCategory(), category -> new ArrayList());
            list.add(binding);
        });
        this.categories.forEach((category, list) -> {
            if (!list.isEmpty()) {
                Collections.sort(list);
                this.addEntry(new TabSelectionList.TitleItem((TabSelectionList)this, (class_2561)class_2561.method_43471((String)category).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067})));
                list.forEach(binding -> this.addEntry(new ButtonBindingItem((ButtonBinding)binding)));
            }
        });
    }

    public static class TwoWidgetItem
    extends TabSelectionList.BaseItem {
        private final class_339 leftWidget;
        private final class_339 rightWidget;

        public TwoWidgetItem(class_339 leftWidget, class_339 rightWidget) {
            super(class_5244.field_39003);
            this.leftWidget = leftWidget;
            this.rightWidget = rightWidget;
        }

        @Override
        public void method_25343(class_332 graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTick) {
            this.leftWidget.method_25358(width / 2 - 10);
            this.leftWidget.method_46421(left + 5);
            this.leftWidget.method_46419(top);
            this.leftWidget.method_25394(graphics, mouseX, mouseY, partialTick);
            this.rightWidget.method_25358(width / 2 - 10);
            this.rightWidget.method_46421(left + width / 2 + 5);
            this.rightWidget.method_46419(top);
            this.rightWidget.method_25394(graphics, mouseX, mouseY, partialTick);
        }

        @Override
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.leftWidget, (Object)this.rightWidget);
        }
    }

    public class ButtonBindingItem
    extends TabOptionBaseItem
    implements ISearchable {
        private final ButtonBinding binding;
        private final class_4185 bindingButton;
        private final class_4185 resetButton;

        protected ButtonBindingItem(ButtonBinding binding) {
            super((class_2561)class_2561.method_43471((String)binding.getLabelKey()));
            this.binding = binding;
            this.bindingButton = new ButtonBindingButton(0, 0, binding, button -> {
                if (button == 0) {
                    ButtonBindingList.this.settingsScreen.setSelectedBinding(this.binding);
                    return true;
                }
                if (button == 1) {
                    this.binding.setButton(-1);
                    BindingRegistry registry = BindingRegistry.getInstance();
                    registry.resetBindingHash();
                    registry.save();
                    return true;
                }
                return false;
            });
            this.resetButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 108, 0, 16, 16, button -> {
                binding.reset();
                BindingRegistry registry = BindingRegistry.getInstance();
                registry.resetBindingHash();
                registry.save();
            });
        }

        private List<class_2561> getBindingTooltip(ButtonBinding binding) {
            if (Controllable.getInput().isControllerInUse()) {
                ArrayList<class_2561> components = new ArrayList<class_2561>();
                components.add((class_2561)class_2561.method_43469((String)"controllable.gui.change_binding", (Object[])new Object[]{ClientHelper.getButtonComponent(0)}).method_27692(class_124.field_1054));
                if (binding.getButton() != -1) {
                    components.add((class_2561)class_2561.method_43469((String)"controllable.gui.clear_binding", (Object[])new Object[]{ClientHelper.getButtonComponent(2)}).method_27692(class_124.field_1054));
                }
                return components;
            }
            ArrayList<class_2561> components = new ArrayList<class_2561>();
            components.add((class_2561)class_2561.method_43469((String)"controllable.gui.change_binding", (Object[])new Object[]{class_3675.class_307.field_1672.method_1447(0).method_27445().method_27661().method_27692(class_124.field_1068)}).method_27692(class_124.field_1054));
            if (binding.getButton() != -1) {
                components.add((class_2561)class_2561.method_43469((String)"controllable.gui.clear_binding", (Object[])new Object[]{class_3675.class_307.field_1672.method_1447(1).method_27445().method_27661().method_27692(class_124.field_1068)}).method_27692(class_124.field_1054));
            }
            return components;
        }

        @Override
        public class_2561 getLabel() {
            return this.label;
        }

        @Override
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.bindingButton, (Object)this.resetButton);
        }

        @Override
        public void method_25343(class_332 graphics, int index, int top, int left, int width, int itemHeight, int mouseX, int mouseY, boolean selected, float partialTick) {
            this.setLabelColor(this.binding.isConflictingContext() ? class_124.field_1061.method_532() : class_124.field_1068.method_532());
            super.method_25343(graphics, index, top, left, width, itemHeight, mouseX, mouseY, selected, partialTick);
            this.bindingButton.method_47400(ClientHelper.createListTooltip(this.getBindingTooltip(this.binding)));
            this.bindingButton.method_47402(400);
            this.bindingButton.method_46421(left + width - 65);
            this.bindingButton.method_46419(top - 1);
            this.bindingButton.method_25394(graphics, mouseX, mouseY, partialTick);
            this.resetButton.method_46421(left + width - 24);
            this.resetButton.method_46419(top - 1);
            this.resetButton.field_22763 = !this.binding.isDefault();
            this.resetButton.method_25394(graphics, mouseX, mouseY, partialTick);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (!this.resetButton.method_49606() && Controllable.getInput().isControllerInUse()) {
                this.bindingButton.method_25402((double)this.bindingButton.method_46426(), (double)this.bindingButton.method_46427(), button);
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        @Override
        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 output) {
                    output.method_37034(class_6381.field_33788, ButtonBindingItem.this.label);
                }
            });
        }
    }
}

