/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.gui.components.TabSelectionList;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.input.ControllerManager;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.commons.lang3.tuple.Pair;

public class ControllerList
extends TabSelectionList<ControllerEntry> {
    private static final class_2960 BEACON_TEXTURE = new class_2960("textures/gui/container/beacon.png");
    private final ControllerManager manager = Controllable.getManager();
    private final class_5250 footerSubText;
    private int controllerCount;

    public ControllerList(class_310 mc, int itemHeight) {
        super(mc, itemHeight);
        this.setHeaderText((class_2561)class_2561.method_43471((String)"controllable.gui.title.select_controller").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054}));
        this.footerSubText = class_2561.method_43471((String)"controllable.gui.controller_missing_2").method_27695(new class_124[]{class_124.field_1073, class_124.field_1065});
        this.footerSubText.method_10862(this.footerSubText.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11749, "https://mrcrayfish.gitbook.io/controllable-documentation/")));
        this.setFooterText((class_2561)class_2561.method_43469((String)"controllable.gui.controller_missing", (Object[])new Object[]{this.footerSubText}));
        this.reloadControllers();
    }

    private void reloadControllers() {
        this.method_25339();
        Map<Number, Pair<Integer, String>> controllers = this.manager.getControllers();
        controllers.forEach((jid, pair) -> this.addEntry(new ControllerEntry((Number)jid, (Integer)pair.getLeft(), (String)pair.getRight())));
        this.updateSelected();
    }

    protected boolean method_25332(int index) {
        return Objects.equals(this.method_25334(), this.method_25396().get(index));
    }

    private void updateSelected() {
        Controller controller = Controllable.getController();
        if (controller == null) {
            this.method_25313(null);
            return;
        }
        List entries = this.method_25396();
        for (ControllerEntry entry : entries) {
            if (!Objects.equals(entry.getJid(), controller.getJid())) continue;
            this.method_25313((class_350.class_351)entry);
            break;
        }
    }

    public void tick() {
        if (this.controllerCount != this.manager.getControllerCount()) {
            this.controllerCount = this.manager.getControllerCount();
            this.reloadControllers();
        }
        this.updateSelected();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int footerSubWidth;
        class_327 font;
        int footerWidth;
        if (this.footerText != null && ScreenHelper.isMouseWithin(this.field_19088 + (this.field_22742 + (footerWidth = (font = this.field_22740.field_1772).method_27525((class_5348)this.footerText))) / 2 - (footerSubWidth = font.method_27525((class_5348)this.footerSubText)), this.field_19086 + 4, footerSubWidth, 14, (int)mouseX, (int)mouseY)) {
            Objects.requireNonNull(class_310.method_1551().field_1755).method_25430(this.footerSubText.method_10866());
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public class ControllerEntry
    extends TabSelectionList.Item<ControllerEntry> {
        private final Number jid;
        private final int deviceIndex;

        public ControllerEntry(Number jid, int deviceIndex, String name) {
            super((class_2561)class_2561.method_43470((String)name));
            this.jid = jid;
            this.deviceIndex = deviceIndex;
        }

        public Number getJid() {
            return this.jid;
        }

        public int getDeviceIndex() {
            return this.deviceIndex;
        }

        public void method_25343(class_332 graphics, int slotIndex, int top, int left, int listWidth, int slotHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            if (ControllerList.this.method_25334() == this) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.method_25290(BEACON_TEXTURE, left + 3, top + 3, 91.0f, 224.0f, 14, 12, 256, 256);
            } else if (slotIndex % 2 != 0) {
                graphics.method_25294(left - 2, top - 2, left + listWidth + 2, top + slotHeight + 2, 0x55000000);
            }
            class_327 font = class_310.method_1551().field_1772;
            Objects.requireNonNull(font);
            graphics.method_27535(font, this.label, left + 22, top + (slotHeight - 9) / 2 + 1, 0xFFFFFF);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                if (ControllerList.this.method_25334() != this) {
                    ControllerList.this.method_25313((class_350.class_351)this);
                    ControllerList.this.manager.setActiveController(ControllerList.this.manager.createController(this.deviceIndex, this.jid));
                } else {
                    ControllerList.this.method_25313(null);
                    ControllerList.this.manager.setActiveController(null);
                }
            }
            return false;
        }
    }
}

