/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.gui.components.TabOptionBaseItem;
import com.mrcrayfish.controllable.client.gui.navigation.Navigatable;
import com.mrcrayfish.controllable.client.gui.widget.LazySlider;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import com.mrcrayfish.framework.api.config.DoubleProperty;
import com.mrcrayfish.framework.api.config.validate.NumberRange;
import com.mrcrayfish.framework.api.config.validate.Validator;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_7919;

public class TabOptionSliderItem
extends TabOptionBaseItem
implements Navigatable {
    private final LazySlider slider;
    private long lastChange;
    private boolean save;

    public TabOptionSliderItem(DoubleProperty property, double stepSize) {
        super((class_2561)class_2561.method_43471((String)property.getTranslationKey()));
        Validator validator = property.getValidator();
        if (!(validator instanceof NumberRange)) {
            throw new IllegalArgumentException("Double property must have a number range");
        }
        NumberRange range = (NumberRange)validator;
        this.slider = new LazySlider(0, 0, 100, 20, this.label, (Double)property.get(), (Double)range.minValue(), (Double)range.maxValue(), stepSize, arg_0 -> ((DoubleProperty)property).set(arg_0));
        this.slider.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)property.getComment())));
        this.slider.method_47402(500);
        this.slider.valueOnly();
    }

    @Override
    public List<? extends class_364> method_25396() {
        return ImmutableList.of((Object)((Object)this.slider));
    }

    @Override
    public List<class_364> elements() {
        return Collections.emptyList();
    }

    @Override
    public void method_25343(class_332 graphics, int slotIndex, int top, int left, int listWidth, int slotHeight, int mouseX, int mouseY, boolean hovered, float partialTick) {
        super.method_25343(graphics, slotIndex, top, left, listWidth, slotHeight, mouseX, mouseY, hovered, partialTick);
        this.slider.method_46421(left + listWidth - this.slider.method_25368() - 20);
        this.slider.method_46419(top);
        this.slider.method_25394(graphics, mouseX, mouseY, partialTick);
        if (Controllable.getInput().isControllerInUse() && ScreenHelper.isMouseWithin(left, top, listWidth, slotHeight, mouseX, mouseY)) {
            ClientHelper.drawButton(graphics, left + listWidth - this.slider.method_25368() - 20 - 17, top + (slotHeight - 11) / 2, 11);
            ClientHelper.drawButton(graphics, left + listWidth - 16, top + (slotHeight - 11) / 2, 12);
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastChange > 100L) {
                boolean changing = false;
                if (ButtonBindings.NEXT_RECIPE_TAB.isButtonDown()) {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14695, (float)0.7f, (float)0.25f));
                    this.slider.stepBackward();
                    this.lastChange = currentTime;
                    this.save = true;
                    changing = true;
                } else if (ButtonBindings.PREVIOUS_RECIPE_TAB.isButtonDown()) {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14695, (float)0.75f, (float)0.25f));
                    this.slider.stepForward();
                    this.lastChange = currentTime;
                    this.save = true;
                    changing = true;
                }
                if (!changing && this.save) {
                    this.slider.triggerChangeCallback();
                    this.save = false;
                }
            }
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.slider.method_25406(mouseX, mouseY, button);
    }
}

