/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.navigation;

import com.mrcrayfish.controllable.client.gui.navigation.HideCursor;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.SkipItem;
import com.mrcrayfish.controllable.platform.ClientServices;
import java.util.List;
import net.minecraft.class_350;
import net.minecraft.class_364;

public class ListEntryNavigationPoint
extends NavigationPoint {
    private final class_350<?> list;
    private final class_364 listEntry;
    private final int index;
    private final int itemHeight;
    private final int dir;
    private int itemY;
    private boolean hideCursor;

    public ListEntryNavigationPoint(class_350<?> list, class_364 listEntry, int index, int dir) {
        super(0.0, 0.0, NavigationPoint.Type.BASIC);
        this.list = list;
        this.listEntry = listEntry;
        this.index = index;
        this.itemHeight = ClientServices.CLIENT.getListItemHeight(this.list);
        this.dir = dir;
        this.itemY = ClientServices.CLIENT.getAbstractListRowTop(this.list, index) + this.itemHeight / 2 - 2;
    }

    @Override
    public double distanceTo(double x, double y) {
        return Math.sqrt(Math.pow(this.getX() - x, 2.0) + Math.pow(this.getY() - y, 2.0));
    }

    @Override
    public double getX() {
        return this.list.method_25342() + this.list.method_25322() / 2;
    }

    @Override
    public double getY() {
        return this.itemY;
    }

    @Override
    public void onNavigate() {
        double scroll;
        int skipIndex;
        int index = this.index;
        class_364 entry = this.listEntry;
        List children = this.list.method_25396();
        if (entry instanceof SkipItem && (skipIndex = index + this.dir) >= 0 && skipIndex < children.size()) {
            index = skipIndex;
            entry = (class_364)children.get(skipIndex);
        }
        if (index + this.dir == 0 && children.size() > 0 && children.get(0) instanceof SkipItem) {
            entry = (class_364)children.get(0);
        }
        this.hideCursor = entry instanceof HideCursor;
        int rowTop = ClientServices.CLIENT.getAbstractListRowTop(this.list, index);
        int rowBottom = ClientServices.CLIENT.getAbstractListRowBottom(this.list, index);
        int listTop = ClientServices.CLIENT.getAbstractListTop(this.list);
        int listBottom = ClientServices.CLIENT.getAbstractListBottom(this.list);
        if (rowTop < listTop + this.itemHeight / 2) {
            scroll = this.list.method_25396().indexOf(entry) * this.itemHeight - this.itemHeight / 2;
            this.list.method_25307(scroll);
        }
        if (rowBottom > listBottom - this.itemHeight / 2) {
            scroll = this.list.method_25396().indexOf(entry) * this.itemHeight + this.itemHeight - (listBottom - listTop) + 4 + this.itemHeight / 2;
            this.list.method_25307(scroll);
        }
        this.itemY = ClientServices.CLIENT.getAbstractListRowTop(this.list, index) + this.itemHeight / 2 - 2;
    }

    @Override
    public boolean shouldHide() {
        return this.hideCursor;
    }
}

