/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.gui.ControllerAxis;
import com.mrcrayfish.controllable.client.gui.ControllerButton;
import com.mrcrayfish.controllable.client.gui.screens.ThumbstickSettingsScreen;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import com.mrcrayfish.controllable.client.input.ButtonStates;
import com.mrcrayfish.controllable.client.input.Buttons;
import com.mrcrayfish.controllable.client.input.Controller;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class ControllerLayoutScreen
extends class_437 {
    public static final class_2960 TEXTURE = new class_2960("controllable", "textures/gui/controller.png");
    private final List<ControllerButton> controllerButtons = new ArrayList<ControllerButton>();
    private int configureButton = -1;
    private boolean validLayout;
    private final class_437 parentScreen;
    private final LayoutButtonStates states = new LayoutButtonStates();
    private class_4185 doneButton;
    private class_4185 resetButton;
    private class_4185 thumbstickButton;

    protected ControllerLayoutScreen(class_437 parentScreen) {
        super((class_2561)class_2561.method_43471((String)"controllable.gui.title.layout"));
        this.parentScreen = parentScreen;
    }

    protected void method_25426() {
        this.controllerButtons.clear();
        this.controllerButtons.add(new ControllerButton(this, 0, 29, 9, 7, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 1, 32, 6, 13, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 2, 26, 6, 16, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 3, 29, 3, 10, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 9, 5, -2, 25, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 10, 26, -2, 32, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 11, -10, 0, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(this, 12, 41, 0, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(this, 14, 6, 9, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 16, 9, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 15, 3, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 13, 6, 3, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 4, 14, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(this, 6, 21, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(this, 5, 17, 8, 46, 0, 4, 4, 5));
        this.controllerButtons.add(new ControllerAxis(this, 7, 9, 12, 0, 0, 7, 7, 5));
        this.controllerButtons.add(new ControllerAxis(this, 8, 22, 12, 0, 0, 7, 7, 5));
        this.doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"controllable.gui.save"), button -> Objects.requireNonNull(this.field_22787).method_1507(this.parentScreen)).method_46433(this.field_22789 / 2 - 154, this.field_22790 - 32).method_46437(100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> Objects.requireNonNull(this.field_22787).method_1507(this.parentScreen)).method_46433(this.field_22789 / 2 + 54, this.field_22790 - 32).method_46437(100, 20).method_46431());
        int width = 190;
        int x = this.field_22789 / 2 - width / 2;
        int y = this.field_22790 / 2 - 50 - 35;
        this.thumbstickButton = (class_4185)this.method_37063((class_364)new ImageButton(x + width / 2 - 10, y + 90, 20, TEXTURE, 92, 0, 16, 16, button -> Objects.requireNonNull(this.field_22787).method_1507((class_437)new ThumbstickSettingsScreen(this))));
    }

    public void method_25393() {
        this.doneButton.method_25355((class_2561)class_2561.method_43471((String)"controllable.gui.save").method_27692(this.validLayout ? class_124.field_1068 : class_124.field_1061));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        ArrayList<Object> components;
        this.method_25434(graphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        int width = 190;
        int height = 120;
        int x = this.field_22789 / 2 - width / 2;
        int y = this.field_22790 / 2 - 50 - 35;
        graphics.method_25293(TEXTURE, x, y, width, height, 50.0f, 0.0f, 38, 24, 256, 256);
        this.controllerButtons.forEach(controllerButton -> controllerButton.draw(graphics, x, y, mouseX, mouseY, this.configureButton == controllerButton.getButton()));
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        this.drawMultiLineCenteredString(graphics, this.field_22793, (class_2561)class_2561.method_43471((String)"controllable.gui.layout.info").method_27692(class_124.field_1080), x + width / 2, y + 135, width + 190, -1);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.configureButton != -1) {
            RenderSystem.disableDepthTest();
            graphics.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"controllable.gui.layout.press_button"), this.field_22789 / 2, this.field_22790 / 2, -1);
            RenderSystem.enableDepthTest();
            return;
        }
        ControllerButton button = this.controllerButtons.stream().filter(ControllerButton::isHovered).findFirst().orElse(null);
        if (button != null) {
            components = new ArrayList<Object>();
            components.add(class_2561.method_43469((String)"controllable.gui.layout.button", (Object[])new Object[]{class_2561.method_43471((String)Buttons.NAMES[button.getButton()]).method_27692(class_124.field_1078)}));
            components.add(class_2561.method_43471((String)"controllable.gui.layout.remap").method_27692(class_124.field_1080));
            graphics.method_51434(this.field_22793, components, mouseX, mouseY);
        }
        if (!this.validLayout && this.doneButton.method_25367()) {
            components = new ArrayList();
            components.add(class_2561.method_43471((String)"controllable.gui.layout.warning").method_27692(class_124.field_1061).method_30937());
            components.addAll(this.field_22793.method_1728((class_5348)class_2561.method_43471((String)"controllable.gui.layout.invalid_layout").method_27692(class_124.field_1080), 180));
            graphics.method_51447(this.field_22793, components, mouseX, mouseY - 50);
        }
        if (this.thumbstickButton.method_25367()) {
            graphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"controllable.gui.layout.thumbsticks"), mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        ControllerButton button;
        if (mouseButton == 0 && this.configureButton == -1 && (button = (ControllerButton)this.controllerButtons.stream().filter(ControllerButton::isHovered).findFirst().orElse(null)) != null) {
            this.configureButton = button.getButton();
            return true;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25404(int key, int scanCode, int mods) {
        if (key == 256 && this.configureButton != -1) {
            this.configureButton = -1;
            return true;
        }
        return super.method_25404(key, scanCode, mods);
    }

    public void processButton(int index, ButtonStates newStates) {
        boolean state = newStates.getState(index);
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (state) {
            if (!this.states.getState(index)) {
                this.states.setState(index, true);
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14699, (float)1.0f));
            }
        } else if (this.states.getState(index)) {
            this.states.setState(index, false);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14699, (float)0.9f));
        }
    }

    public boolean isButtonPressed(int button) {
        return this.states.getState(button);
    }

    private void drawMultiLineCenteredString(class_332 graphics, class_327 font, class_2561 component, int x, int y, int width, int color) {
        for (class_5481 s : font.method_1728((class_5348)component, width)) {
            graphics.method_35719(font, s, x - font.method_30880(s) / 2, y, color);
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    public static class LayoutButtonStates
    extends ButtonStates {
        @Override
        public void setState(int index, boolean state) {
            super.setState(index, state);
        }
    }
}

