/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.client.RadialMenuHandler;
import com.mrcrayfish.controllable.client.binding.BindingRegistry;
import com.mrcrayfish.controllable.client.binding.KeyAdapterBinding;
import com.mrcrayfish.controllable.client.gui.ISearchable;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.screens.ListMenuScreen;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

public abstract class KeyBindingListMenuScreen
extends ListMenuScreen {
    private static final List<class_304> DEFAULT_BINDINGS = (List)class_156.method_656(() -> {
        class_315 options = class_310.method_1551().field_1690;
        ArrayList<class_304> bindings = new ArrayList<class_304>();
        bindings.add(options.field_1886);
        bindings.add(options.field_1904);
        bindings.add(options.field_1894);
        bindings.add(options.field_1913);
        bindings.add(options.field_1881);
        bindings.add(options.field_1849);
        bindings.add(options.field_1903);
        bindings.add(options.field_1832);
        bindings.add(options.field_1867);
        bindings.add(options.field_1869);
        bindings.add(options.field_1822);
        bindings.add(options.field_1890);
        bindings.add(options.field_1907);
        bindings.add(options.field_1871);
        bindings.add(options.field_1845);
        bindings.add(options.field_1835);
        bindings.add(options.field_1824);
        bindings.add(options.field_1816);
        bindings.add(options.field_1836);
        bindings.add(options.field_1906);
        bindings.add(options.field_1831);
        bindings.add(options.field_1879);
        bindings.add(options.field_1874);
        bindings.add(options.field_1844);
        bindings.addAll(Arrays.asList(options.field_1852));
        bindings.add(options.field_26845);
        return ImmutableList.copyOf(bindings);
    });
    private final Map<String, List<class_304>> categories = new LinkedHashMap<String, List<class_304>>();

    protected KeyBindingListMenuScreen(class_437 parent, class_2561 title, int itemHeight) {
        super(parent, title, itemHeight);
        this.categories.put("key.categories.movement", new ArrayList());
        this.categories.put("key.categories.gameplay", new ArrayList());
        this.categories.put("key.categories.inventory", new ArrayList());
        this.categories.put("key.categories.creative", new ArrayList());
        this.categories.put("key.categories.multiplayer", new ArrayList());
        this.categories.put("key.categories.ui", new ArrayList());
        this.categories.put("key.categories.misc", new ArrayList());
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        this.updateList(entries);
    }

    public void updateList(List<ListMenuScreen.Item> entries) {
        this.categories.forEach((category, list) -> list.clear());
        Stream.of(Objects.requireNonNull(this.field_22787).field_1690.field_1839).filter(binding -> !DEFAULT_BINDINGS.contains(binding)).forEach(binding -> this.categories.computeIfAbsent(binding.method_1423(), category -> new ArrayList()).add(binding));
        this.categories.forEach((category, list) -> {
            if (!list.isEmpty()) {
                Collections.sort(list);
                entries.add(new ListMenuScreen.TitleItem((ListMenuScreen)this, (class_2561)class_2561.method_43471((String)category).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067})));
                list.forEach(binding -> entries.add(new KeyBindingItem((class_304)binding)));
            }
        });
    }

    protected void onChange() {
    }

    public class KeyBindingItem
    extends ListMenuScreen.Item
    implements ISearchable {
        private final class_304 mapping;
        private class_4185 addBinding;
        private class_4185 removeBinding;

        protected KeyBindingItem(class_304 mapping) {
            super((ListMenuScreen)KeyBindingListMenuScreen.this, (class_2561)class_2561.method_43471((String)mapping.method_1431()));
            this.mapping = mapping;
            Collection<KeyAdapterBinding> bindings = BindingRegistry.getInstance().getKeyAdapters().values();
            this.addBinding = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 88, 25, 10, 10, button -> {
                BindingRegistry.getInstance().addKeyAdapter(new KeyAdapterBinding(-1, this.mapping));
                this.addBinding.field_22763 = false;
                this.removeBinding.field_22763 = true;
                KeyBindingListMenuScreen.this.onChange();
            });
            this.removeBinding = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 98, 15, 10, 10, button -> {
                KeyAdapterBinding keyAdapter = BindingRegistry.getInstance().getKeyAdapterByDescriptionKey(this.mapping.method_1431() + ".custom");
                if (keyAdapter != null) {
                    BindingRegistry.getInstance().removeKeyAdapter(keyAdapter);
                    RadialMenuHandler.instance().removeBinding(keyAdapter);
                }
                this.addBinding.field_22763 = true;
                this.removeBinding.field_22763 = false;
                KeyBindingListMenuScreen.this.onChange();
            });
            this.addBinding.field_22763 = bindings.stream().noneMatch(entry -> entry.getKeyMapping() == this.mapping);
            this.removeBinding.field_22763 = bindings.stream().anyMatch(entry -> entry.getKeyMapping() == this.mapping);
        }

        @Override
        public class_2561 getLabel() {
            return this.label;
        }

        public void updateButtons() {
            Collection<KeyAdapterBinding> bindings = BindingRegistry.getInstance().getKeyAdapters().values();
            this.addBinding.field_22763 = bindings.stream().noneMatch(entry -> entry.getKeyMapping() == this.mapping);
            this.removeBinding.field_22763 = bindings.stream().anyMatch(entry -> entry.getKeyMapping() == this.mapping);
        }

        @Override
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.addBinding, (Object)this.removeBinding);
        }

        public void method_25343(class_332 graphics, int x, int y, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            class_327 font = ((KeyBindingListMenuScreen)KeyBindingListMenuScreen.this).field_22787.field_1772;
            graphics.method_27535(font, this.label, left, y + 6, 0xFFFFFF);
            this.addBinding.method_46421(left + width - 42);
            this.addBinding.method_46419(y);
            this.addBinding.method_25394(graphics, mouseX, mouseY, partialTicks);
            this.removeBinding.method_46421(left + width - 20);
            this.removeBinding.method_46419(y);
            this.removeBinding.method_25394(graphics, mouseX, mouseY, partialTicks);
        }

        @Override
        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 output) {
                    output.method_37034(class_6381.field_33788, KeyBindingItem.this.label);
                }
            });
        }
    }
}

