/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.client.gui.ISearchable;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public abstract class ListMenuScreen
extends class_437 {
    protected final class_437 parent;
    protected final int itemHeight;
    protected EntryList list;
    protected List<Item> entries;
    protected FocusedEditBox activeTextField;
    protected FocusedEditBox searchTextField;
    protected class_2561 subTitle;
    protected boolean searchBarVisible = true;
    protected int rowWidth = 240;

    protected ListMenuScreen(class_437 parent, class_2561 title, int itemHeight) {
        super(title);
        this.parent = parent;
        this.itemHeight = itemHeight;
    }

    public void setSubTitle(class_2561 subTitle) {
        this.subTitle = subTitle;
    }

    public void setSearchBarVisible(boolean visible) {
        this.searchBarVisible = visible;
    }

    public void setRowWidth(int rowWidth) {
        this.rowWidth = rowWidth;
    }

    protected void method_25426() {
        ArrayList<Item> entries = new ArrayList<Item>();
        this.constructEntries(entries);
        this.entries = ImmutableList.copyOf(entries);
        this.list = new EntryList(this.entries, this.calculateTop());
        this.list.method_31322(!ClientHelper.isPlayingGame());
        this.method_25429((class_364)this.list);
        this.searchTextField = new FocusedEditBox(this.field_22793, this.field_22789 / 2 - 110, this.calculateSearchBarY(), 220, 20, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchTextField.method_1863(s -> {
            this.updateSearchTextFieldSuggestion((String)s);
            this.list.method_25314(s.isEmpty() ? this.entries : (Collection)this.entries.stream().filter(item -> {
                ISearchable searchable;
                return item instanceof ISearchable && (searchable = (ISearchable)((Object)item)).getLabel().method_27662().toString().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH));
            }).collect(Collectors.toList()));
            if (!s.isEmpty()) {
                this.list.method_25307(0.0);
            }
        });
        this.method_25429((class_364)this.searchTextField);
        this.searchTextField.field_22764 = this.searchBarVisible;
        this.updateSearchTextFieldSuggestion("");
    }

    private int calculateTop() {
        int top = 30;
        if (this.searchBarVisible) {
            top += 20;
        }
        if (this.subTitle != null) {
            top += 14;
        }
        return top;
    }

    private int calculateSearchBarY() {
        return this.subTitle != null ? 36 : 22;
    }

    protected abstract void constructEntries(List<Item> var1);

    public void setActiveTooltip(@Nullable List<class_5481> tooltip) {
        if (tooltip != null) {
            this.method_47414(tooltip);
        }
    }

    protected void updateTooltip(int mouseX, int mouseY) {
        if (ScreenHelper.isMouseWithin(10, 13, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip(Objects.requireNonNull(this.field_22787).field_1772.method_1728((class_5348)class_2561.method_43471((String)"configured.gui.info"), 200));
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        this.list.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.searchTextField.method_25394(graphics, mouseX, mouseY, partialTicks);
        int titleY = 7 + (!this.searchBarVisible && this.subTitle == null ? 5 : 0);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, titleY, 0xFFFFFF);
        if (this.subTitle != null) {
            graphics.method_27534(this.field_22793, this.subTitle, this.field_22789 / 2, 21, 0xFFFFFF);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.updateTooltip(mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (ScreenHelper.isMouseWithin(10, 13, 23, 23, (int)mouseX, (int)mouseY)) {
            class_2583 style = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://www.curseforge.com/minecraft/mc-mods/configured"));
            this.method_25430(style);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected void updateSearchTextFieldSuggestion(String value) {
        if (!value.isEmpty()) {
            Optional<ISearchable> optional = this.entries.stream().filter(item -> item instanceof ISearchable).map(item -> (ISearchable)((Object)item)).filter(item -> item.getLabel().method_27662().toString().toLowerCase(Locale.ENGLISH).startsWith(value.toLowerCase(Locale.ENGLISH))).min(Comparator.comparing(item -> item.getLabel().method_27662().toString()));
            if (optional.isPresent()) {
                int length = value.length();
                String displayName = optional.get().getLabel().method_27662().toString();
                this.searchTextField.method_1887(displayName.substring(length));
            } else {
                this.searchTextField.method_1887("");
            }
        } else {
            this.searchTextField.method_1887(class_2561.method_43471((String)"controllable.gui.search").getString());
        }
    }

    protected class EntryList
    extends class_4265<Item> {
        public EntryList(List<Item> entries, int top) {
            super(Objects.requireNonNull(ListMenuScreen.this.field_22787), ListMenuScreen.this.field_22789, ListMenuScreen.this.field_22790, top, ListMenuScreen.this.field_22790 - 44, ListMenuScreen.this.itemHeight);
            entries.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        }

        protected int method_25329() {
            return this.field_22742 / 2 + ListMenuScreen.this.rowWidth / 2 + 10;
        }

        public int method_25322() {
            return ListMenuScreen.this.rowWidth;
        }

        public void method_25314(Collection<Item> entries) {
            super.method_25314(entries);
        }

        public boolean removeEntry(Item item) {
            return super.method_25330((class_350.class_351)item);
        }

        @Nullable
        public Item getHovered() {
            return (Item)super.method_37019();
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            super.method_25394(graphics, mouseX, mouseY, partialTicks);
            this.renderToolTips(graphics, mouseX, mouseY);
        }

        private void renderToolTips(class_332 graphics, int mouseX, int mouseY) {
            Item item2;
            if (this.method_25405(mouseX, mouseY) && mouseX < ListMenuScreen.this.list.method_25342() + ListMenuScreen.this.list.method_25322() - 67 && (item2 = (Item)this.method_25308(mouseX, mouseY)) != null) {
                ListMenuScreen.this.setActiveTooltip(item2.tooltip);
            }
            this.method_25396().forEach(item -> item.method_25396().forEach(o -> {
                if (o instanceof class_4185) {
                    // empty if block
                }
            }));
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            boolean wasDragging = this.method_25397();
            this.method_25398(false);
            if (wasDragging && this.method_25336() != null) {
                return ((Item)this.method_25336()).method_25406(mouseX, mouseY, button);
            }
            return false;
        }
    }

    protected class FocusedEditBox
    extends class_342 {
        public FocusedEditBox(class_327 font, int x, int y, int width, int height, class_2561 label) {
            super(font, x, y, width, height, label);
        }

        public void method_25365(boolean focused) {
            super.method_25365(focused);
            if (focused) {
                if (ListMenuScreen.this.activeTextField != null && ListMenuScreen.this.activeTextField != this) {
                    ListMenuScreen.this.activeTextField.method_25365(false);
                }
                ListMenuScreen.this.activeTextField = this;
            }
        }
    }

    public class TitleItem
    extends Item {
        public TitleItem(class_2561 title) {
            super(title);
        }

        public TitleItem(String title) {
            super((class_2561)class_2561.method_43470((String)title).method_27692(class_124.field_1067).method_27692(class_124.field_1054));
        }

        public void method_25343(class_332 graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            graphics.method_27534(Objects.requireNonNull(((ListMenuScreen)ListMenuScreen.this).field_22787).field_1772, this.label, left + width / 2, top + 5, 0xFFFFFF);
        }
    }

    protected abstract class Item
    extends class_4265.class_4266<Item> {
        protected final class_2561 label;
        protected List<class_5481> tooltip;

        public Item(class_2561 label) {
            this.label = label;
        }

        public Item(String label) {
            this.label = class_2561.method_43470((String)label);
        }

        public void setTooltip(class_2561 text, int maxWidth) {
            this.tooltip = Objects.requireNonNull(((ListMenuScreen)ListMenuScreen.this).field_22787).field_1772.method_1728((class_5348)text, maxWidth);
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 output) {
                    output.method_37034(class_6381.field_33788, Item.this.label);
                }
            });
        }
    }
}

