/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.ActionVisibility;
import com.mrcrayfish.controllable.client.ButtonIcons;
import com.mrcrayfish.controllable.client.CursorType;
import com.mrcrayfish.controllable.client.Icons;
import com.mrcrayfish.controllable.client.SneakMode;
import com.mrcrayfish.controllable.client.SprintMode;
import com.mrcrayfish.controllable.client.Thumbstick;
import com.mrcrayfish.controllable.client.binding.BindingRegistry;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.components.ButtonBindingList;
import com.mrcrayfish.controllable.client.gui.components.ControllerList;
import com.mrcrayfish.controllable.client.gui.components.TabOptionEnumItem;
import com.mrcrayfish.controllable.client.gui.components.TabOptionSliderItem;
import com.mrcrayfish.controllable.client.gui.components.TabOptionTitleItem;
import com.mrcrayfish.controllable.client.gui.components.TabOptionToggleItem;
import com.mrcrayfish.controllable.client.gui.components.TabSelectionList;
import com.mrcrayfish.controllable.client.gui.screens.ConfirmationScreen;
import com.mrcrayfish.controllable.client.gui.widget.TabListWidget;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import com.mrcrayfish.framework.api.config.AbstractProperty;
import com.mrcrayfish.framework.config.FrameworkConfigManager;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8086;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import net.minecraft.class_8089;

public class SettingsScreen
extends class_437 {
    @Nullable
    private final class_437 parent;
    private final class_8088 tabManager = new class_8088(x$0 -> {
        class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
    }, x$0 -> this.method_37066((class_364)x$0));
    private class_8030 tabArea;
    private class_8089 navigationBar;
    private class_4185 doneButton;
    private ButtonBinding selectedBinding;
    private int remainingTime;
    private int initialTab = 0;

    public SettingsScreen(@Nullable class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"controllable.settings"));
        this.parent = parent;
    }

    public SettingsScreen(@Nullable class_437 parent, int initialTab) {
        super((class_2561)class_2561.method_43471((String)"controllable.settings"));
        this.parent = parent;
        this.initialTab = initialTab;
    }

    @Nullable
    public class_437 getParent() {
        return this.parent;
    }

    protected void method_25426() {
        this.navigationBar = class_8089.method_48623((class_8088)this.tabManager, (int)this.field_22789).method_48631(new class_8087[]{new ControllerTab(), new SettingsTab(), new BindingsTab()}).method_48627();
        this.method_37063((class_364)this.navigationBar);
        this.navigationBar.method_48987(this.initialTab, false);
        this.doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, btn -> this.field_22787.method_1507(this.parent)).method_46433((this.field_22789 - 200) / 2, this.field_22790 - 25).method_46432(200).method_46431());
        this.method_48640();
    }

    protected void method_48640() {
        if (this.navigationBar != null) {
            this.navigationBar.method_48618(this.field_22789);
            this.navigationBar.method_49613();
            class_8030 navBarArea = this.navigationBar.method_48202();
            this.tabArea = new class_8030(0, navBarArea.comp_1197() - 1, this.field_22789, this.field_22790 - navBarArea.comp_1197() - 30);
            this.tabManager.method_48616(this.tabArea);
        }
        if (this.doneButton != null) {
            this.doneButton.method_46421((this.field_22789 - 200) / 2);
            this.doneButton.method_46419(this.field_22790 - 25);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double scroll) {
        if (super.method_25401(mouseX, mouseY, scroll)) {
            return true;
        }
        class_8087 currentTab = this.tabManager.method_48614();
        if (currentTab == null) {
            return false;
        }
        ArrayList widgets = new ArrayList();
        currentTab.method_48612(widgets::add);
        return widgets.stream().filter(widget -> widget.method_25405(mouseX, mouseY) && widget.method_25401(mouseX, mouseY, scroll)).count() > 0L;
    }

    public void method_25393() {
        this.tabManager.method_48617();
        if (this.isWaitingForButtonInput()) {
            --this.remainingTime;
            if (this.remainingTime <= 0) {
                this.selectedBinding = null;
            }
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25434(graphics);
        boolean waitingForInput = this.isWaitingForButtonInput();
        super.method_25394(graphics, !waitingForInput ? mouseX : -1, !waitingForInput ? mouseY : -1, partialTick);
        if (waitingForInput) {
            class_4587 stack = graphics.method_51448();
            stack.method_22903();
            stack.method_46416(0.0f, 0.0f, 100.0f);
            graphics.method_25296(0, 0, this.field_22789, this.field_22790, -535818224, -267382768);
            ScreenHelper.drawRoundedBox(graphics, (int)((double)this.field_22789 * 0.125), this.field_22790 / 4, (int)((double)this.field_22789 * 0.75), this.field_22790 / 2, -1728053248);
            class_5250 pressButtonLabel = class_2561.method_43471((String)"controllable.gui.waiting_for_input").method_27692(class_124.field_1054);
            graphics.method_27534(this.field_22793, (class_2561)pressButtonLabel, this.field_22789 / 2, this.field_22790 / 2 - 10, -1);
            class_5250 time = class_2561.method_43470((String)Integer.toString((int)Math.ceil((double)this.remainingTime / 20.0)));
            class_5250 inputCancelLabel = class_2561.method_43469((String)"controllable.gui.input_cancel", (Object[])new Object[]{time});
            graphics.method_27534(this.field_22793, (class_2561)inputCancelLabel, this.field_22789 / 2, this.field_22790 / 2 + 3, -1);
            stack.method_22909();
        }
    }

    public boolean method_25404(int key, int action, int modifiers) {
        if (key == 256 && this.selectedBinding != null) {
            this.selectedBinding = null;
            return true;
        }
        if (this.navigationBar.method_48988(key)) {
            return true;
        }
        return super.method_25404(key, action, modifiers);
    }

    public void setSelectedBinding(ButtonBinding binding) {
        if (this.tabManager.method_48614() instanceof BindingsTab) {
            this.selectedBinding = binding;
            this.remainingTime = 100;
        }
    }

    public boolean isWaitingForButtonInput() {
        if (this.selectedBinding != null && !(this.tabManager.method_48614() instanceof BindingsTab)) {
            this.selectedBinding = null;
        }
        return this.selectedBinding != null;
    }

    public boolean processButton(int index) {
        if (this.selectedBinding != null) {
            this.selectedBinding.setButton(index);
            this.selectedBinding = null;
            BindingRegistry registry = BindingRegistry.getInstance();
            registry.resetBindingHash();
            registry.save();
            return true;
        }
        return false;
    }

    public class ControllerTab
    extends class_8086 {
        private static final class_2561 TITLE = class_2561.method_43473().method_10852((class_2561)ClientHelper.getIconComponent(Icons.CONTROLLER)).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"controllable.settings.tab.controller.title"));
        private final ControllerList list;

        public ControllerTab() {
            super(TITLE);
            class_7845.class_7939 rootHelper = this.field_42139.method_48636(8).method_47610(1);
            this.list = new ControllerList(SettingsScreen.this.field_22787, 24);
            rootHelper.method_47612((class_8021)new TabListWidget(() -> SettingsScreen.this.tabArea, this.list));
        }

        public void method_48613() {
            this.list.tick();
        }
    }

    public class SettingsTab
    extends class_8086 {
        private static final class_2561 TITLE = class_2561.method_43473().method_10852((class_2561)ClientHelper.getIconComponent(Icons.SETTINGS)).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"controllable.settings.tab.settings.title"));

        public SettingsTab() {
            super(TITLE);
            class_310 mc = Objects.requireNonNull(SettingsScreen.this.field_22787);
            class_7845.class_7939 rootHelper = this.field_42139.method_48636(8).method_47610(1);
            TabSelectionList<TabSelectionList.BaseItem> optionsList = new TabSelectionList<TabSelectionList.BaseItem>(SettingsScreen.this.field_22787, 24);
            class_5250 updateMappings = ClientHelper.join(Icons.WORLD, (class_2561)class_2561.method_43471((String)"controllable.gui.update_mappings"));
            class_5250 restoreDefaults = ClientHelper.join(Icons.RESET, (class_2561)class_2561.method_43471((String)"controllable.gui.restore_defaults"));
            optionsList.addEntry(new ButtonBindingList.TwoWidgetItem((class_339)class_4185.method_46430((class_2561)updateMappings, btn -> {
                ConfirmationScreen updateConfirmation = new ConfirmationScreen(SettingsScreen.this, (class_2561)class_2561.method_43469((String)"controllable.gui.update_mapping_message", (Object[])new Object[]{class_2561.method_43470((String)"https://raw.githubusercontent.com/gabomdq/SDL_GameControllerDB/master/gamecontrollerdb.txt").method_27692(class_124.field_1054)}), result -> {
                    if (result.booleanValue()) {
                        Controllable.getManager().downloadMappings(SettingsScreen.this);
                        return false;
                    }
                    return true;
                });
                updateConfirmation.setPositiveText((class_2561)ClientHelper.join(Icons.DOWNLOAD, (class_2561)class_2561.method_43471((String)"controllable.gui.download")));
                updateConfirmation.setNegativeText(class_5244.field_24335);
                updateConfirmation.setIcon(ConfirmationScreen.Icon.INFO);
                mc.method_1507((class_437)updateConfirmation);
            }).method_46431(), (class_339)class_4185.method_46430((class_2561)restoreDefaults, btn -> mc.method_1507((class_437)new ConfirmationScreen(SettingsScreen.this, (class_2561)class_2561.method_43471((String)"controllable.gui.restore_defaults"), result -> {
                FrameworkConfigManager.FrameworkConfigImpl config;
                if (result.booleanValue() && (config = FrameworkConfigManager.getInstance().getConfig(Config.CLIENT_CONFIG_ID)) != null) {
                    config.getAllProperties().forEach(AbstractProperty::restoreDefault);
                    mc.method_1507((class_437)new SettingsScreen(SettingsScreen.this.parent, 1));
                    return false;
                }
                return true;
            }))).method_46431()));
            optionsList.addEntry(new TabOptionTitleItem((class_2561)class_2561.method_43471((String)"controllable.gui.title.gameplay").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054})));
            optionsList.addEntry(new TabOptionEnumItem<SneakMode>((class_2561)class_2561.method_43471((String)"controllable.gui.sneak_mode"), (class_2561)class_2561.method_43471((String)"controllable.gui.sneak_mode.desc"), () -> (Boolean)mc.field_1690.method_42449().method_41753() != false ? SneakMode.TOGGLE : SneakMode.HOLD, sneakMode -> {
                mc.field_1690.method_42449().method_41748((Object)(sneakMode == SneakMode.TOGGLE ? 1 : 0));
                mc.field_1690.method_1640();
            }));
            optionsList.addEntry(new TabOptionEnumItem<SprintMode>((class_2561)class_2561.method_43471((String)"controllable.gui.sprint_mode"), (class_2561)class_2561.method_43471((String)"controllable.gui.sprint_mode.desc"), () -> (Boolean)mc.field_1690.method_42450().method_41753() != false ? SprintMode.TOGGLE : SprintMode.ONCE, sprintMode -> {
                mc.field_1690.method_42450().method_41748((Object)(sprintMode == SprintMode.TOGGLE ? 1 : 0));
                mc.field_1690.method_1640();
            }));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.quickCraft));
            optionsList.addEntry(new TabOptionEnumItem<Thumbstick>(Config.CLIENT.client.options.radialThumbstick));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.spyglassSensitivity, 0.05));
            optionsList.addEntry(new TabOptionTitleItem((class_2561)class_2561.method_43471((String)"controllable.gui.title.camera").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054})));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.rotationSpeed, 1.0));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.pitchSensitivity, 0.01));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.yawSensitivity, 0.01));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.invertLook));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.invertRotation));
            optionsList.addEntry(new TabOptionTitleItem((class_2561)class_2561.method_43471((String)"controllable.gui.title.display").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054})));
            optionsList.addEntry(new TabOptionEnumItem<ButtonIcons>(Config.CLIENT.client.options.controllerIcons));
            optionsList.addEntry(new TabOptionEnumItem<ActionVisibility>(Config.CLIENT.client.options.showButtonHints));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.drawHintBackground));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.consoleHotbar));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.renderMiniPlayer));
            optionsList.addEntry(new TabOptionTitleItem((class_2561)class_2561.method_43471((String)"controllable.gui.title.controller").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054})));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.autoSelect));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.virtualCursor));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.thumbstickDeadZone, 0.01));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.triggerDeadZone, 0.01));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.cursorSpeed, 1.0));
            optionsList.addEntry(new TabOptionEnumItem<Thumbstick>(Config.CLIENT.client.options.cursorThumbstick));
            optionsList.addEntry(new TabOptionEnumItem<CursorType>(Config.CLIENT.client.options.cursorType));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.listScrollSpeed, 1.0));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.client.options.hoverModifier, 0.05));
            if (!class_310.field_1703) {
                optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.rumble));
            }
            optionsList.addEntry(new TabOptionTitleItem((class_2561)class_2561.method_43471((String)"controllable.gui.title.other").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054})));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.uiSounds));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.client.options.fpsPollingFix));
            rootHelper.method_47612((class_8021)new TabListWidget(() -> SettingsScreen.this.tabArea, optionsList));
        }
    }

    public class BindingsTab
    extends class_8086 {
        private static final class_2561 TITLE = class_2561.method_43473().method_10852((class_2561)ClientHelper.getIconComponent(Icons.BINDINGS)).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"controllable.settings.tab.bindings.title"));

        public BindingsTab() {
            super(TITLE);
            class_7845.class_7939 rootHelper = this.field_42139.method_48636(8).method_47610(1);
            rootHelper.method_47612((class_8021)new TabListWidget(() -> SettingsScreen.this.tabArea, new ButtonBindingList(SettingsScreen.this, SettingsScreen.this.field_22787, 22)));
        }
    }
}

