/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.widget;

import java.text.DecimalFormat;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_357;

public class LazySlider
extends class_357 {
    private static final DecimalFormat FORMATTER = new DecimalFormat("###0.###");
    private final class_2561 label;
    private final double minValue;
    private final double maxValue;
    private final double step;
    private final Consumer<Double> onChange;
    private boolean pressed = false;
    private boolean valueOnly = false;

    public LazySlider(int x, int y, int width, int height, class_2561 label, double initialValue, double minValue, double maxValue, double step, Consumer<Double> onChange) {
        super(x, y, width, height, label, LazySlider.parseValue(initialValue, step, minValue, maxValue));
        this.label = label;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
        this.onChange = onChange;
        this.method_25346();
    }

    public void valueOnly() {
        this.valueOnly = true;
        this.method_25346();
    }

    public void method_25348(double mouseX, double mouseY) {
        super.method_25348(mouseX, mouseY);
        this.pressed = true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.method_25351(button) && this.pressed) {
            this.onChange.accept(this.getValue());
            this.pressed = false;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.pressed && super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public double getValue() {
        double scale = 1.0 / this.step;
        double value = this.minValue + (this.maxValue - this.minValue) * this.field_22753;
        return (double)class_3532.method_15357((double)(value * scale)) / scale;
    }

    protected void method_25346() {
        if (this.valueOnly) {
            this.method_25355((class_2561)class_2561.method_43473().method_27693(FORMATTER.format(this.getValue())));
        } else {
            this.method_25355((class_2561)class_2561.method_43473().method_10852(this.label).method_27693(": ").method_27693(FORMATTER.format(this.getValue())));
        }
    }

    protected void method_25344() {
    }

    private static double parseValue(double value, double step, double minValue, double maxValue) {
        double range = Math.abs(maxValue - minValue);
        value -= minValue;
        return value /= range;
    }

    public void stepForward() {
        if (this.field_22753 < 1.0) {
            this.field_22753 = class_3532.method_15350((double)(this.field_22753 + this.step / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
            this.method_25346();
        }
    }

    public void stepBackward() {
        if (this.field_22753 > 0.0) {
            this.field_22753 = class_3532.method_15350((double)(this.field_22753 - this.step / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
            this.method_25346();
        }
    }

    public void triggerChangeCallback() {
        this.onChange.accept(this.getValue());
    }
}

