/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.input;

import com.mrcrayfish.controllable.client.input.ButtonStates;

public abstract class Controller {
    protected final int deviceIndex;
    protected final ButtonStates states;

    public Controller(int deviceIndex) {
        this.deviceIndex = deviceIndex;
        this.states = new ButtonStates();
    }

    public abstract boolean open();

    public abstract void close();

    public abstract Number getJid();

    public abstract boolean isOpen();

    public abstract ButtonStates createButtonsStates();

    public abstract String getName();

    public abstract boolean rumble(float var1, float var2, int var3);

    public abstract float getLTriggerValue();

    public abstract float getRTriggerValue();

    public abstract float getLThumbStickXValue();

    public abstract float getLThumbStickYValue();

    public abstract float getRThumbStickXValue();

    public abstract float getRThumbStickYValue();

    public int getDeviceIndex() {
        return this.deviceIndex;
    }

    public ButtonStates getButtonsStates() {
        return this.states;
    }

    public boolean isButtonPressed(int button) {
        return this.states.getState(button);
    }

    public boolean supportsRumble() {
        return false;
    }
}

