/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.input;

import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Constants;
import com.mrcrayfish.controllable.client.gui.screens.ConfirmationScreen;
import com.mrcrayfish.controllable.client.gui.screens.PendingScreen;
import com.mrcrayfish.controllable.client.gui.toasts.ConnectionToast;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.platform.Services;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ControllerManager {
    public static final String MAPPINGS_URL = "https://raw.githubusercontent.com/gabomdq/SDL_GameControllerDB/master/gamecontrollerdb.txt";
    protected Controller activeController;
    protected Map<Number, Pair<Integer, String>> controllers = new HashMap<Number, Pair<Integer, String>>();

    public abstract void init();

    public abstract void dispose();

    public abstract Controller createController(int var1, Number var2);

    @Nullable
    public abstract Controller connectToFirstGameController();

    public abstract void updateMappings(InputStream var1) throws IOException;

    protected abstract int getRawControllerCount();

    protected abstract Map<Number, Pair<Integer, String>> createRawControllerMap();

    public final void tick() {
        if (this.getRawControllerCount() == this.controllers.size()) {
            return;
        }
        Map<Number, Pair<Integer, String>> oldControllers = this.controllers;
        this.controllers = this.createRawControllerMap();
        oldControllers.keySet().removeIf(this.controllers::containsKey);
        Controller controller = this.getActiveController();
        if (controller != null && oldControllers.containsKey(controller.getJid())) {
            this.sendControllerToast(false, controller);
            this.setActiveController(null);
            controller = null;
        }
        if (controller == null && ((Boolean)Config.CLIENT.client.options.autoSelect.get()).booleanValue()) {
            controller = this.connectToFirstGameController();
            this.sendControllerToast(true, controller);
        }
    }

    protected void sendControllerToast(boolean connected, @Nullable Controller controller) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && controller != null) {
            mc.method_1566().method_1999((class_368)new ConnectionToast(connected, controller.getName()));
        }
    }

    public Map<Number, Pair<Integer, String>> getControllers() {
        return this.controllers;
    }

    @Nullable
    public Controller getActiveController() {
        return this.activeController;
    }

    public boolean setActiveController(Controller controller) {
        if (this.activeController != null) {
            this.activeController.close();
        }
        if (controller != null) {
            if (!controller.open()) {
                return false;
            }
            this.activeController = controller;
        } else {
            this.activeController = null;
        }
        return true;
    }

    public int getControllerCount() {
        return this.controllers.size();
    }

    public final void onClientFinishedLoading() {
        try (InputStream is = ControllerManager.class.getResourceAsStream("/gamecontrollerdb.txt");){
            if (is != null) {
                Constants.LOG.info("Applying gamepad mappings from internal database");
                this.updateMappings(is);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File mappings = new File(Services.PLATFORM.getConfigPath().resolve("controllable").toFile(), "gamecontrollerdb.txt");
        if (mappings.exists()) {
            Constants.LOG.info("Applying gamepad mappings from: {}", (Object)mappings);
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(mappings));){
                this.updateMappings(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (((Boolean)Config.CLIENT.client.options.autoSelect.get()).booleanValue()) {
            this.connectToFirstGameController();
        }
    }

    public void downloadMappings(@Nullable class_437 parentScreen) {
        Constants.LOG.info("Downloading mappings from: {}", (Object)MAPPINGS_URL);
        File mappings = new File(Services.PLATFORM.getConfigPath().resolve("controllable").toFile(), "gamecontrollerdb.txt");
        CompletableFuture.supplyAsync(() -> {
            class_310 mc = class_310.method_1551();
            mc.method_19537(() -> mc.method_1507((class_437)new PendingScreen((class_2561)class_2561.method_43471((String)"controllable.gui.downloading_mappings"))));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            try (BufferedInputStream in = new BufferedInputStream(new URL(MAPPINGS_URL).openStream());){
                Boolean bl;
                try (FileOutputStream fos = new FileOutputStream(mappings);){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = ((InputStream)in).read(buffer, 0, buffer.length)) != -1) {
                        fos.write(buffer, 0, length);
                    }
                    Constants.LOG.info("Finished downloading mappings");
                    bl = true;
                }
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }).thenAcceptAsync(success -> {
            if (success.booleanValue()) {
                Constants.LOG.info("Updating mappings...");
                class_310 mc = class_310.method_1551();
                mc.method_19537(() -> {
                    try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(mappings));){
                        this.updateMappings(is);
                        ConfirmationScreen infoScreen = new ConfirmationScreen(parentScreen, (class_2561)class_2561.method_43471((String)"controllable.gui.mappings_updated"), result -> true);
                        infoScreen.setPositiveText(class_5244.field_24339);
                        infoScreen.setNegativeText(null);
                        infoScreen.setIcon(ConfirmationScreen.Icon.INFO);
                        mc.method_1507((class_437)infoScreen);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        });
    }
}

