/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.input.glfw;

import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.client.input.ButtonStates;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import net.minecraft.class_1074;
import net.minecraft.class_3532;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWGamepadState;

public class GLFWController
extends Controller {
    private GLFWGamepadState controller;
    private String cachedName;

    public GLFWController(int deviceIndex) {
        super(deviceIndex);
    }

    @Override
    public boolean open() {
        this.controller = GLFWGamepadState.create();
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public Number getJid() {
        return this.deviceIndex;
    }

    @Override
    public boolean isOpen() {
        return this.controller != null && GLFW.glfwJoystickPresent((int)this.deviceIndex);
    }

    @Override
    public ButtonStates createButtonsStates() {
        GLFW.glfwGetGamepadState((int)this.deviceIndex, (GLFWGamepadState)this.controller);
        ButtonStates states = new ButtonStates();
        states.setState(0, this.readButton(0));
        states.setState(1, this.readButton(1));
        states.setState(2, this.readButton(2));
        states.setState(3, this.readButton(3));
        states.setState(4, this.readButton(6));
        states.setState(5, this.readButton(8));
        states.setState(6, this.readButton(7));
        states.setState(7, this.readButton(9));
        states.setState(8, this.readButton(10));
        states.setState(9, this.readButton(4));
        states.setState(10, this.readButton(5));
        states.setState(11, this.getLTriggerValue() >= 0.5f);
        states.setState(12, this.getRTriggerValue() >= 0.5f);
        states.setState(13, this.readButton(11));
        states.setState(14, this.readButton(13));
        states.setState(15, this.readButton(14));
        states.setState(16, this.readButton(12));
        return states;
    }

    private boolean readButton(int button) {
        return this.controller.buttons(button) == 1;
    }

    @Override
    public String getName() {
        if (GLFW.glfwJoystickPresent((int)this.deviceIndex)) {
            if (this.cachedName == null) {
                this.cachedName = GLFW.glfwGetGamepadName((int)this.deviceIndex);
            }
            return this.cachedName;
        }
        return class_1074.method_4662((String)"controllable.toast.controller", (Object[])new Object[0]);
    }

    @Override
    public boolean rumble(float lowFrequency, float highFrequency, int timeInMs) {
        return false;
    }

    @Override
    public float getLTriggerValue() {
        float input = class_3532.method_15363((float)((this.controller.axes(4) + 1.0f) / 2.0f), (float)0.0f, (float)1.0f);
        return ClientHelper.applyDeadzone(input, ((Double)Config.CLIENT.client.options.triggerDeadZone.get()).floatValue());
    }

    @Override
    public float getRTriggerValue() {
        float input = class_3532.method_15363((float)((this.controller.axes(5) + 1.0f) / 2.0f), (float)0.0f, (float)1.0f);
        return ClientHelper.applyDeadzone(input, ((Double)Config.CLIENT.client.options.triggerDeadZone.get()).floatValue());
    }

    @Override
    public float getLThumbStickXValue() {
        float input = class_3532.method_15363((float)this.controller.axes(0), (float)-1.0f, (float)1.0f);
        return ClientHelper.applyDeadzone(input, ((Double)Config.CLIENT.client.options.thumbstickDeadZone.get()).floatValue());
    }

    @Override
    public float getLThumbStickYValue() {
        float input = class_3532.method_15363((float)this.controller.axes(1), (float)-1.0f, (float)1.0f);
        return ClientHelper.applyDeadzone(input, ((Double)Config.CLIENT.client.options.thumbstickDeadZone.get()).floatValue());
    }

    @Override
    public float getRThumbStickXValue() {
        float input = class_3532.method_15363((float)this.controller.axes(2), (float)-1.0f, (float)1.0f);
        return ClientHelper.applyDeadzone(input, ((Double)Config.CLIENT.client.options.thumbstickDeadZone.get()).floatValue());
    }

    @Override
    public float getRThumbStickYValue() {
        float input = class_3532.method_15363((float)this.controller.axes(3), (float)-1.0f, (float)1.0f);
        return ClientHelper.applyDeadzone(input, ((Double)Config.CLIENT.client.options.thumbstickDeadZone.get()).floatValue());
    }
}

