/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.input.glfw;

import com.google.common.io.ByteStreams;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Constants;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.input.ControllerManager;
import com.mrcrayfish.controllable.client.input.glfw.GLFWController;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryUtil;

public class GLFWControllerManager
extends ControllerManager {
    @Override
    public void init() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public Controller createController(int deviceIndex, Number jid) {
        return new GLFWController(jid.intValue());
    }

    @Override
    @Nullable
    public Controller connectToFirstGameController() {
        if (((Boolean)Config.CLIENT.client.options.autoSelect.get()).booleanValue()) {
            for (int jid = 0; jid <= 15; ++jid) {
                GLFWController controller;
                if (!GLFW.glfwJoystickPresent((int)jid) || !GLFW.glfwJoystickIsGamepad((int)jid) || !this.setActiveController(controller = new GLFWController(jid))) continue;
                return controller;
            }
        }
        return null;
    }

    @Override
    public void updateMappings(InputStream is) throws IOException {
        byte[] bytes;
        ByteBuffer buffer;
        if (is != null && (buffer = MemoryUtil.memASCIISafe((CharSequence)new String(bytes = ByteStreams.toByteArray((InputStream)is)))) != null && GLFW.glfwUpdateGamepadMappings((ByteBuffer)buffer)) {
            Constants.LOG.info("Successfully updated gamepad mappings");
            return;
        }
        Constants.LOG.info("No gamepad mappings were updated");
    }

    @Override
    protected int getRawControllerCount() {
        int connectedCount = 0;
        for (int jid = 0; jid <= 15; ++jid) {
            if (!GLFW.glfwJoystickIsGamepad((int)jid)) continue;
            ++connectedCount;
        }
        return connectedCount;
    }

    @Override
    protected Map<Number, Pair<Integer, String>> createRawControllerMap() {
        HashMap<Number, Pair<Integer, String>> controllers = new HashMap<Number, Pair<Integer, String>>();
        for (int jid = 0; jid <= 15; ++jid) {
            if (!GLFW.glfwJoystickIsGamepad((int)jid)) continue;
            String controllerName = GLFW.glfwGetGamepadName((int)jid);
            controllers.put(jid, (Pair<Integer, String>)Pair.of((Object)jid, (Object)controllerName));
        }
        return controllers;
    }
}

