/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.input.sdl2;

import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.client.input.ButtonStates;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable_sdl.api.gamecontroller.SDL_GameController;
import com.mrcrayfish.controllable_sdl.api.gamecontroller.SdlGamecontroller;
import com.mrcrayfish.controllable_sdl.api.joystick.SDL_JoystickID;
import com.mrcrayfish.controllable_sdl.api.joystick.SdlJoystick;
import net.minecraft.class_1074;
import net.minecraft.class_3532;

public class SDL2Controller
extends Controller {
    private final SDL_JoystickID jid;
    private SDL_GameController controller;
    private String cachedName;

    public SDL2Controller(int deviceIndex) {
        super(deviceIndex);
        this.jid = SdlJoystick.SDL_JoystickGetDeviceInstanceID((int)deviceIndex);
        this.getName();
    }

    public SDL_JoystickID getJid() {
        return this.jid;
    }

    @Override
    public boolean open() {
        this.controller = SdlGamecontroller.SDL_GameControllerOpen((int)this.deviceIndex);
        return this.controller != null;
    }

    @Override
    public void close() {
        if (SdlGamecontroller.SDL_GameControllerGetAttached((SDL_GameController)this.controller)) {
            SdlGamecontroller.SDL_GameControllerClose((SDL_GameController)this.controller);
        }
    }

    @Override
    public boolean isOpen() {
        return SdlGamecontroller.SDL_GameControllerGetAttached((SDL_GameController)this.controller);
    }

    @Override
    public ButtonStates createButtonsStates() {
        SdlGamecontroller.SDL_GameControllerUpdate();
        ButtonStates states = new ButtonStates();
        states.setState(0, this.readButton(0));
        states.setState(1, this.readButton(1));
        states.setState(2, this.readButton(2));
        states.setState(3, this.readButton(3));
        states.setState(4, this.readButton(4));
        states.setState(5, this.readButton(5));
        states.setState(6, this.readButton(6));
        states.setState(7, this.readButton(7));
        states.setState(8, this.readButton(8));
        states.setState(9, this.readButton(9));
        states.setState(10, this.readButton(10));
        states.setState(11, this.getLTriggerValue() >= 0.5f);
        states.setState(12, this.getRTriggerValue() >= 0.5f);
        states.setState(13, this.readButton(11));
        states.setState(14, this.readButton(12));
        states.setState(15, this.readButton(13));
        states.setState(16, this.readButton(14));
        states.setState(17, this.readButton(15));
        states.setState(18, this.readButton(16));
        states.setState(19, this.readButton(17));
        states.setState(20, this.readButton(18));
        states.setState(21, this.readButton(19));
        states.setState(22, this.readButton(20));
        return states;
    }

    private boolean readButton(int button) {
        return SdlGamecontroller.SDL_GameControllerGetButton((SDL_GameController)this.controller, (int)button) == 1;
    }

    @Override
    public String getName() {
        if (SdlGamecontroller.SDL_IsGameController((int)this.deviceIndex)) {
            if (this.cachedName == null) {
                this.cachedName = SdlGamecontroller.SDL_GameControllerNameForIndex((int)this.deviceIndex);
            }
            return this.cachedName;
        }
        return class_1074.method_4662((String)"controllable.toast.controller", (Object[])new Object[0]);
    }

    @Override
    public boolean supportsRumble() {
        return SdlGamecontroller.SDL_GameControllerHasRumble((SDL_GameController)this.controller);
    }

    @Override
    public boolean rumble(float lowFrequency, float highFrequency, int timeInMs) {
        return SdlGamecontroller.SDL_GameControllerRumble((SDL_GameController)this.controller, (short)((short)(65535.0f * (lowFrequency = class_3532.method_15363((float)lowFrequency, (float)0.0f, (float)1.0f)))), (short)((short)(65535.0f * (highFrequency = class_3532.method_15363((float)highFrequency, (float)0.0f, (float)1.0f)))), (int)timeInMs) == 0;
    }

    @Override
    public float getLTriggerValue() {
        float input = class_3532.method_15363((float)((float)SdlGamecontroller.SDL_GameControllerGetAxis((SDL_GameController)this.controller, (int)4) / 32767.0f), (float)0.0f, (float)1.0f);
        return ClientHelper.applyDeadzone(input, ((Double)Config.CLIENT.client.options.triggerDeadZone.get()).floatValue());
    }

    @Override
    public float getRTriggerValue() {
        float input = class_3532.method_15363((float)((float)SdlGamecontroller.SDL_GameControllerGetAxis((SDL_GameController)this.controller, (int)5) / 32767.0f), (float)0.0f, (float)1.0f);
        return ClientHelper.applyDeadzone(input, ((Double)Config.CLIENT.client.options.triggerDeadZone.get()).floatValue());
    }

    @Override
    public float getLThumbStickXValue() {
        float input = class_3532.method_15363((float)((float)SdlGamecontroller.SDL_GameControllerGetAxis((SDL_GameController)this.controller, (int)0) / 32767.0f), (float)-1.0f, (float)1.0f);
        return ClientHelper.applyDeadzone(input, ((Double)Config.CLIENT.client.options.thumbstickDeadZone.get()).floatValue());
    }

    @Override
    public float getLThumbStickYValue() {
        float input = class_3532.method_15363((float)((float)SdlGamecontroller.SDL_GameControllerGetAxis((SDL_GameController)this.controller, (int)1) / 32767.0f), (float)-1.0f, (float)1.0f);
        return ClientHelper.applyDeadzone(input, ((Double)Config.CLIENT.client.options.thumbstickDeadZone.get()).floatValue());
    }

    @Override
    public float getRThumbStickXValue() {
        float input = class_3532.method_15363((float)((float)SdlGamecontroller.SDL_GameControllerGetAxis((SDL_GameController)this.controller, (int)2) / 32767.0f), (float)-1.0f, (float)1.0f);
        return ClientHelper.applyDeadzone(input, ((Double)Config.CLIENT.client.options.thumbstickDeadZone.get()).floatValue());
    }

    @Override
    public float getRThumbStickYValue() {
        float input = class_3532.method_15363((float)((float)SdlGamecontroller.SDL_GameControllerGetAxis((SDL_GameController)this.controller, (int)3) / 32767.0f), (float)-1.0f, (float)1.0f);
        return ClientHelper.applyDeadzone(input, ((Double)Config.CLIENT.client.options.thumbstickDeadZone.get()).floatValue());
    }
}

