/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.overlay;

import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Action;
import com.mrcrayfish.controllable.client.ActionDescriptions;
import com.mrcrayfish.controllable.client.ActionVisibility;
import com.mrcrayfish.controllable.client.ButtonIcons;
import com.mrcrayfish.controllable.client.RadialMenuHandler;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.overlay.IOverlay;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import com.mrcrayfish.controllable.platform.ClientServices;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_2237;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4174;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5348;

public class ActionHintOverlay
implements IOverlay {
    private final Map<Integer, Action> actions = new HashMap<Integer, Action>();

    @Override
    public boolean isVisible() {
        return !class_310.method_1551().field_1690.field_1842 && Controllable.getController() != null && Controllable.getInput().getLastUse() > 0;
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int[] positions = new int[2];
        for (int button : this.actions.keySet()) {
            Action.Side side;
            Action action = this.actions.get(button);
            Action.Side side2 = side = ClientHelper.isSubtitleShowing() ? Action.Side.LEFT : action.getSide();
            if (ClientHelper.isChatVisible() && side == Action.Side.LEFT && positions[0] >= 2) continue;
            int position = positions[side.ordinal()];
            this.drawHint(graphics, action, side, button, position);
            positions[side.ordinal()] = position + 1;
        }
    }

    private void drawHint(class_332 graphics, Action action, Action.Side side, int button, int position) {
        class_310 mc = class_310.method_1551();
        int size = 13;
        int texU = button * size;
        int texV = ((ButtonIcons)Config.CLIENT.client.options.controllerIcons.get()).ordinal() * size;
        int x = side == Action.Side.LEFT ? 5 : mc.method_22683().method_4486() - 5 - size;
        int y = mc.method_22683().method_4502() + position * -15 - size - 5;
        graphics.method_25290(ButtonIcons.TEXTURE, x, y, (float)texU, (float)texV, size, size, 299, ButtonIcons.TEXTURE_HEIGHT);
        int textWidth = mc.field_1772.method_27525((class_5348)action.getDescription());
        int labelX = side == Action.Side.LEFT ? x + 18 : x - 5 - textWidth;
        this.drawHintBackground(graphics, labelX, y, textWidth, 13);
        this.drawHintLabel(graphics, action.getDescription(), labelX, y + 3);
    }

    private void drawHintBackground(class_332 graphics, int x, int y, int width, int height) {
        if (((Boolean)Config.CLIENT.client.options.drawHintBackground.get()).booleanValue()) {
            class_310 mc = class_310.method_1551();
            int backgroundColor = mc.field_1690.method_19345(0.5f);
            ScreenHelper.drawRoundedBox(graphics, x, y, width, height, backgroundColor);
        }
    }

    private void drawHintLabel(class_332 graphics, class_2561 label, int x, int y) {
        class_310 mc = class_310.method_1551();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        graphics.method_27535(mc.field_1772, label, x, y, -1);
        graphics.method_51448().method_22909();
    }

    @Override
    public void tick() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1690.field_1842) {
            return;
        }
        this.actions.clear();
        ActionVisibility visibility = (ActionVisibility)Config.CLIENT.client.options.showButtonHints.get();
        if (visibility == ActionVisibility.NONE) {
            return;
        }
        boolean verbose = visibility == ActionVisibility.ALL;
        LinkedHashMap<ButtonBinding, Action> actionMap = new LinkedHashMap<ButtonBinding, Action>();
        class_437 class_4372 = mc.field_1755;
        if (class_4372 instanceof class_465) {
            class_465 containerScreen = (class_465)class_4372;
            if (mc.field_1724.field_7498.method_34255().method_7960()) {
                slot = ClientServices.CLIENT.getSlotUnderMouse(containerScreen);
                if (slot != null && slot.method_7681()) {
                    actionMap.put(ButtonBindings.PICKUP_ITEM, new Action(ActionDescriptions.PICKUP_STACK, Action.Side.LEFT));
                    actionMap.put(ButtonBindings.SPLIT_STACK, new Action(ActionDescriptions.SPLIT_STACK, Action.Side.LEFT));
                    actionMap.put(ButtonBindings.QUICK_MOVE, new Action(ActionDescriptions.QUICK_MOVE, Action.Side.LEFT));
                }
            } else {
                actionMap.put(ButtonBindings.PICKUP_ITEM, new Action(ActionDescriptions.PLACE_STACK, Action.Side.LEFT));
                actionMap.put(ButtonBindings.SPLIT_STACK, new Action(ActionDescriptions.PLACE_ITEM, Action.Side.LEFT));
                slot = ClientServices.CLIENT.getSlotUnderMouse(containerScreen);
                if (slot != null && slot.method_7681()) {
                    actionMap.put(ButtonBindings.QUICK_MOVE, new Action(ActionDescriptions.QUICK_MOVE, Action.Side.LEFT));
                }
            }
            actionMap.put(ButtonBindings.CLOSE_INVENTORY, new Action(ActionDescriptions.CLOSE_INVENTORY, Action.Side.RIGHT));
        } else if (mc.field_1755 == null) {
            if (RadialMenuHandler.instance().isVisible()) {
                if (RadialMenuHandler.instance().getSelected() != null) {
                    actionMap.put(ButtonBindings.RADIAL_MENU, new Action(ActionDescriptions.PERFORM_ACTION, Action.Side.RIGHT));
                } else {
                    actionMap.put(ButtonBindings.RADIAL_MENU, new Action(ActionDescriptions.CLOSE_MENU, Action.Side.RIGHT));
                }
            } else {
                class_1799 currentItem;
                class_1799 offHandStack;
                boolean blockHit = mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332;
                boolean canOpenBlock = false;
                if (blockHit) {
                    class_3965 blockHitResult = (class_3965)mc.field_1765;
                    boolean bl = canOpenBlock = mc.field_1687 != null && mc.field_1687.method_8320(blockHitResult.method_17777()).method_26204() instanceof class_2237;
                }
                if (!mc.field_1724.method_6115()) {
                    if (blockHit) {
                        actionMap.put(ButtonBindings.ATTACK, new Action(ActionDescriptions.BREAK, Action.Side.RIGHT));
                    } else {
                        actionMap.put(ButtonBindings.ATTACK, new Action(ActionDescriptions.ATTACK, Action.Side.RIGHT));
                    }
                }
                if ((offHandStack = mc.field_1724.method_6079()).method_7976() != class_1839.field_8952) {
                    switch (offHandStack.method_7976()) {
                        case field_8950: {
                            if (!mc.field_1724.method_7344().method_7587()) break;
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.EAT, Action.Side.RIGHT));
                            break;
                        }
                        case field_8946: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.DRINK, Action.Side.RIGHT));
                            break;
                        }
                        case field_8949: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.BLOCK, Action.Side.RIGHT));
                            break;
                        }
                        case field_8953: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.PULL_BOW, Action.Side.RIGHT));
                        }
                    }
                }
                if ((currentItem = mc.field_1724.method_6047()).method_7976() != class_1839.field_8952) {
                    switch (currentItem.method_7976()) {
                        case field_8950: {
                            class_4174 properties = currentItem.method_7909().method_19264();
                            if (properties == null || !mc.field_1724.method_7332(properties.method_19233())) break;
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.EAT, Action.Side.RIGHT));
                            break;
                        }
                        case field_8946: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.DRINK, Action.Side.RIGHT));
                            break;
                        }
                        case field_8949: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.BLOCK, Action.Side.RIGHT));
                            break;
                        }
                        case field_8953: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.PULL_BOW, Action.Side.RIGHT));
                        }
                    }
                } else if (currentItem.method_7909() instanceof class_1747) {
                    if (blockHit) {
                        actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.PLACE_BLOCK, Action.Side.RIGHT));
                    }
                } else if (!currentItem.method_7960() && !mc.field_1724.method_6115()) {
                    actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.USE_ITEM, Action.Side.RIGHT));
                }
                if (!mc.field_1724.method_18276() && blockHit && canOpenBlock && !mc.field_1724.method_6115()) {
                    actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.INTERACT, Action.Side.RIGHT));
                }
                if (verbose) {
                    actionMap.put(ButtonBindings.JUMP, new Action(ActionDescriptions.JUMP, Action.Side.LEFT));
                }
                actionMap.put(ButtonBindings.OPEN_INVENTORY, new Action(ActionDescriptions.OPEN_INVENTORY, Action.Side.LEFT));
                if (!(!verbose || mc.field_1724.method_6079().method_7960() && mc.field_1724.field_7512.method_34255().method_7960())) {
                    actionMap.put(ButtonBindings.SWAP_HANDS, new Action(ActionDescriptions.SWAP_HANDS, Action.Side.LEFT));
                }
                if (mc.field_1724.method_5765()) {
                    actionMap.put(ButtonBindings.SNEAK, new Action(ActionDescriptions.DISMOUNT, Action.Side.RIGHT));
                } else if (verbose) {
                    actionMap.put(ButtonBindings.SNEAK, new Action(ActionDescriptions.SNEAK, Action.Side.RIGHT));
                }
                if (!mc.field_1724.field_7498.method_34255().method_7960()) {
                    actionMap.put(ButtonBindings.DROP_ITEM, new Action(ActionDescriptions.DROP_ITEM, Action.Side.LEFT));
                }
            }
        }
        actionMap.forEach((binding, action) -> this.actions.put(binding.getButton(), (Action)action));
    }
}

