/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.integration;

import com.mrcrayfish.controllable.client.gui.navigation.BasicNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.WidgetNavigationPoint;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.DrawableWidget;
import dev.emi.emi.api.widget.TextureWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.screen.EmiScreenManager;
import dev.emi.emi.screen.RecipeScreen;
import dev.emi.emi.screen.RecipeTab;
import dev.emi.emi.screen.WidgetGroup;
import dev.emi.emi.widget.RecipeBackground;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_339;
import net.minecraft.class_437;

public class EmiSupport {
    private static final Field widgetGroupsField = EmiSupport.getField(RecipeScreen.class, "currentPage");
    private static final Field panelsField = EmiSupport.getField(EmiScreenManager.class, "panels");
    private static final Field recipeTabsField = EmiSupport.getField(RecipeScreen.class, "tabs");
    private static final Field tabField = EmiSupport.getField(RecipeScreen.class, "tab");
    private static final Field tabCountField = EmiSupport.getField(RecipeScreen.class, "tabPageSize");
    private static final Field tabPageField = EmiSupport.getField(RecipeScreen.class, "tabPage");
    private static final Field tabOffsetField = EmiSupport.getField(RecipeScreen.class, "tabOff");
    private static final Field xField = EmiSupport.getField(RecipeScreen.class, "x");
    private static final Field yField = EmiSupport.getField(RecipeScreen.class, "y");

    public static boolean invokeMouseClick(int button, double cursorX, double cursorY) {
        return EmiScreenManager.mouseClicked((double)cursorX, (double)cursorY, (int)button);
    }

    public static boolean invokeMouseReleased(int button, double cursorX, double cursorY) {
        return EmiScreenManager.mouseReleased((double)cursorX, (double)cursorY, (int)button);
    }

    public static boolean invokeMouseDragged(int button, double cursorX, double cursorY, double deltaX, double deltaY) {
        return EmiScreenManager.mouseDragged((double)cursorX, (double)cursorY, (int)button, (double)deltaX, (double)deltaY);
    }

    public static List<NavigationPoint> getNavigationPoints(class_437 screen) {
        int y;
        ArrayList<NavigationPoint> points = new ArrayList<NavigationPoint>();
        EmiSupport.addWidget(points, (class_339)EmiScreenManager.search);
        EmiSupport.addWidget(points, (class_339)EmiScreenManager.emi);
        EmiSupport.addWidget(points, (class_339)EmiScreenManager.tree);
        for (EmiScreenManager.SidebarPanel panel : EmiSupport.getPanels()) {
            if (!panel.isVisible()) continue;
            EmiSupport.addWidget(points, (class_339)panel.pageLeft);
            EmiSupport.addWidget(points, (class_339)panel.pageRight);
            EmiSupport.addWidget(points, (class_339)panel.cycle);
            block1: for (EmiScreenManager.ScreenSpace space : panel.getSpaces()) {
                int startIndex = panel.space == space ? space.pageSize * panel.page : 0;
                List stacks = space.getStacks();
                for (y = 0; y < space.th; ++y) {
                    for (int x = 0; x < space.getWidth(y); ++x) {
                        if (startIndex >= stacks.size()) continue block1;
                        int slotX = space.getX(x, y) + 9;
                        int slotY = space.getY(x, y) + 9;
                        points.add(new BasicNavigationPoint(slotX, slotY));
                    }
                }
            }
        }
        if (screen instanceof RecipeScreen) {
            RecipeScreen recipeScreen = (RecipeScreen)screen;
            List<RecipeTab> tabs = EmiSupport.getRecipeTabs(recipeScreen);
            int tab = EmiSupport.getInt(recipeScreen, tabField);
            int page = EmiSupport.getInt(recipeScreen, tabPageField);
            int count = EmiSupport.getInt(recipeScreen, tabCountField);
            int x = EmiSupport.getInt(recipeScreen, xField);
            y = EmiSupport.getInt(recipeScreen, yField);
            int offset = EmiSupport.getInt(recipeScreen, tabOffsetField);
            for (RecipeTab recipeTab : tabs) {
                int startIndex;
                int nextOffset = 0;
                int i = startIndex = page * count;
                while (i < tabs.size() && i < startIndex + count) {
                    int tabX = x + offset + nextOffset * 24 + 16 + 12;
                    int tabY = y - 24 + 13;
                    points.add(new BasicNavigationPoint(tabX, tabY));
                    ++i;
                    ++nextOffset;
                }
            }
            RecipeTab recipeTab = tabs.get(tab);
            int size = EmiApi.getRecipeManager().getWorkstations(recipeTab.category).size();
            if (size > 0 || RecipeScreen.resolve != null) {
                Bounds box = recipeScreen.getWorkstationBounds(-1);
                points.add(new BasicNavigationPoint((double)box.x() + (double)box.width() / 2.0, (double)box.y() + (double)box.height() / 2.0));
            }
            for (WidgetGroup group : EmiSupport.getWidgetGroups(recipeScreen)) {
                for (Widget widget : group.widgets) {
                    if (!EmiSupport.isValidWidget(widget)) continue;
                    Bounds box = widget.getBounds();
                    int widgetX = group.x + (int)((double)box.x() + (double)box.width() / 2.0);
                    int widgetY = group.y + (int)((double)box.y() + (double)box.height() / 2.0);
                    points.add(new BasicNavigationPoint(widgetX, widgetY));
                }
            }
        }
        return points;
    }

    private static boolean isValidWidget(Widget widget) {
        if (widget instanceof DrawableWidget) {
            return false;
        }
        if (widget instanceof TextureWidget) {
            return false;
        }
        return !(widget instanceof RecipeBackground);
    }

    private static void addWidget(List<NavigationPoint> points, class_339 widget) {
        if (widget.field_22764 && widget.field_22763) {
            points.add(new WidgetNavigationPoint(widget));
        }
    }

    private static List<EmiScreenManager.SidebarPanel> getPanels() {
        try {
            return (List)panelsField.get(null);
        }
        catch (IllegalAccessException e) {
            return Collections.emptyList();
        }
    }

    private static List<RecipeTab> getRecipeTabs(RecipeScreen screen) {
        try {
            return (List)recipeTabsField.get(screen);
        }
        catch (IllegalAccessException e) {
            return Collections.emptyList();
        }
    }

    private static List<WidgetGroup> getWidgetGroups(RecipeScreen screen) {
        try {
            return (List)widgetGroupsField.get(screen);
        }
        catch (IllegalAccessException e) {
            return Collections.emptyList();
        }
    }

    private static int getInt(Object instance, Field field) {
        try {
            return (Integer)field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getField(Class<?> targetClass, String fieldName) {
        try {
            Field field = targetClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

