/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.integration;

import com.mrcrayfish.controllable.client.gui.navigation.BasicNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.WidgetNavigationPoint;
import com.mrcrayfish.controllable.integration.ControllableJeiPlugin;
import com.mrcrayfish.controllable.mixin.client.jei.GuiIconToggleButtonAccessor;
import com.mrcrayfish.controllable.mixin.client.jei.IngredientGridAccessor;
import com.mrcrayfish.controllable.mixin.client.jei.IngredientGridWithNavigationAccessor;
import com.mrcrayfish.controllable.mixin.client.jei.IngredientListOverlayAccessor;
import com.mrcrayfish.controllable.mixin.client.jei.PageNavigationAccessor;
import com.mrcrayfish.controllable.mixin.client.jei.RecipeCatalystsAccessor;
import com.mrcrayfish.controllable.mixin.client.jei.RecipeGuiLayoutsAccessor;
import com.mrcrayfish.controllable.mixin.client.jei.RecipeGuiTabAccessor;
import com.mrcrayfish.controllable.mixin.client.jei.RecipeGuiTabsAccessor;
import com.mrcrayfish.controllable.mixin.client.jei.RecipesGuiAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.PageNavigation;
import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.gui.overlay.IngredientListRenderer;
import mezz.jei.gui.recipes.RecipeCatalysts;
import mezz.jei.gui.recipes.RecipeGuiLayouts;
import mezz.jei.gui.recipes.RecipeGuiTab;
import mezz.jei.gui.recipes.RecipeGuiTabs;
import mezz.jei.gui.recipes.RecipeLayoutWithButtons;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.library.gui.recipes.RecipeLayout;
import net.minecraft.class_339;
import net.minecraft.class_768;

public class JeiSupport {
    public static List<NavigationPoint> getNavigationPoints() {
        ArrayList<NavigationPoint> points = new ArrayList<NavigationPoint>();
        Optional.ofNullable(ControllableJeiPlugin.getRuntime()).ifPresent(runtime -> {
            if (runtime.getIngredientListOverlay().isListDisplayed()) {
                JeiSupport.getIngredientListRenderer(runtime).getSlots().forEach(slot -> {
                    ImmutableRect2i area = slot.getArea();
                    points.add(new BasicNavigationPoint((double)area.getX() + (double)area.getWidth() / 2.0, (double)area.getY() + (double)area.getHeight() / 2.0));
                });
                JeiSupport.getGridPageNavigation(runtime).ifPresent(nav -> {
                    JeiSupport.addWidget(points, (class_339)((PageNavigationAccessor)nav).controllableGetBackButton());
                    JeiSupport.addWidget(points, (class_339)((PageNavigationAccessor)nav).controllableGetNextButton());
                });
                GuiIconToggleButton configToggleButton = ((IngredientListOverlayAccessor)runtime.getIngredientListOverlay()).controllableGetConfigButton();
                GuiIconButton configButton = ((GuiIconToggleButtonAccessor)configToggleButton).controllableGetButton();
                points.add(new WidgetNavigationPoint((class_339)configButton));
                JeiSupport.getRecipeSlots(runtime).forEach(drawable -> {
                    class_768 area = drawable.getRect();
                    points.add(new BasicNavigationPoint((double)area.method_3321() + (double)area.method_3319() / 2.0, (double)area.method_3322() + (double)area.method_3320() / 2.0));
                });
                JeiSupport.getRecipeTabs(runtime).forEach(tab -> {
                    ImmutableRect2i area = ((RecipeGuiTabAccessor)tab).controllableGetArea();
                    points.add(new BasicNavigationPoint((double)area.getX() + (double)area.getWidth() / 2.0, (double)area.getY() + (double)area.getHeight() / 2.0));
                });
                JeiSupport.getRecipeTabPageNavigation(runtime).ifPresent(nav -> {
                    JeiSupport.addWidget(points, (class_339)((PageNavigationAccessor)nav).controllableGetBackButton());
                    JeiSupport.addWidget(points, (class_339)((PageNavigationAccessor)nav).controllableGetNextButton());
                });
                JeiSupport.getRecipeLayouts(runtime).forEach(layout -> {
                    IRecipeLayoutDrawable patt5088$temp;
                    ImmutableRect2i bookmarkArea;
                    ImmutableRect2i transferArea = ((GuiIconToggleButtonAccessor)layout.transferButton()).controllableGetArea();
                    if (!transferArea.isEmpty()) {
                        points.add(new BasicNavigationPoint((double)transferArea.getX() + (double)transferArea.getWidth() / 2.0, (double)transferArea.getY() + (double)transferArea.getHeight() / 2.0));
                    }
                    if (!(bookmarkArea = ((GuiIconToggleButtonAccessor)layout.bookmarkButton()).controllableGetArea()).isEmpty()) {
                        points.add(new BasicNavigationPoint((double)bookmarkArea.getX() + (double)bookmarkArea.getWidth() / 2.0, (double)bookmarkArea.getY() + (double)bookmarkArea.getHeight() / 2.0));
                    }
                    if ((patt5088$temp = layout.recipeLayout()) instanceof RecipeLayout) {
                        RecipeLayout recipeLayout = (RecipeLayout)patt5088$temp;
                        class_768 pos = recipeLayout.getRect();
                        int layoutX = pos.method_3321();
                        int layoutY = pos.method_3322();
                        for (IRecipeSlotDrawable drawable : recipeLayout.getRecipeSlots().getSlots()) {
                            class_768 area = drawable.getRect();
                            points.add(new BasicNavigationPoint((double)(layoutX + area.method_3321()) + (double)area.method_3319() / 2.0, (double)(layoutY + area.method_3322()) + (double)area.method_3320() / 2.0));
                        }
                    }
                });
            }
        });
        return points;
    }

    private static void addWidget(List<NavigationPoint> points, class_339 widget) {
        if (widget.field_22764 && widget.field_22763) {
            points.add(new WidgetNavigationPoint(widget));
        }
    }

    private static IngredientListRenderer getIngredientListRenderer(IJeiRuntime runtime) {
        IngredientGridWithNavigation a = ((IngredientListOverlayAccessor)runtime.getIngredientListOverlay()).controllableGetContents();
        IngredientGrid b = ((IngredientGridWithNavigationAccessor)a).controllableGetIngredientGrid();
        return ((IngredientGridAccessor)b).controllableGetIngredientListRenderer();
    }

    private static Optional<PageNavigation> getGridPageNavigation(IJeiRuntime runtime) {
        IngredientGridWithNavigation grid = ((IngredientListOverlayAccessor)runtime.getIngredientListOverlay()).controllableGetContents();
        PageNavigation navigation = ((IngredientGridWithNavigationAccessor)grid).controllableGetNavigation();
        if (((PageNavigationAccessor)navigation).controllableIsVisible()) {
            return Optional.of(navigation);
        }
        return Optional.empty();
    }

    private static List<IRecipeSlotDrawable> getRecipeSlots(IJeiRuntime runtime) {
        IRecipesGui iRecipesGui = runtime.getRecipesGui();
        if (iRecipesGui instanceof RecipesGui) {
            RecipesGui gui = (RecipesGui)iRecipesGui;
            RecipeCatalysts catalysts = ((RecipesGuiAccessor)gui).controllableGetCatalysts();
            return ((RecipeCatalystsAccessor)catalysts).controllableGetRecipeSlots();
        }
        return Collections.emptyList();
    }

    private static List<RecipeGuiTab> getRecipeTabs(IJeiRuntime runtime) {
        IRecipesGui iRecipesGui = runtime.getRecipesGui();
        if (iRecipesGui instanceof RecipesGui) {
            RecipesGui gui = (RecipesGui)iRecipesGui;
            RecipeGuiTabs tabs = ((RecipesGuiAccessor)gui).controllableGetRecipeGuiTabs();
            return ((RecipeGuiTabsAccessor)tabs).controllableGetTabs();
        }
        return Collections.emptyList();
    }

    private static Optional<PageNavigation> getRecipeTabPageNavigation(IJeiRuntime runtime) {
        RecipesGui gui;
        RecipeGuiTabs tabs;
        PageNavigation navigation;
        IRecipesGui iRecipesGui = runtime.getRecipesGui();
        if (iRecipesGui instanceof RecipesGui && ((PageNavigationAccessor)(navigation = ((RecipeGuiTabsAccessor)(tabs = ((RecipesGuiAccessor)(gui = (RecipesGui)iRecipesGui)).controllableGetRecipeGuiTabs())).controllableGetNavigation())).controllableIsVisible()) {
            return Optional.of(navigation);
        }
        return Optional.empty();
    }

    private static List<RecipeLayoutWithButtons<?>> getRecipeLayouts(IJeiRuntime runtime) {
        IRecipesGui iRecipesGui = runtime.getRecipesGui();
        if (iRecipesGui instanceof RecipesGui) {
            RecipesGui gui = (RecipesGui)iRecipesGui;
            RecipeGuiLayouts layouts = ((RecipesGuiAccessor)gui).controllableGetLayouts();
            return ((RecipeGuiLayoutsAccessor)layouts).controllableGetRecipeLayouts();
        }
        return Collections.emptyList();
    }
}

