/*
 * Decompiled with CFR 0.152.
 */
package daniel.cushypillows.block;

import daniel.cushypillows.block.CushyPillowsBlocks;
import daniel.cushypillows.block.entity.CushyPillowsBlockEntities;
import daniel.cushypillows.block.entity.PillowBlockEntity;
import daniel.cushypillows.particle.CushyPillowsParticleTypes;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_7718;
import org.jetbrains.annotations.Nullable;

public class PillowBlock
extends class_2237 {
    private static final float BOUNCE_MODIFIER = 0.66f;
    private static final Map<class_1767, class_2248> COLORED_PILLOWS = new EnumMap<class_1767, class_2248>(class_1767.class);
    public static final class_2758 ROTATION = class_2741.field_12532;
    public static final class_2746 ATTACHED = class_2741.field_12493;
    public static final class_2746 TRIMMED = class_2746.method_11825((String)"trimmed");
    private static final class_265 DEFAULT = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);
    private static final class_265 BED = class_2248.method_9541((double)2.6, (double)-7.0, (double)1.9f, (double)11.0, (double)-4.5, (double)13.6f);
    private final class_1767 color;

    protected PillowBlock(class_1767 color) {
        super(class_4970.class_2251.method_9637().method_9618().method_36557(1.0f).method_31710(color.method_7794()).method_9626(class_2498.field_11543).method_50012(class_3619.field_15971).method_50013());
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(0))).method_11657((class_2769)ATTACHED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)TRIMMED, (Comparable)Boolean.valueOf(false)));
        this.color = color;
        COLORED_PILLOWS.put(color, (class_2248)this);
    }

    public void method_9502(class_1922 world, class_1297 entity) {
        if (entity.method_21750()) {
            super.method_9502(world, entity);
            return;
        }
        this.bounceEntity(entity);
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        super.method_9554(world, state, pos, entity, fallDistance);
        if (fallDistance < 1.0f) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos);
        this.squish(world, blockEntity, pos);
    }

    private void bounceEntity(class_1297 entity) {
        class_243 vel = entity.method_18798();
        if (vel.field_1351 < 0.0) {
            double y = entity instanceof class_1309 ? 1.0 : 0.8;
            entity.method_18800(vel.field_1352, -vel.field_1351 * (double)0.66f * y, vel.field_1350);
        }
    }

    public class_1767 getColor() {
        return this.color;
    }

    private void squish(class_1937 world, class_2586 blockEntity, class_2338 pos) {
        if (!(blockEntity instanceof PillowBlockEntity)) {
            return;
        }
        PillowBlockEntity pillowBlockEntity = (PillowBlockEntity)blockEntity;
        world.method_8396(null, pos, class_3417.field_14983, class_3419.field_15245, 1.0f, 1.0f);
        pillowBlockEntity.squish();
        PillowBlock.spawnFeatherParticles(world, pos, 3);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (hand == class_1268.field_5808 && player.method_5715() && player.method_5998(hand).method_7960()) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)TRIMMED, (Comparable)Boolean.valueOf((Boolean)state.method_11654((class_2769)TRIMMED) == false)));
            world.method_33596((class_1297)player, class_5712.field_28733, pos);
            return class_1269.field_5812;
        }
        class_2586 blockEntity = world.method_8321(pos);
        this.squish(world, blockEntity, pos);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_174.field_24478.method_23889(serverPlayer, pos, player.method_5998(hand));
        }
        return class_1269.field_5812;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof PillowBlockEntity)) {
            return super.method_9574(world, pos, state);
        }
        PillowBlockEntity pillowBlockEntity = (PillowBlockEntity)blockEntity;
        return pillowBlockEntity.getPickStack();
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == class_2350.field_11033 && !state.method_26184((class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(class_7718.method_45479((float)(ctx.method_8044() + 180.0f))))).method_11657((class_2769)ATTACHED, (Comparable)Boolean.valueOf(ctx.method_8045().method_8320(ctx.method_8037().method_10074()).method_26164(class_3481.field_16443)))).method_11657((class_2769)TRIMMED, (Comparable)Boolean.valueOf(false));
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return world.method_8320(pos.method_10074()).method_51367();
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (Boolean)state.method_11654((class_2769)ATTACHED) != false ? BED : DEFAULT;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{ROTATION});
        builder.method_11667(new class_2769[]{ATTACHED});
        builder.method_11667(new class_2769[]{TRIMMED});
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (world.field_9236) {
            world.method_35230(pos, CushyPillowsBlockEntities.PILLOW).ifPresent(pillow -> pillow.readFrom(itemStack));
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PillowBlockEntity(pos, state);
    }

    public static class_2248 getForColor(class_1767 color) {
        return COLORED_PILLOWS.getOrDefault(color, CushyPillowsBlocks.WHITE_PILLOW);
    }

    public static void spawnFeatherParticles(class_1937 world, class_2338 pos, int count) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199((class_2394)CushyPillowsParticleTypes.FEATHERS, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.2f), (double)((float)pos.method_10260() + 0.5f), count, 0.2, 0.0, 0.2, 0.0);
        }
    }
}

