/*
 * Decompiled with CFR 0.152.
 */
package daniel.cushypillows.block.entity;

import daniel.cushypillows.block.PillowBlock;
import daniel.cushypillows.block.entity.CushyPillowsBlockEntities;
import daniel.cushypillows.util.PatternEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2573;
import net.minecraft.class_2582;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class PillowBlockEntity
extends class_2586 {
    public static final String PATTERNS_KEY = "Patterns";
    public static final String PATTERN_KEY = "Pattern";
    public static final String COLOR_KEY = "Color";
    private class_1767 baseColor;
    private class_2499 patternListNbt;
    private List<PatternEntry> patterns;
    private long lastSquishTime;

    public PillowBlockEntity(class_2338 pos, class_2680 state) {
        super(CushyPillowsBlockEntities.PILLOW, pos, state);
        this.baseColor = ((PillowBlock)state.method_26204()).getColor();
    }

    public long getLastSquishTime() {
        return this.lastSquishTime;
    }

    public List<PatternEntry> getPatterns() {
        if (this.patterns == null) {
            this.patterns = PillowBlockEntity.getPatternsFromNbt(this.patternListNbt);
        }
        return this.patterns;
    }

    public class_1767 getBaseColor() {
        return this.baseColor;
    }

    public void readFrom(class_1799 stack, class_1767 baseColor) {
        this.baseColor = baseColor;
        this.readFrom(stack);
    }

    public void readFrom(class_1799 stack) {
        this.patternListNbt = class_2573.method_24281((class_1799)stack);
        this.patterns = null;
    }

    public boolean method_11004(int type, int data) {
        if (this.field_11863 != null && type == 1) {
            this.lastSquishTime = this.field_11863.method_8510();
            return true;
        }
        return super.method_11004(type, data);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.patternListNbt != null) {
            nbt.method_10566(PATTERNS_KEY, (class_2520)this.patternListNbt);
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.patternListNbt = nbt.method_10554(PATTERNS_KEY, 10);
        this.patterns = null;
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void squish() {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8427(this.method_11016(), this.method_11010().method_26204(), 1, 0);
        }
    }

    public class_1799 getPickStack() {
        class_1799 bannerStack = new class_1799((class_1935)PillowBlock.getForColor(this.baseColor));
        if (this.patternListNbt != null && !this.patternListNbt.isEmpty()) {
            class_2487 nbtCompound = new class_2487();
            nbtCompound.method_10566(PATTERNS_KEY, (class_2520)this.patternListNbt.method_10612());
            class_1747.method_38073((class_1799)bannerStack, (class_2591)this.method_11017(), (class_2487)nbtCompound);
        }
        return bannerStack;
    }

    private static List<PatternEntry> getPatternsFromNbt(@Nullable class_2499 patternListNbt) {
        ArrayList<PatternEntry> result = new ArrayList<PatternEntry>();
        if (patternListNbt == null) {
            return result;
        }
        for (int i = 0; i < patternListNbt.size(); ++i) {
            class_2487 nbtCompound = patternListNbt.method_10602(i);
            class_6880 bannerPatternEntry = class_2582.method_10946((String)nbtCompound.method_10558(PATTERN_KEY));
            if (bannerPatternEntry == null) continue;
            int colorId = nbtCompound.method_10550(COLOR_KEY);
            result.add(new PatternEntry((class_6880<class_2582>)bannerPatternEntry, class_1767.method_7791((int)colorId)));
        }
        return result;
    }
}

