/*
 * Decompiled with CFR 0.152.
 */
package daniel.cushypillows.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import daniel.cushypillows.block.CushyPillowsBlocks;
import daniel.cushypillows.block.PillowBlock;
import daniel.cushypillows.block.entity.CushyPillowsBlockEntities;
import daniel.cushypillows.entity.CushyPillowsEntities;
import daniel.cushypillows.item.CushyPillowsItems;
import daniel.cushypillows.recipe.CushyPillowsRecipeTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricAdvancementProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_117;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_189;
import net.minecraft.class_192;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2019;
import net.minecraft.class_2022;
import net.minecraft.class_2048;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2115;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_3837;
import net.minecraft.class_44;
import net.minecraft.class_4550;
import net.minecraft.class_4711;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4942;
import net.minecraft.class_4945;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5646;
import net.minecraft.class_5651;
import net.minecraft.class_5658;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7446;
import net.minecraft.class_77;
import net.minecraft.class_7800;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8129;
import net.minecraft.class_8508;

public class CushyPillowsDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator dataGenerator) {
        FabricDataGenerator.Pack pack = dataGenerator.createPack();
        pack.addProvider(PillowTagProvider::new);
        pack.addProvider(PillowModelProvider::new);
        pack.addProvider(PillowRecipeProvider::new);
        pack.addProvider(PillowAdvancementProvider::new);
        pack.addProvider(PillowLootTableProvider::new);
    }

    public static class PillowRecipeProvider
    extends FabricRecipeProvider {
        public PillowRecipeProvider(FabricDataOutput output) {
            super(output);
        }

        public void method_10419(Consumer<class_2444> exporter) {
            EnumMap dyeToWool = (EnumMap)class_156.method_654((Object)Maps.newEnumMap(class_1767.class), map -> {
                map.put(class_1767.field_7952, class_2246.field_10446);
                map.put(class_1767.field_7946, class_2246.field_10095);
                map.put(class_1767.field_7958, class_2246.field_10215);
                map.put(class_1767.field_7951, class_2246.field_10294);
                map.put(class_1767.field_7947, class_2246.field_10490);
                map.put(class_1767.field_7961, class_2246.field_10028);
                map.put(class_1767.field_7954, class_2246.field_10459);
                map.put(class_1767.field_7944, class_2246.field_10423);
                map.put(class_1767.field_7967, class_2246.field_10222);
                map.put(class_1767.field_7955, class_2246.field_10619);
                map.put(class_1767.field_7945, class_2246.field_10259);
                map.put(class_1767.field_7966, class_2246.field_10514);
                map.put(class_1767.field_7957, class_2246.field_10113);
                map.put(class_1767.field_7942, class_2246.field_10170);
                map.put(class_1767.field_7964, class_2246.field_10314);
                map.put(class_1767.field_7963, class_2246.field_10146);
            });
            List dyes = Arrays.stream(class_1767.values()).map(class_1769::method_7803).collect(Collectors.toUnmodifiableList());
            List<class_1792> pillows = Arrays.stream(class_1767.values()).map(dye -> PillowBlock.getForColor(dye).method_8389()).toList();
            class_2446.method_51890(exporter, dyes, pillows, (String)"pillows");
            for (class_1767 color : class_1767.values()) {
                class_2248 pillow = PillowBlock.getForColor(color);
                class_2248 wool = (class_2248)dyeToWool.get(color);
                class_2447.method_10437((class_7800)class_7800.field_40634, (class_1935)pillow).method_10439("WFW").method_10434(Character.valueOf('F'), (class_1935)class_1802.field_8153).method_10434(Character.valueOf('W'), (class_1935)wool.method_8389()).method_10435("pillows").method_10429(PillowRecipeProvider.method_32807((class_1935)wool), (class_184)PillowRecipeProvider.method_10426((class_1935)wool.method_8389())).method_49380(true).method_17972(exporter, new class_2960("cushypillows", PillowRecipeProvider.method_36450((class_1935)pillow)));
            }
        }
    }

    private static class PillowModelProvider
    extends FabricModelProvider {
        private PillowModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
            class_4942 templatePillow = new class_4942(Optional.of(new class_2960("cushypillows", "item/template_pillow")), Optional.empty(), new class_4945[0]);
            blockStateModelGenerator.method_25585(new class_2960("cushypillows", "block/pillow"), class_2246.field_10446).method_25713(templatePillow, new class_2248[]{CushyPillowsBlocks.WHITE_PILLOW, CushyPillowsBlocks.ORANGE_PILLOW, CushyPillowsBlocks.MAGENTA_PILLOW, CushyPillowsBlocks.LIGHT_BLUE_PILLOW, CushyPillowsBlocks.YELLOW_PILLOW, CushyPillowsBlocks.LIME_PILLOW, CushyPillowsBlocks.PINK_PILLOW, CushyPillowsBlocks.GRAY_PILLOW, CushyPillowsBlocks.LIGHT_GRAY_PILLOW, CushyPillowsBlocks.CYAN_PILLOW, CushyPillowsBlocks.PURPLE_PILLOW, CushyPillowsBlocks.BLUE_PILLOW, CushyPillowsBlocks.BROWN_PILLOW, CushyPillowsBlocks.GREEN_PILLOW, CushyPillowsBlocks.RED_PILLOW, CushyPillowsBlocks.BLACK_PILLOW});
        }

        public void generateItemModels(class_4915 itemModelGenerator) {
            class_4942 parent = new class_4942(Optional.of(new class_2960("cushypillows", "item/template_pillow")), Optional.empty(), new class_4945[0]);
        }
    }

    private static class PillowTagProvider
    extends FabricTagProvider.BlockTagProvider {
        public PillowTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 arg) {
            FabricTagProvider.FabricTagBuilder builder = this.getOrCreateTagBuilder(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("cushypillows", "pillows")));
            builder.add((Object[])new class_2248[]{CushyPillowsBlocks.WHITE_PILLOW, CushyPillowsBlocks.ORANGE_PILLOW, CushyPillowsBlocks.MAGENTA_PILLOW, CushyPillowsBlocks.LIGHT_BLUE_PILLOW, CushyPillowsBlocks.YELLOW_PILLOW, CushyPillowsBlocks.LIME_PILLOW, CushyPillowsBlocks.PINK_PILLOW, CushyPillowsBlocks.GRAY_PILLOW, CushyPillowsBlocks.LIGHT_GRAY_PILLOW, CushyPillowsBlocks.CYAN_PILLOW, CushyPillowsBlocks.PURPLE_PILLOW, CushyPillowsBlocks.BLUE_PILLOW, CushyPillowsBlocks.BROWN_PILLOW, CushyPillowsBlocks.GREEN_PILLOW, CushyPillowsBlocks.RED_PILLOW, CushyPillowsBlocks.BLACK_PILLOW});
        }
    }

    private static class PillowAdvancementProvider
    extends FabricAdvancementProvider {
        protected PillowAdvancementProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateAdvancement(Consumer<class_161> consumer) {
            class_161 husbandryRoot = class_161.class_162.method_707().method_695(new class_2960("husbandry/root"));
            class_161 root = class_161.class_162.method_707().method_701(husbandryRoot).method_697((class_1935)CushyPillowsItems.LIGHT_BLUE_PILLOW.method_8389(), (class_2561)class_2561.method_43471((String)"advancements.husbandry.pillow.root.title"), (class_2561)class_2561.method_43471((String)"advancements.husbandry.pillow.root.desc"), null, class_189.field_1254, true, true, false).method_709("get_pillows", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977(new class_1935[]{CushyPillowsItems.WHITE_PILLOW, CushyPillowsItems.ORANGE_PILLOW, CushyPillowsItems.MAGENTA_PILLOW, CushyPillowsItems.LIGHT_BLUE_PILLOW, CushyPillowsItems.YELLOW_PILLOW, CushyPillowsItems.LIME_PILLOW, CushyPillowsItems.PINK_PILLOW, CushyPillowsItems.GRAY_PILLOW, CushyPillowsItems.LIGHT_GRAY_PILLOW, CushyPillowsItems.CYAN_PILLOW, CushyPillowsItems.PURPLE_PILLOW, CushyPillowsItems.BLUE_PILLOW, CushyPillowsItems.BROWN_PILLOW, CushyPillowsItems.GREEN_PILLOW, CushyPillowsItems.RED_PILLOW, CushyPillowsItems.BLACK_PILLOW}).method_8976()})).method_704(class_193.field_1257).method_695(new class_2960("cushypillows", "husbandry/root"));
            class_1799 creeperPillow = new class_1799((class_1935)CushyPillowsItems.LIME_PILLOW);
            class_2487 nbtCompound = new class_2487();
            class_2499 nbtList = new class_2582.class_3750().method_43720(class_7446.field_39146, class_1767.field_7963).method_16375();
            nbtCompound.method_10566("Patterns", (class_2520)nbtList);
            class_1747.method_38073((class_1799)creeperPillow, CushyPillowsBlockEntities.PILLOW, (class_2487)nbtCompound);
            class_161 craftPillowPattern = class_161.class_162.method_707().method_701(root).method_20416(creeperPillow, (class_2561)class_2561.method_43471((String)"advancements.husbandry.pillow.pattern.title"), (class_2561)class_2561.method_43471((String)"advancements.husbandry.pillow.pattern.desc"), null, class_189.field_1254, true, true, false).method_709("craft_pattern_pillow", (class_184)class_8508.class_8509.method_51352((class_2960)new class_2960(CushyPillowsRecipeTypes.PILLOW_DECORATION.toString()))).method_704(class_193.field_16882).method_695(new class_2960("cushypillows", "husbandry/pattern"));
            class_161 featherBurst = class_161.class_162.method_707().method_701(root).method_697((class_1935)class_1802.field_8153.method_8389(), (class_2561)class_2561.method_43471((String)"advancements.husbandry.pillow.feather_burst.title"), (class_2561)class_2561.method_43471((String)"advancements.husbandry.pillow.feather_burst.desc"), null, class_189.field_1254, true, true, false).method_709("interact_pillow", (class_184)class_4711.class_4712.method_27981((class_2090.class_2091)class_2090.class_2091.method_22484().method_27989(class_4550.class_4710.method_23880().method_27962(new class_2248[]{CushyPillowsBlocks.WHITE_PILLOW, CushyPillowsBlocks.ORANGE_PILLOW, CushyPillowsBlocks.MAGENTA_PILLOW, CushyPillowsBlocks.LIGHT_BLUE_PILLOW, CushyPillowsBlocks.YELLOW_PILLOW, CushyPillowsBlocks.LIME_PILLOW, CushyPillowsBlocks.PINK_PILLOW, CushyPillowsBlocks.GRAY_PILLOW, CushyPillowsBlocks.LIGHT_GRAY_PILLOW, CushyPillowsBlocks.CYAN_PILLOW, CushyPillowsBlocks.PURPLE_PILLOW, CushyPillowsBlocks.BLUE_PILLOW, CushyPillowsBlocks.BROWN_PILLOW, CushyPillowsBlocks.GREEN_PILLOW, CushyPillowsBlocks.RED_PILLOW, CushyPillowsBlocks.BLACK_PILLOW}).method_23882()), (class_2073.class_2074)class_2073.class_2074.method_8973())).method_704(class_193.field_16882).method_695(new class_2960("cushypillows", "husbandry/feather_burst"));
            class_161 pillowFight = class_161.class_162.method_707().method_701(featherBurst).method_697((class_1935)CushyPillowsItems.RED_PILLOW, (class_2561)class_2561.method_43471((String)"advancements.husbandry.pillow.pillow_fight.title"), (class_2561)class_2561.method_43471((String)"advancements.husbandry.pillow.pillow_fight.desc"), null, class_189.field_1254, true, true, false).method_709("thrown_pillow", (class_184)class_2115.class_2117.method_9103((class_2019.class_2020)class_2019.class_2020.method_8844().method_8842(class_2022.class_2023.method_8855().method_48785(class_8129.method_48965((class_6862)class_8103.field_42247)).method_8854(class_2048.class_2049.method_8916().method_8921(CushyPillowsEntities.PILLOW_ENTITY))))).method_695(new class_2960("cushypillows", "husbandry/pillow_fight"));
            consumer.accept(root);
            consumer.accept(craftPillowPattern);
            consumer.accept(featherBurst);
            consumer.accept(pillowFight);
        }
    }

    public static class PillowLootTableProvider
    extends FabricBlockLootTableProvider {
        protected PillowLootTableProvider(FabricDataOutput dataOutput) {
            super(dataOutput);
        }

        public void method_10379() {
            ArrayList pillows = Lists.newArrayList((Object[])new class_2248[]{CushyPillowsBlocks.WHITE_PILLOW, CushyPillowsBlocks.ORANGE_PILLOW, CushyPillowsBlocks.MAGENTA_PILLOW, CushyPillowsBlocks.LIGHT_BLUE_PILLOW, CushyPillowsBlocks.YELLOW_PILLOW, CushyPillowsBlocks.LIME_PILLOW, CushyPillowsBlocks.PINK_PILLOW, CushyPillowsBlocks.GRAY_PILLOW, CushyPillowsBlocks.LIGHT_GRAY_PILLOW, CushyPillowsBlocks.CYAN_PILLOW, CushyPillowsBlocks.PURPLE_PILLOW, CushyPillowsBlocks.BLUE_PILLOW, CushyPillowsBlocks.BROWN_PILLOW, CushyPillowsBlocks.GREEN_PILLOW, CushyPillowsBlocks.RED_PILLOW, CushyPillowsBlocks.BLACK_PILLOW});
            for (class_2248 pillow : pillows) {
                this.method_45988(pillow, class_52.method_324().method_336((class_55.class_56)this.method_45978((class_1935)pillow, (class_192)class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)pillow).method_438((class_117.class_118)class_3837.method_16848((class_5651)class_5646.field_27914).method_16856("Patterns", "BlockEntityTag.Patterns"))))));
            }
        }
    }
}

