/*
 * Decompiled with CFR 0.152.
 */
package elocindev.deathknights.config;

import elocindev.deathknights.DeathKnights;
import elocindev.deathknights.config.Configs;
import elocindev.deathknights.config.entries.ClientConfig;
import elocindev.deathknights.config.entries.enchants.DecayingEnchantConfig;
import elocindev.deathknights.config.entries.loot.JewelryLootConfig;
import elocindev.deathknights.config.entries.spells.blood.BloodBoilConfig;
import elocindev.deathknights.config.entries.spells.blood.BloodThirstConfig;
import elocindev.deathknights.config.entries.spells.blood.DeathStrikeConfig;
import elocindev.deathknights.config.entries.spells.blood.MarrowrendConfig;
import elocindev.deathknights.config.entries.spells.frost.BreathOfAgonyConfig;
import elocindev.deathknights.config.entries.spells.frost.ObliterateConfig;
import elocindev.deathknights.config.entries.spells.frost.RemorselessWinterConfig;
import elocindev.deathknights.config.entries.spells.unholy.DeathCoilConfig;
import elocindev.deathknights.config.entries.spells.unholy.DeathGripConfig;
import elocindev.deathknights.config.entries.spells.unholy.EpidemicConfig;
import elocindev.deathknights.config.entries.spells.unholy.PlaguesConfig;
import elocindev.necronomicon.api.config.v1.NecConfigAPI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigLoader {
    public static void init() {
        Configs.Items.ARMORS.refresh();
        Configs.Items.JEWELRY.refresh();
        NecConfigAPI.registerConfig(DecayingEnchantConfig.class);
        NecConfigAPI.registerConfig(JewelryLootConfig.class);
        NecConfigAPI.registerConfig(ObliterateConfig.class);
        NecConfigAPI.registerConfig(RemorselessWinterConfig.class);
        NecConfigAPI.registerConfig(BreathOfAgonyConfig.class);
        NecConfigAPI.registerConfig(PlaguesConfig.class);
        NecConfigAPI.registerConfig(DeathCoilConfig.class);
        NecConfigAPI.registerConfig(EpidemicConfig.class);
        NecConfigAPI.registerConfig(DeathGripConfig.class);
        NecConfigAPI.registerConfig(DeathStrikeConfig.class);
        NecConfigAPI.registerConfig(MarrowrendConfig.class);
        NecConfigAPI.registerConfig(BloodBoilConfig.class);
        NecConfigAPI.registerConfig(BloodThirstConfig.class);
    }

    public static void initClient() {
        NecConfigAPI.registerConfig(ClientConfig.class);
    }

    public static void initDatapack(boolean started) {
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> {
            if (started) {
                ConfigLoader.init();
            }
        });
        DeathKnights.LOGGER.info("Death Knights Config Loaded!");
    }

    public static String getFile(String file) {
        Path folder = FabricLoader.getInstance().getConfigDir().resolve("death_knights");
        try {
            Files.createDirectories(folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return folder.resolve(file).toString();
    }

    public static String getNestedFile(String file, String folder) {
        Path cfg = FabricLoader.getInstance().getConfigDir();
        Path eeFolder = cfg.resolve("death_knights");
        Path nestedFolder = eeFolder.resolve(folder);
        try {
            Files.createDirectories(nestedFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nestedFolder.resolve(file).toString();
    }
}

