/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.sneakdevs.diamondsauctionhouse.auction;

import com.gmail.sneakdevs.diamondsauctionhouse.DiamondsAuctionHouse;
import com.gmail.sneakdevs.diamondsauctionhouse.auction.AuctionItem;
import com.gmail.sneakdevs.diamondsauctionhouse.config.DiamondsAuctionHouseConfig;
import java.util.ArrayList;

public class AuctionHouse {
    private int tick = 0;
    private ArrayList<AuctionItem> items;

    public AuctionHouse(ArrayList<AuctionItem> items) {
        this.items = items;
    }

    public boolean canAddItem() {
        return this.items.size() <= DiamondsAuctionHouseConfig.getInstance().maxPages * 45;
    }

    public void addItem(AuctionItem item) {
        this.items.add(item);
    }

    public void removeItem(AuctionItem item) {
        this.items.remove(item);
    }

    public AuctionItem getItem(int item) {
        return this.items.get(item);
    }

    public int size() {
        return this.items.size();
    }

    public void tick() {
        ++this.tick;
        if (this.tick % 20 == 0) {
            int i = 0;
            while (i < this.items.size()) {
                if (this.items.get(i).tickDeath()) {
                    DiamondsAuctionHouse.getDatabaseManager().expireItem(this.items.get(i));
                    continue;
                }
                ++i;
            }
        }
        if (this.tick % 300 == 0) {
            for (AuctionItem item : this.items) {
                DiamondsAuctionHouse.getDatabaseManager().updateTime(item.getId(), item.getSecondsLeft());
            }
        }
    }

    public AuctionHouse getPlayerAuctionHouse(String uuid) {
        AuctionHouse ah = new AuctionHouse(new ArrayList<AuctionItem>());
        for (AuctionItem item : this.items) {
            if (!item.getUuid().equals(uuid)) continue;
            ah.addItem(item);
        }
        return ah;
    }
}

