/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.sneakdevs.diamondsauctionhouse.gui;

import com.gmail.sneakdevs.diamondeconomy.DiamondUtils;
import com.gmail.sneakdevs.diamondsauctionhouse.DiamondsAuctionHouse;
import com.gmail.sneakdevs.diamondsauctionhouse.auction.AuctionItem;
import com.gmail.sneakdevs.diamondsauctionhouse.gui.AuctionHouseGui;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class AuctionItemGui
extends SimpleGui {
    private int ticker = 0;
    private final AuctionItem item;

    public AuctionItemGui(class_3222 player, AuctionItem item) {
        super(class_3917.field_18664, player, false);
        this.item = item;
    }

    public void updateDisplay() {
        for (int i = 0; i < 9; ++i) {
            DisplayElement navElement = this.getNavElement(i);
            if (navElement == null) {
                navElement = DisplayElement.EMPTY;
            }
            if (navElement.element != null) {
                this.setSlot(i, navElement.element);
                continue;
            }
            if (navElement.slot == null) continue;
            this.setSlotRedirect(i, navElement.slot);
        }
    }

    protected DisplayElement getNavElement(int id) {
        return switch (id) {
            case 0 -> DisplayElement.of(new GuiElementBuilder(class_1802.field_8557).setName((class_2561)class_2561.method_43470((String)("Time Left: " + this.item.getTimeLeft())).method_27692(class_124.field_1078)).hideFlags());
            case 1 -> DisplayElement.of(new GuiElementBuilder(class_1802.field_8407).setName((class_2561)class_2561.method_43470((String)("Price: $" + this.item.getPrice())).method_27692(class_124.field_1078)).hideFlags());
            case 2 -> this.skull();
            case 4 -> DisplayElement.of(GuiElementBuilder.from((class_1799)this.item.getItemStack()));
            case 6 -> this.confirm();
            case 7 -> DisplayElement.of(new GuiElementBuilder(class_1802.field_8879).setName((class_2561)class_2561.method_43470((String)"Cancel").method_27692(class_124.field_1061)).hideFlags().setCallback((x, y, z) -> {
                AuctionItemGui.playClickSound(this.player);
                this.close();
            }));
            case 8 -> this.trash();
            default -> DisplayElement.filler();
        };
    }

    public void onTick() {
        ++this.ticker;
        if (this.ticker >= 5) {
            this.ticker = 0;
            this.updateDisplay();
        }
        super.onTick();
    }

    public static void playClickSound(class_3222 player) {
        player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15250, 1.0f, 1.0f);
    }

    private DisplayElement confirm() {
        if (this.item.getPrice() < DiamondUtils.getDatabaseManager().getBalanceFromUUID(this.player.method_5845())) {
            return DisplayElement.of(new GuiElementBuilder(class_1802.field_8656).setName((class_2561)class_2561.method_43470((String)"Confirm").method_27692(class_124.field_1060)).hideFlags().setCallback((x, y, z) -> {
                AuctionItemGui.playClickSound(this.player);
                this.buy();
            }));
        }
        return DisplayElement.of(new GuiElementBuilder(class_1802.field_8871).setName((class_2561)class_2561.method_43470((String)"Confirm").method_27692(class_124.field_1063)).hideFlags());
    }

    private DisplayElement trash() {
        if (this.player.method_5687(4) || this.player.method_5845().equals(this.item.getUuid())) {
            return DisplayElement.of(new GuiElementBuilder(class_1802.field_8239).setName((class_2561)class_2561.method_43470((String)"Remove from Auction").method_27692(class_124.field_1061)).hideFlags().setCallback((x, y, z) -> {
                AuctionItemGui.playClickSound(this.player);
                this.remove();
            }));
        }
        return DisplayElement.EMPTY;
    }

    private DisplayElement skull() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
        stack.method_7948().method_10582("SkullOwner", this.item.getOwner());
        return DisplayElement.of(GuiElementBuilder.from((class_1799)stack).setName((class_2561)class_2561.method_43470((String)("Owner: " + this.item.getOwner())).method_27692(class_124.field_1078)).hideFlags());
    }

    public void close() {
        AuctionHouseGui gui = new AuctionHouseGui(this.player);
        gui.updateDisplay();
        gui.setTitle((class_2561)class_2561.method_43470((String)"Auction House"));
        gui.open();
        super.close();
    }

    private void remove() {
        DiamondsAuctionHouse.getDatabaseManager().expireItem(this.item);
        this.close();
    }

    private void buy() {
        if (DiamondsAuctionHouse.getDatabaseManager().isItemForAuction(this.item.getId())) {
            if (this.player.method_31548().method_7376() != -1 && DiamondUtils.getDatabaseManager().changeBalance(this.item.getUuid(), this.item.getPrice())) {
                DiamondUtils.getDatabaseManager().changeBalance(this.player.method_5845(), -this.item.getPrice());
                DiamondsAuctionHouse.getDatabaseManager().removeItemFromAuction(this.item);
                DiamondsAuctionHouse.ah.removeItem(this.item);
                this.player.method_31548().method_7394(this.item.getItemStack());
            }
        } else {
            this.player.method_7353((class_2561)class_2561.method_43470((String)"That item was already bought"), true);
        }
        super.close();
    }

    public record DisplayElement(@Nullable GuiElementInterface element, @Nullable class_1735 slot) {
        private static final DisplayElement EMPTY = DisplayElement.of((GuiElementInterface)new GuiElement(class_1799.field_8037, GuiElementInterface.EMPTY_CALLBACK));
        private static final DisplayElement FILLER = DisplayElement.of(new GuiElementBuilder(class_1802.field_8240).setName((class_2561)class_2561.method_43470((String)"")).hideFlags());

        public static DisplayElement of(GuiElementInterface element) {
            return new DisplayElement(element, null);
        }

        public static DisplayElement of(GuiElementBuilderInterface<?> element) {
            return new DisplayElement(element.build(), null);
        }

        public static DisplayElement filler() {
            return FILLER;
        }
    }
}

