/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.sneakdevs.diamondsauctionhouse.gui;

import com.gmail.sneakdevs.diamondsauctionhouse.DiamondsAuctionHouse;
import com.gmail.sneakdevs.diamondsauctionhouse.auction.AuctionHouse;
import com.gmail.sneakdevs.diamondsauctionhouse.auction.AuctionItem;
import com.gmail.sneakdevs.diamondsauctionhouse.config.DiamondsAuctionHouseConfig;
import com.gmail.sneakdevs.diamondsauctionhouse.gui.AuctionHouseGui;
import com.gmail.sneakdevs.diamondsauctionhouse.gui.AuctionItemGui;
import com.gmail.sneakdevs.diamondsauctionhouse.gui.ExpiredItemsGui;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class PersonalAuctionHouseGui
extends SimpleGui {
    public static final int PAGE_SIZE = 45;
    protected int page = 0;
    private int ticker = 0;
    private AuctionHouse ah;

    public <T extends PersonalAuctionHouseGui> PersonalAuctionHouseGui(class_3222 player) {
        super(class_3917.field_17327, player, false);
        this.ah = DiamondsAuctionHouse.ah.getPlayerAuctionHouse(player.method_5845());
    }

    protected void nextPage() {
        this.page = Math.min(this.getPageAmount() - 1, this.page + 1);
        this.updateDisplay();
    }

    protected boolean canNextPage() {
        return this.getPageAmount() > this.page + 1;
    }

    protected void previousPage() {
        this.page = Math.max(0, this.page - 1);
        this.updateDisplay();
    }

    protected boolean canPreviousPage() {
        return this.page - 1 >= 0;
    }

    public void updateDisplay() {
        int i;
        for (i = 0; i < 45; ++i) {
            DisplayElement element = this.getElement(i);
            if (element == null) {
                element = DisplayElement.empty();
            }
            if (element.element() != null) {
                this.setSlot(i, element.element());
                continue;
            }
            if (element.slot() == null) continue;
            this.setSlotRedirect(i, element.slot());
        }
        for (i = 0; i < 9; ++i) {
            DisplayElement navElement = this.getNavElement(i);
            if (navElement == null) {
                navElement = DisplayElement.EMPTY;
            }
            if (navElement.element != null) {
                this.setSlot(i + 45, navElement.element);
                continue;
            }
            if (navElement.slot == null) continue;
            this.setSlotRedirect(i + 45, navElement.slot);
        }
    }

    protected DisplayElement getNavElement(int id) {
        return switch (id) {
            case 0 -> DisplayElement.of(new GuiElementBuilder(class_1802.field_8197).setName((class_2561)class_2561.method_43470((String)"Back").method_27692(class_124.field_1061)).hideFlags().setCallback((x, y, z) -> {
                PersonalAuctionHouseGui.playClickSound(this.player);
                this.openPublic();
            }));
            case 3 -> DisplayElement.previousPage(this);
            case 4 -> DisplayElement.of(new GuiElementBuilder(class_1802.field_8077).setName((class_2561)class_2561.method_43471((String)"spectatorMenu.close").method_27692(class_124.field_1061)).hideFlags().setCallback((x, y, z) -> {
                PersonalAuctionHouseGui.playClickSound(this.player);
                this.close();
            }));
            case 5 -> DisplayElement.nextPage(this);
            case 8 -> DisplayElement.of(new GuiElementBuilder(class_1802.field_8239).setName((class_2561)class_2561.method_43470((String)"Expired Items").method_27692(class_124.field_1061)).hideFlags().setCallback((x, y, z) -> {
                PersonalAuctionHouseGui.playClickSound(this.player);
                this.openExpiredGui();
            }));
            default -> DisplayElement.filler();
        };
    }

    protected int getPageAmount() {
        return Math.min(DiamondsAuctionHouseConfig.getInstance().maxPages, this.ah.size() / 45 + 1);
    }

    private void openPublic() {
        this.close();
        AuctionHouseGui gui = new AuctionHouseGui(this.player);
        gui.updateDisplay();
        gui.setTitle((class_2561)class_2561.method_43470((String)"Auction House"));
        gui.open();
    }

    protected DisplayElement getElement(int id) {
        int id1 = this.page * 45 + id;
        if (id1 >= this.ah.size()) {
            return null;
        }
        AuctionItem ai = this.ah.getItem(id1);
        return DisplayElement.of(GuiElementBuilder.from((class_1799)ai.getItemStack()).addLoreLine((class_2561)class_2561.method_43470((String)ai.getTimeLeft()).method_27692(class_124.field_1064)).addLoreLine((class_2561)class_2561.method_43470((String)("$" + ai.getPrice())).method_27692(class_124.field_1064)).setCallback((x, y, z) -> {
            PersonalAuctionHouseGui.playClickSound(this.player);
            this.openItemGui(this.ah.getItem(id1));
        }));
    }

    public void onTick() {
        ++this.ticker;
        if (this.ticker >= 20) {
            this.ticker = 0;
            this.ah = DiamondsAuctionHouse.ah.getPlayerAuctionHouse(this.player.method_5845());
            this.updateDisplay();
        }
        super.onTick();
    }

    private void openItemGui(AuctionItem item) {
        this.close();
        AuctionItemGui gui = new AuctionItemGui(this.player, item);
        gui.updateDisplay();
        gui.setTitle((class_2561)class_2561.method_43470((String)"Buy"));
        gui.open();
    }

    private void openExpiredGui() {
        this.close();
        ExpiredItemsGui gui = new ExpiredItemsGui(this.player);
        gui.updateDisplay();
        gui.setTitle((class_2561)class_2561.method_43470((String)"Expired Items"));
        gui.open();
    }

    private static void playClickSound(class_3222 player) {
        player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15250, 1.0f, 1.0f);
    }

    public record DisplayElement(@Nullable GuiElementInterface element, @Nullable class_1735 slot) {
        private static final DisplayElement EMPTY = DisplayElement.of((GuiElementInterface)new GuiElement(class_1799.field_8037, GuiElementInterface.EMPTY_CALLBACK));
        private static final DisplayElement FILLER = DisplayElement.of(new GuiElementBuilder(class_1802.field_8240).setName((class_2561)class_2561.method_43470((String)"")).hideFlags());

        public static DisplayElement of(GuiElementInterface element) {
            return new DisplayElement(element, null);
        }

        public static DisplayElement of(GuiElementBuilderInterface<?> element) {
            return new DisplayElement(element.build(), null);
        }

        public static DisplayElement nextPage(PersonalAuctionHouseGui gui) {
            if (gui.canNextPage()) {
                return DisplayElement.of(new GuiElementBuilder(class_1802.field_8575).setName((class_2561)class_2561.method_43471((String)"spectatorMenu.next_page").method_27692(class_124.field_1068)).hideFlags().setSkullOwner("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzg2MTg1YjFkNTE5YWRlNTg1ZjE4NGMzNGYzZjNlMjBiYjY0MWRlYjg3OWU4MTM3OGU0ZWFmMjA5Mjg3In19fQ").setCallback((x, y, z) -> {
                    PersonalAuctionHouseGui.playClickSound(gui.player);
                    gui.nextPage();
                }));
            }
            return DisplayElement.of(new GuiElementBuilder(class_1802.field_8575).setName((class_2561)class_2561.method_43471((String)"spectatorMenu.next_page").method_27692(class_124.field_1063)).hideFlags().setSkullOwner("ewogICJ0aW1lc3RhbXAiIDogMTY0MDYxNjExMDQ4OCwKICAicHJvZmlsZUlkIiA6ICIxZjEyNTNhYTVkYTQ0ZjU5YWU1YWI1NmFhZjRlNTYxNyIsCiAgInByb2ZpbGVOYW1lIiA6ICJOb3RNaUt5IiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzdlNTc3MjBhNDg3OGM4YmNhYjBlOWM5YzQ3ZDllNTUxMjhjY2Q3N2JhMzQ0NWE1NGE5MWUzZTFlMWEyNzM1NmUiLAogICAgICAibWV0YWRhdGEiIDogewogICAgICAgICJtb2RlbCIgOiAic2xpbSIKICAgICAgfQogICAgfQogIH0KfQ=="));
        }

        public static DisplayElement previousPage(PersonalAuctionHouseGui gui) {
            if (gui.canPreviousPage()) {
                return DisplayElement.of(new GuiElementBuilder(class_1802.field_8575).setName((class_2561)class_2561.method_43471((String)"spectatorMenu.previous_page").method_27692(class_124.field_1068)).hideFlags().setSkullOwner("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzEwODI5OGZmMmIyNjk1MWQ2ODNlNWFkZTQ2YTQyZTkwYzJmN2M3ZGQ0MWJhYTkwOGJjNTg1MmY4YzMyZTU4MyJ9fX0").setCallback((x, y, z) -> {
                    PersonalAuctionHouseGui.playClickSound(gui.player);
                    gui.previousPage();
                }));
            }
            return DisplayElement.of(new GuiElementBuilder(class_1802.field_8575).setName((class_2561)class_2561.method_43471((String)"spectatorMenu.previous_page").method_27692(class_124.field_1063)).hideFlags().setSkullOwner("ewogICJ0aW1lc3RhbXAiIDogMTY0MDYxNjE5MjE0MiwKICAicHJvZmlsZUlkIiA6ICJmMjc0YzRkNjI1MDQ0ZTQxOGVmYmYwNmM3NWIyMDIxMyIsCiAgInByb2ZpbGVOYW1lIiA6ICJIeXBpZ3NlbCIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS81MDgyMGY3NmUzZTA0MWM3NWY3NmQwZjMwMTIzMmJkZjQ4MzIxYjUzNGZlNmE4NTljY2I4NzNkMjk4MWE5NjIzIiwKICAgICAgIm1ldGFkYXRhIiA6IHsKICAgICAgICAibW9kZWwiIDogInNsaW0iCiAgICAgIH0KICAgIH0KICB9Cn0="));
        }

        public static DisplayElement filler() {
            return FILLER;
        }

        public static DisplayElement empty() {
            return EMPTY;
        }
    }
}

