/*
 * Decompiled with CFR 0.152.
 */
package xyz.amymialee.doublejumpattribute;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import xyz.amymialee.doublejumpattribute.DoubleJumpAttribute;
import xyz.amymialee.doublejumpattribute.mixin.LivingEntityAccessor;

public class DoubleJumpComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1657 player;
    private final LivingEntityAccessor living;
    private int jumpsUsed = 0;
    private int jumpCooldown = 0;

    public DoubleJumpComponent(class_1657 player) {
        this.player = player;
        this.living = (LivingEntityAccessor)player;
    }

    public static DoubleJumpComponent get(class_1657 player) {
        return (DoubleJumpComponent)DoubleJumpAttribute.DOUBLE_JUMPS.get((Object)player);
    }

    public void sync() {
        DoubleJumpAttribute.DOUBLE_JUMPS.sync((Object)this.player);
    }

    public void performDoubleJump() {
        if (this.living.getJumpingCooldown() <= 0 && this.getRemainingJumps() > 0) {
            ++this.jumpsUsed;
            this.player.method_37908().method_43129(null, (class_1297)this.player, DoubleJumpAttribute.JUMP_SOUND_EVENT, class_3419.field_15248, 1.0f, 1.0f);
            this.player.method_7281(DoubleJumpAttribute.DOUBLE_JUMP_STAT);
            this.player.field_6017 = 0.0f;
            this.living.setJumpingCooldown(10);
            this.sync();
        }
    }

    public void tick() {
        if (this.player.method_24828()) {
            this.jumpsUsed = 0;
        }
    }

    public void clientTick() {
        if (this.living.isJumping() && this.jumpCooldown <= 0 && this.getRemainingJumps() > 0) {
            this.jumpCooldown = 12;
            class_243 vec3d = this.player.method_18798();
            if (this.player.method_5624()) {
                vec3d = new class_243(vec3d.field_1352, 0.8 * (double)(1.0f + this.player.method_37416()), vec3d.field_1350);
                float f = this.player.method_36454() * ((float)Math.PI / 180);
                this.player.method_18799(vec3d.method_1031((double)(-class_3532.method_15374((float)f) * 0.2f), 0.0, (double)(class_3532.method_15362((float)f) * 0.2f)));
            } else {
                this.player.method_18800(vec3d.field_1352, 0.7 * (double)(1.0f + this.player.method_37416()), vec3d.field_1350);
            }
            this.player.field_6037 = true;
            ClientPlayNetworking.send((class_2960)DoubleJumpAttribute.JUMP_PACKET, (class_2540)PacketByteBufs.empty());
        }
        if (this.player.method_24828()) {
            this.jumpCooldown = 8;
        } else if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        if (this.jumpsUsed > 0 && (double)this.player.method_6051().method_43057() > 0.75) {
            this.player.method_37908().method_8406((class_2394)class_2398.field_11204, this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), 0.0, 0.0, 0.0);
        }
        this.tick();
    }

    public void serverTick() {
        super.serverTick();
    }

    public int getPossibleJumps() {
        return (int)this.player.method_26825(DoubleJumpAttribute.JUMPS);
    }

    public int getRemainingJumps() {
        return this.getPossibleJumps() - this.jumpsUsed;
    }

    public void readFromNbt(class_2487 tag) {
        int jumpsUsed = tag.method_10550("jumpsUsed");
        if (this.player.method_37908().method_8608() && jumpsUsed > this.jumpsUsed) {
            for (int i = 0; i < 12; ++i) {
                this.player.method_37908().method_8406((class_2394)class_2398.field_11204, this.player.method_23317() + this.player.method_6051().method_43059() * 0.2, this.player.method_5829().field_1322 + 0.5 + this.player.method_6051().method_43059() * 0.2, this.player.method_23321() + this.player.method_6051().method_43059() * 0.2, this.player.method_6051().method_43059() * (double)0.15f, (double)(this.player.method_6051().method_43057() * 0.15f), this.player.method_6051().method_43059() * (double)0.15f);
            }
        }
        this.jumpsUsed = jumpsUsed;
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10569("jumpsUsed", this.jumpsUsed);
    }
}

