/*
 * Decompiled with CFR 0.152.
 */
package io.github.andrew6rant.dynamictrim.mixin.modernfix;

import com.bawnorton.mixinsquared.TargetHandler;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.andrew6rant.dynamictrim.resource.DynamicTrimLoader;
import io.github.andrew6rant.dynamictrim.util.mixin.ModernFixConditionChecker;
import io.github.andrew6rant.dynamictrim.util.mixin.annotation.AdvancedConditionalMixin;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1092;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@AdvancedConditionalMixin(checker=ModernFixConditionChecker.class)
@Mixin(value={class_1092.class}, priority=1500)
public abstract class BakedModelManagerMixin {
    @Unique
    private static final Map<class_2960, class_3298> dynamicTrim$Overrides = new HashMap<class_2960, class_3298>();

    @TargetHandler(mixin="org.embeddedt.modernfix.common.mixin.perf.dynamic_resources.ModelManagerMixin", name="loadSingleBlockModel")
    @WrapOperation(method={"@MixinSquared:Handler"}, at={@At(value="INVOKE", target="net/minecraft/resource/ResourceManager.getResource(Lnet/minecraft/util/Identifier;)Ljava/util/Optional;")})
    private Optional<class_3298> loadDynamicTrims(class_3300 instance, class_2960 location, Operation<Optional<class_3298>> original) {
        if (dynamicTrim$Overrides.containsKey(location)) {
            return Optional.of(dynamicTrim$Overrides.remove(location));
        }
        Optional resource = (Optional)original.call(new Object[]{instance, location});
        if (!DynamicTrimLoader.isTrimmable(location) || resource.isEmpty()) {
            return resource;
        }
        Map<class_2960, class_3298> toLoad = DynamicTrimLoader.generateResourceMapForSingleTrim(location, (class_3298)resource.orElseThrow());
        class_3298 requested = toLoad.remove(location);
        dynamicTrim$Overrides.putAll(toLoad);
        return Optional.of(requested);
    }
}

