/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.github.lucaargolo.seasons.FabricSeasons;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class CompatWarnState {
    private static CompatWarnState instance = null;
    private final class_310 client;
    private final HashSet<ModInfo> availableCompatPacks;
    private final HashSet<String> alreadyWarned;
    private final HashSet<ModInfo> toWarn;
    private boolean dirty = false;

    private CompatWarnState(class_310 client, HashSet<String> alreadyWarned) {
        this.client = client;
        this.availableCompatPacks = new HashSet();
        try (CloseableHttpClient http = HttpClients.createDefault();){
            HttpGet request = new HttpGet("https://gist.githubusercontent.com/lucaargolo/abfd0edbcf7340e6f8bf32698a8d2d57/raw/fabric-seasons-compat.json");
            try (CloseableHttpResponse response = http.execute((HttpUriRequest)request);){
                JsonElement element = JsonParser.parseString((String)EntityUtils.toString((HttpEntity)response.getEntity()));
                for (JsonElement modInfoElement : element.getAsJsonArray()) {
                    this.availableCompatPacks.add((ModInfo)FabricSeasons.GSON.fromJson(modInfoElement, ModInfo.class));
                }
            }
        }
        catch (Exception e) {
            FabricSeasons.LOGGER.error("[Fabric Seasons] Failed to request compatibility mods list.", (Throwable)e);
        }
        this.alreadyWarned = alreadyWarned;
        this.toWarn = new HashSet();
        HashSet availableNamespaces = new HashSet();
        class_634 handler = client.method_1562();
        if (handler != null) {
            handler.method_29091().method_30530(class_7924.field_41236).method_40295().forEach(entry -> entry.method_40230().ifPresent(key -> availableNamespaces.add(key.method_29177().method_12836())));
            FabricSeasons.SEEDS_MAP.forEach((item, block) -> availableNamespaces.add(class_7923.field_41175.method_10221(block).method_12836()));
        }
        availableNamespaces.stream().filter(namespace -> !alreadyWarned.contains(namespace)).forEach(namespace -> this.availableCompatPacks.stream().filter(info -> info.mods.contains(namespace)).forEach(this.toWarn::add));
    }

    private void saveState() {
        class_2487 nbt = new class_2487();
        class_2499 list = new class_2499();
        this.alreadyWarned.forEach(s -> list.add((Object)class_2519.method_23256((String)s)));
        nbt.method_10566("list", (class_2520)list);
        File compatWarnFile = new File(class_310.method_1551().field_1697, File.separator + "data" + File.separator + "seasons_compat_warn.nbt");
        try {
            Boolean ignored = compatWarnFile.getParentFile().mkdirs();
            Boolean ignored2 = compatWarnFile.createNewFile();
            class_2507.method_30614((class_2487)nbt, (File)compatWarnFile);
        }
        catch (IOException e) {
            FabricSeasons.LOGGER.error("[Fabric Seasons] Failed to save season compat warn state.", (Throwable)e);
        }
    }

    public static CompatWarnState loadState(class_310 client) {
        class_2487 nbt;
        File compatWarnFile = new File(class_310.method_1551().field_1697, File.separator + "data" + File.separator + "seasons_compat_warn.nbt");
        HashSet<String> alreadyWarned = new HashSet<String>();
        try {
            nbt = class_2507.method_30613((File)compatWarnFile);
        }
        catch (Exception e) {
            nbt = new class_2487();
        }
        class_2520 element = nbt.method_10580("list");
        if (element instanceof class_2499) {
            class_2499 list = (class_2499)element;
            list.forEach(listElement -> {
                if (listElement instanceof class_2519) {
                    class_2519 listString = (class_2519)listElement;
                    alreadyWarned.add(listString.method_10714());
                }
            });
        }
        return new CompatWarnState(client, alreadyWarned);
    }

    public static CompatWarnState getInstance(class_310 client) {
        if (instance == null) {
            instance = CompatWarnState.loadState(client);
        }
        return instance;
    }

    public static void join(class_310 client) {
        CompatWarnState.getInstance(client).join();
    }

    public void join() {
        this.toWarn.forEach(info -> {
            if (!this.alreadyWarned.contains(info.id) && !FabricLoader.getInstance().isModLoaded(info.id)) {
                class_746 player = this.client.field_1724;
                if (player != null) {
                    class_5250 second;
                    class_5250 first;
                    if (!info.mods.contains("minecraft")) {
                        first = class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43469((String)"chat.seasons.mod_installed", (Object[])new Object[]{class_2561.method_43470((String)info.name).method_27692(class_124.field_1060)}).method_27692(class_124.field_1054));
                        second = class_2561.method_43470((String)(("\n\u00a7e" + class_2561.method_43471((String)"chat.seasons.compatibility").getString()).replace("Fabric Seasons", "\u00a7aFabric Seasons\u00a7e") + "\n"));
                    } else {
                        first = class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43469((String)"chat.seasons.mod_not_installed", (Object[])new Object[]{class_2561.method_43470((String)info.name).method_27692(class_124.field_1061)}).method_27692(class_124.field_1054));
                        second = class_2561.method_43470((String)("\n\u00a7e" + class_2561.method_43471((String)"chat.seasons.extras").getString() + "\n"));
                    }
                    class_5250 third = class_2561.method_43470((String)("\u00a7e" + class_2561.method_43471((String)"chat.seasons.available_at").getString()));
                    class_5250 curse = class_2561.method_43470((String)"\u00a76\u00a7nCurseForge\u00a7r ").method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://www.curseforge.com/minecraft/mc-mods/" + info.url)));
                    class_5250 modrinth = class_2561.method_43470((String)"\u00a72\u00a7nModrinth\u00a7r ").method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://modrinth.com/mod/" + info.url)));
                    class_5250 github = class_2561.method_43470((String)"\u00a75\u00a7nGitHub\u00a7r\n").method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/lucaargolo/" + info.url + "/releases")));
                    class_5250 fourth = class_2561.method_43470((String)("\u00a7e" + class_2561.method_43471((String)"chat.seasons.show_once").getString() + "\n"));
                    player.method_43496((class_2561)first.method_10852((class_2561)second).method_10852((class_2561)third).method_10852((class_2561)curse).method_10852((class_2561)modrinth).method_10852((class_2561)github).method_10852((class_2561)fourth));
                }
                this.alreadyWarned.add(info.id);
                this.dirty = true;
            }
        });
        if (this.dirty) {
            this.dirty = false;
            this.saveState();
        }
    }

    public static class ModInfo {
        private List<String> mods;
        private String id;
        private String url;
        private String name;
    }
}

