/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.utils;

import com.google.gson.JsonElement;
import io.github.lucaargolo.seasons.utils.Season;
import net.minecraft.class_2540;

public class CropConfig {
    private final float springModifier;
    private final float summerModifier;
    private final float fallModifier;
    private final float winterModifier;

    public CropConfig(float springModifier, float summerModifier, float fallModifier, float winterModifier) {
        this.springModifier = springModifier;
        this.summerModifier = summerModifier;
        this.fallModifier = fallModifier;
        this.winterModifier = winterModifier;
    }

    public CropConfig(JsonElement json) {
        this.springModifier = this.getStringModifier(json.getAsJsonObject().get("spring").getAsString());
        this.summerModifier = this.getStringModifier(json.getAsJsonObject().get("summer").getAsString());
        this.fallModifier = this.getStringModifier(json.getAsJsonObject().get("fall").getAsString());
        this.winterModifier = this.getStringModifier(json.getAsJsonObject().get("winter").getAsString());
    }

    private float getStringModifier(String modifier) {
        return Float.parseFloat(modifier);
    }

    public float getModifier(Season season) {
        return switch (season) {
            default -> throw new IncompatibleClassChangeError();
            case Season.SPRING -> this.springModifier;
            case Season.SUMMER -> this.summerModifier;
            case Season.FALL -> this.fallModifier;
            case Season.WINTER -> this.winterModifier;
        };
    }

    public void toBuf(class_2540 buf) {
        buf.writeFloat(this.springModifier);
        buf.writeFloat(this.summerModifier);
        buf.writeFloat(this.fallModifier);
        buf.writeFloat(this.winterModifier);
    }

    public static CropConfig fromBuf(class_2540 buf) {
        return new CropConfig(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
    }
}

