/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.util;

import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class CachedObject<T> {
    public static final int HAS_NEVER_BEEN_INITIALIZED = -2;
    public static final int EMPTY_NBT = -1;
    protected final class_2960 id;
    protected final Function<class_1799, T> deserializer;
    protected final ToIntFunction<class_1799> hasher;
    protected volatile T data = null;
    protected volatile int lastNbtHash = -2;

    public CachedObject(class_2960 id, Function<class_1799, T> deserializer, ToIntFunction<class_1799> hasher) {
        this.id = id;
        this.deserializer = deserializer;
        this.hasher = hasher;
    }

    public CachedObject(class_2960 id, Function<class_1799, T> deserializer) {
        this(id, deserializer, CachedObject::defaultHash);
    }

    @Nullable
    public T get(class_1799 stack) {
        if (this.lastNbtHash == -2) {
            this.compute(stack);
            return this.data;
        }
        if (this.hasher.applyAsInt(stack) != this.lastNbtHash) {
            this.compute(stack);
        }
        return this.data;
    }

    public void reset() {
        this.data = null;
        this.lastNbtHash = -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compute(class_1799 stack) {
        CachedObject cachedObject = this;
        synchronized (cachedObject) {
            this.data = this.deserializer.apply(stack);
            this.lastNbtHash = this.hasher.applyAsInt(stack);
        }
    }

    public static int defaultHash(class_1799 stack) {
        return stack.method_7985() ? stack.method_7969().hashCode() : -1;
    }

    public static ToIntFunction<class_1799> hashSubkey(String subkey) {
        return stack -> stack.method_7941(subkey) != null ? stack.method_7941(subkey).hashCode() : -1;
    }

    public static interface CachedObjectSource {
        public <T> T getOrCreate(class_2960 var1, Function<class_1799, T> var2, ToIntFunction<class_1799> var3);

        default public <T> T getOrCreate(class_2960 id, Function<class_1799, T> deserializer) {
            return this.getOrCreate(id, deserializer, CachedObject::defaultHash);
        }

        public static <T> T getOrCreate(class_1799 stack, class_2960 id, Function<class_1799, T> deserializer, ToIntFunction<class_1799> hasher) {
            return ((CachedObjectSource)stack).getOrCreate(id, deserializer, hasher);
        }

        public static <T> T getOrCreate(class_1799 stack, class_2960 id, Function<class_1799, T> deserializer) {
            return ((CachedObjectSource)stack).getOrCreate(id, deserializer);
        }
    }
}

