/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.gui;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementPosXPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public ElementPosXPlaceholder() {
        super("elementposx");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        if (class_310.method_1551().field_1755 == null) {
            return "1";
        }
        String id = dps.values.get("id");
        if (id != null) {
            AbstractElement element = this.findElement(id);
            if (element != null) {
                return "" + element.getAbsoluteX();
            }
            LOGGER.error("[FANCYMENU] Unable to get X-position of element via placeholder! Element not found: " + id);
        }
        return "1";
    }

    private AbstractElement findElement(String id) {
        if (class_310.method_1551().field_1755 != null) {
            class_437 class_4372 = class_310.method_1551().field_1755;
            if (!(class_4372 instanceof LayoutEditorScreen)) {
                ScreenCustomizationLayer mh = ScreenCustomizationLayerHandler.getLayerOfScreen(class_310.method_1551().field_1755);
                if (mh != null) {
                    return mh.getElementByInstanceIdentifier(id);
                }
            } else {
                LayoutEditorScreen editor = (LayoutEditorScreen)class_4372;
                AbstractEditorElement e = editor.getElementByInstanceIdentifier(id);
                if (e != null) {
                    return e.element;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("id");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.helper.placeholder.elementposx", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.helper.placeholder.elementposx.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.gui", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        DeserializedPlaceholderString dps = new DeserializedPlaceholderString();
        dps.placeholderIdentifier = this.getIdentifier();
        dps.values.put("id", "some.element.id");
        return dps;
    }
}

