/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util;

import de.keksuccino.fancymenu.util.LevelData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_34;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class WorldUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static boolean isSingleplayer() {
        if (class_310.method_1551().field_1687 == null) {
            return false;
        }
        return class_310.method_1551().method_1496() && class_310.method_1551().method_1576() != null && !class_310.method_1551().method_1576().method_3860();
    }

    public static boolean isMultiplayer() {
        if (class_310.method_1551().field_1687 == null) {
            return false;
        }
        return !WorldUtils.isSingleplayer();
    }

    @NotNull
    public static List<class_34> getLevels() {
        class_32.class_7410 levelCandidates;
        class_310 minecraft = class_310.method_1551();
        try {
            levelCandidates = minecraft.method_1586().method_235();
        }
        catch (class_33 ex) {
            LOGGER.error("[FANCYMENU] Couldn't load level list!", (Throwable)ex);
            return List.of();
        }
        if (levelCandidates.method_43421()) {
            return List.of();
        }
        CompletionStage future = minecraft.method_1586().method_43417(levelCandidates).exceptionally(throwable -> List.of());
        try {
            return Objects.requireNonNullElse(((CompletableFuture)future).getNow(List.of()), List.of());
        }
        catch (Exception exception) {
            return List.of();
        }
    }

    @NotNull
    public static List<LevelData> getLevelsAsData() {
        ArrayList<LevelData> data = new ArrayList<LevelData>();
        WorldUtils.getLevels().forEach(summary -> data.add(LevelData.fromLevelSummary(summary)));
        return data;
    }
}

