/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.formattingrules;

import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorLine;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.class_2583;
import org.jetbrains.annotations.Nullable;

public class HighlightPlaceholdersFormattingRule
extends TextEditorFormattingRule {
    private final class_2583 braceStyle;
    private final class_2583 keyStyle;
    private final class_2583 stringStyle;
    private final class_2583 punctuationStyle;
    private Map<TextEditorLine, SortedMap<Integer, class_2583>> characterStyles;
    private final List<TextEditorLine> allLines;
    private String fullText;

    public HighlightPlaceholdersFormattingRule() {
        this.braceStyle = class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_4.getColorInt());
        this.keyStyle = class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_1.getColorInt());
        this.stringStyle = class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_2.getColorInt());
        this.punctuationStyle = class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_5.getColorInt());
        this.characterStyles = new HashMap<TextEditorLine, SortedMap<Integer, class_2583>>();
        this.allLines = new ArrayList<TextEditorLine>();
    }

    @Override
    public void resetRule(TextEditorScreen editor) {
        this.characterStyles.clear();
        this.allLines.clear();
        this.allLines.addAll(editor.getLines());
        StringBuilder fullTextBuilder = new StringBuilder();
        HashMap<Integer, TextEditorLine> positionToLine = new HashMap<Integer, TextEditorLine>();
        HashMap<TextEditorLine, Integer> lineStartPositions = new HashMap<TextEditorLine, Integer>();
        int globalPos = 0;
        for (TextEditorLine line : this.allLines) {
            lineStartPositions.put(line, globalPos);
            String lineContent = line.method_1882();
            for (int i = 0; i < lineContent.length(); ++i) {
                positionToLine.put(globalPos, line);
                ++globalPos;
            }
            fullTextBuilder.append(lineContent).append('\n');
            ++globalPos;
        }
        this.fullText = fullTextBuilder.toString();
        List<Integer> openBracePositions = this.findAllOpenBraces(this.fullText);
        for (int openBracePos : openBracePositions) {
            this.processJsonObject(this.fullText, openBracePos, positionToLine, lineStartPositions);
        }
    }

    private List<Integer> findAllOpenBraces(String text) {
        int openBracePos;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        int currentPos = 0;
        while (currentPos < text.length() && (openBracePos = text.indexOf(123, currentPos)) != -1) {
            positions.add(openBracePos);
            currentPos = openBracePos + 1;
        }
        return positions;
    }

    private void processJsonObject(String text, int openBracePos, Map<Integer, TextEditorLine> posToLine, Map<TextEditorLine, Integer> lineStarts) {
        int closeBracePos = this.findMatchingCloseBrace(text, openBracePos);
        if (closeBracePos == -1) {
            return;
        }
        String jsonContent = text.substring(openBracePos, closeBracePos + 1);
        if (!this.isPlaceholderJson(jsonContent)) {
            return;
        }
        this.tokenizeJson(text, openBracePos, closeBracePos, posToLine, lineStarts);
    }

    private boolean isPlaceholderJson(String json) {
        return json.contains("\"placeholder\"");
    }

    private int findMatchingCloseBrace(String text, int openBracePos) {
        int depth = 1;
        boolean inString = false;
        boolean escaped = false;
        for (int pos = openBracePos + 1; pos < text.length() && depth > 0; ++pos) {
            char c = text.charAt(pos);
            if (inString) {
                if (c == '\\' && !escaped) {
                    escaped = true;
                } else if (c == '\"' && !escaped) {
                    inString = false;
                } else {
                    escaped = false;
                }
            } else if (c == '\"') {
                inString = true;
            } else if (c == '{') {
                ++depth;
            } else if (c == '}') {
                --depth;
            }
            if (depth != 0) continue;
            return pos;
        }
        return -1;
    }

    private void tokenizeJson(String text, int startPos, int endPos, Map<Integer, TextEditorLine> posToLine, Map<TextEditorLine, Integer> lineStarts) {
        boolean inString = false;
        boolean escaped = false;
        boolean potentialKey = false;
        int stringStartPos = -1;
        for (int pos = startPos; pos <= endPos; ++pos) {
            char c = text.charAt(pos);
            if (inString) {
                if (c == '\\' && !escaped) {
                    escaped = true;
                    continue;
                }
                if (c == '\"' && !escaped) {
                    String stringValue;
                    int checkPos;
                    inString = false;
                    int endStringPos = pos;
                    for (checkPos = endStringPos + 1; checkPos < text.length() && Character.isWhitespace(text.charAt(checkPos)); ++checkPos) {
                    }
                    boolean isKey = checkPos < text.length() && text.charAt(checkPos) == ':';
                    class_2583 style = isKey ? this.keyStyle : this.stringStyle;
                    this.applyStyleToPosition(stringStartPos, posToLine, lineStarts, style);
                    this.applyStyleToPosition(endStringPos, posToLine, lineStarts, style);
                    for (int i2 = stringStartPos + 1; i2 < endStringPos; ++i2) {
                        this.applyStyleToPosition(i2, posToLine, lineStarts, style);
                    }
                    if (isKey || endStringPos - stringStartPos <= 3 || !(stringValue = text.substring(stringStartPos + 1, endStringPos)).startsWith("{") || !stringValue.endsWith("}") || !stringValue.contains("\"placeholder\"")) continue;
                    int finalStringStartPos = stringStartPos;
                    int finalStringStartPos1 = stringStartPos;
                    this.tokenizeJson(stringValue, 0, stringValue.length() - 1, (int i) -> (TextEditorLine)((Object)((Object)posToLine.get(finalStringStartPos + 1 + i))), (TextEditorLine line) -> (Integer)lineStarts.get((Object)line) + finalStringStartPos1 + 1);
                    continue;
                }
                escaped = false;
                continue;
            }
            if (c == '\"') {
                inString = true;
                stringStartPos = pos;
                continue;
            }
            if (c == '{' || c == '}') {
                this.applyStyleToPosition(pos, posToLine, lineStarts, this.braceStyle);
                continue;
            }
            if (c != ':' && c != ',') continue;
            this.applyStyleToPosition(pos, posToLine, lineStarts, this.punctuationStyle);
        }
    }

    private void applyStyleToPosition(int pos, Map<Integer, TextEditorLine> posToLine, Map<TextEditorLine, Integer> lineStarts, class_2583 style) {
        int lineStartPos;
        int posInLine;
        TextEditorLine line = posToLine.get(pos);
        if (line != null && (posInLine = pos - (lineStartPos = lineStarts.get((Object)line).intValue())) >= 0 && posInLine < line.method_1882().length()) {
            this.characterStyles.computeIfAbsent(line, k -> new TreeMap()).put(posInLine, style);
        }
    }

    private void tokenizeJson(String text, int startPos, int endPos, PosToLineMapper posToLine, LineToStartPosMapper lineStarts) {
        boolean inString = false;
        boolean escaped = false;
        int stringStartPos = -1;
        for (int pos = startPos; pos <= endPos; ++pos) {
            char c = text.charAt(pos);
            if (inString) {
                if (c == '\\' && !escaped) {
                    escaped = true;
                    continue;
                }
                if (c == '\"' && !escaped) {
                    int checkPos;
                    inString = false;
                    int endStringPos = pos;
                    for (checkPos = endStringPos + 1; checkPos < text.length() && Character.isWhitespace(text.charAt(checkPos)); ++checkPos) {
                    }
                    boolean isKey = checkPos < text.length() && text.charAt(checkPos) == ':';
                    class_2583 style = isKey ? this.keyStyle : this.stringStyle;
                    this.applyStyleToPosition(stringStartPos, posToLine, lineStarts, style);
                    this.applyStyleToPosition(endStringPos, posToLine, lineStarts, style);
                    for (int i = stringStartPos + 1; i < endStringPos; ++i) {
                        this.applyStyleToPosition(i, posToLine, lineStarts, style);
                    }
                    continue;
                }
                escaped = false;
                continue;
            }
            if (c == '\"') {
                inString = true;
                stringStartPos = pos;
                continue;
            }
            if (c == '{' || c == '}') {
                this.applyStyleToPosition(pos, posToLine, lineStarts, this.braceStyle);
                continue;
            }
            if (c != ':' && c != ',') continue;
            this.applyStyleToPosition(pos, posToLine, lineStarts, this.punctuationStyle);
        }
    }

    private void applyStyleToPosition(int pos, PosToLineMapper posToLine, LineToStartPosMapper lineStarts, class_2583 style) {
        int lineStartPos;
        int posInLine;
        TextEditorLine line = posToLine.apply(pos);
        if (line != null && (posInLine = pos - (lineStartPos = lineStarts.apply(line))) >= 0 && posInLine < line.method_1882().length()) {
            this.characterStyles.computeIfAbsent(line, k -> new TreeMap()).put(posInLine, style);
        }
    }

    @Override
    @Nullable
    public class_2583 getStyle(char atCharacterInLine, int atCharacterIndexInLine, int cursorPosInLine, TextEditorLine inLine, int atCharacterIndexTotal, TextEditorScreen editor) {
        SortedMap<Integer, class_2583> lineStyles = this.characterStyles.get((Object)inLine);
        if (lineStyles != null && lineStyles.containsKey(atCharacterIndexInLine)) {
            return (class_2583)lineStyles.get(atCharacterIndexInLine);
        }
        return null;
    }

    @FunctionalInterface
    private static interface PosToLineMapper {
        public TextEditorLine apply(int var1);
    }

    @FunctionalInterface
    private static interface LineToStartPosMapper {
        public int apply(TextEditorLine var1);
    }
}

