/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.widget.editbox;

import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinEditBox;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.UniqueWidget;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedEditBox
extends class_342
implements UniqueWidget,
NavigatableWidget {
    private static final Logger LOGGER = LogManager.getLogger();
    protected CharacterFilter characterFilter;
    protected CharacterRenderFormatter characterRenderFormatter;
    protected DrawableColor backgroundColor = DrawableColor.of(new Color(0, 0, 0));
    protected DrawableColor borderNormalColor = DrawableColor.of(new Color(-6250336));
    protected DrawableColor borderFocusedColor = DrawableColor.of(new Color(255, 255, 255));
    protected DrawableColor textColor = DrawableColor.of(new Color(0xE0E0E0));
    protected DrawableColor textColorUneditable = DrawableColor.of(new Color(0x707070));
    protected DrawableColor suggestionTextColor = DrawableColor.of(new Color(-8355712));
    protected boolean textShadow = true;
    protected final class_327 font;
    @Nullable
    protected String identifier;
    protected boolean focusable = true;
    protected boolean navigatable = true;
    protected boolean canConsumeUserInput = true;
    @Nullable
    protected String inputPrefix;
    @Nullable
    protected String inputSuffix;
    protected boolean deleteAllAllowed = true;
    @Nullable
    protected ConsumingSupplier<ExtendedEditBox, Boolean> isActiveSupplier = null;
    @Nullable
    protected ConsumingSupplier<ExtendedEditBox, Boolean> isVisibleSupplier = null;

    public ExtendedEditBox(class_327 font, int x, int y, int width, int height, class_2561 hint) {
        super(font, x, y, width, height, hint);
        this.font = font;
    }

    public ExtendedEditBox(class_327 font, int x, int y, int width, int height, @Nullable class_342 editBox, class_2561 hint) {
        super(font, x, y, width, height, editBox, hint);
        this.font = font;
    }

    public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        IMixinEditBox access = (IMixinEditBox)((Object)this);
        boolean bordered = access.getBorderedFancyMenu();
        if (this.method_1885()) {
            class_2561 hint;
            graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, this.backgroundColor.getColorInt());
            if (bordered) {
                int borderColor = this.method_25370() ? this.borderFocusedColor.getColorInt() : this.borderNormalColor.getColorInt();
                UIBase.renderBorder(graphics, (float)(this.method_46426() - 1), (float)(this.method_46427() - 1), (float)(this.method_46426() + this.field_22758 + 1), (float)(this.method_46427() + this.field_22759 + 1), 1.0f, borderColor, true, true, true, true);
            }
            int textColor = access.getIsEditableFancyMenu() ? this.textColor.getColorInt() : this.textColorUneditable.getColorInt();
            int cursorPos = this.method_1881() - access.getDisplayPosFancyMenu();
            int highlightPos = access.getHighlightPosFancyMenu() - access.getDisplayPosFancyMenu();
            String text = this.font.method_27523(this.method_1882().substring(access.getDisplayPosFancyMenu()), this.method_1859());
            boolean isCursorInsideVisibleText = cursorPos >= 0 && cursorPos <= text.length();
            boolean isCursorVisible = this.method_25370() && access.getFrameFancyMenu() / 6 % 2 == 0 && isCursorInsideVisibleText;
            int textX = bordered ? this.method_46426() + 4 : this.method_46426();
            int textY = bordered ? this.method_46427() + (this.field_22759 - 8) / 2 : this.method_46427();
            int textXAfterCursor = textX;
            if (highlightPos > text.length()) {
                highlightPos = text.length();
            }
            int textCharacterRenderIndex = access.getDisplayPosFancyMenu();
            if (!text.isEmpty()) {
                String textBeforeCursor = isCursorInsideVisibleText ? text.substring(0, cursorPos) : text;
                class_5250 beforeCursorComp = class_2561.method_43470((String)"");
                if (this.characterRenderFormatter == null) {
                    beforeCursorComp = class_2561.method_43470((String)textBeforeCursor);
                } else {
                    for (char c : textBeforeCursor.toCharArray()) {
                        class_5250 comp = this.characterRenderFormatter.formatComponent(this, class_2561.method_43470((String)String.valueOf(c)), textCharacterRenderIndex, c, text, this.method_1882());
                        beforeCursorComp.method_10852((class_2561)comp);
                        ++textCharacterRenderIndex;
                    }
                }
                textXAfterCursor = graphics.method_51439(this.font, (class_2561)beforeCursorComp, textX, textY, textColor, this.textShadow);
            }
            boolean renderSmallCursor = this.method_1881() < this.method_1882().length() || this.method_1882().length() >= access.getMaxLengthFancyMenu();
            int finalTextXAfterCursor = textXAfterCursor;
            if (!isCursorInsideVisibleText) {
                finalTextXAfterCursor = cursorPos > 0 ? textX + this.field_22758 : textX;
            } else if (renderSmallCursor) {
                finalTextXAfterCursor = textXAfterCursor - 1;
                if (this.textShadow) {
                    --textXAfterCursor;
                }
            }
            if (!text.isEmpty() && isCursorInsideVisibleText && cursorPos < text.length()) {
                String textAfterCursor = text.substring(cursorPos);
                class_5250 afterCursorComp = class_2561.method_43470((String)"");
                if (this.characterRenderFormatter == null) {
                    afterCursorComp = class_2561.method_43470((String)textAfterCursor);
                } else {
                    for (char c : textAfterCursor.toCharArray()) {
                        class_5250 comp = this.characterRenderFormatter.formatComponent(this, class_2561.method_43470((String)String.valueOf(c)), textCharacterRenderIndex, c, text, this.method_1882());
                        afterCursorComp.method_10852((class_2561)comp);
                        ++textCharacterRenderIndex;
                    }
                }
                graphics.method_51439(this.font, (class_2561)afterCursorComp, textXAfterCursor, textY, textColor, this.textShadow);
            }
            if ((hint = access.getHintFancyMenu()) != null && text.isEmpty() && !this.method_25370()) {
                graphics.method_51439(this.font, hint, textXAfterCursor, textY, textColor, this.textShadow);
            }
            if (!renderSmallCursor && access.getSuggestionFancyMenu() != null) {
                graphics.method_51433(this.font, access.getSuggestionFancyMenu(), finalTextXAfterCursor - 1, textY, this.suggestionTextColor.getColorInt(), this.textShadow);
            }
            if (isCursorVisible) {
                if (renderSmallCursor) {
                    graphics.method_25294(finalTextXAfterCursor, textY - 1, finalTextXAfterCursor + 1, textY + 1 + 9, textColor);
                } else {
                    Objects.requireNonNull(this.font);
                    Objects.requireNonNull(this.font);
                    graphics.method_25294(finalTextXAfterCursor, textY + 9 - 2, finalTextXAfterCursor + 5, textY + 9 - 1, textColor);
                }
            }
            if (highlightPos != cursorPos) {
                int l1 = textX + this.font.method_1727(text.substring(0, highlightPos));
                access.invokeRenderHighlightFancyMenu(graphics, finalTextXAfterCursor, textY - 1, l1 - 1, textY + 1 + 9);
            }
        }
    }

    public void method_25394(@NotNull class_332 $$0, int $$1, int $$2, float $$3) {
        if (this.isActiveSupplier != null) {
            this.field_22763 = this.isActiveSupplier.get(this);
        }
        if (this.isVisibleSupplier != null) {
            this.field_22764 = this.isVisibleSupplier.get(this);
        }
        super.method_25394($$0, $$1, $$2, $$3);
    }

    public void setHeight(int height) {
        this.field_22759 = height;
    }

    public int getDisplayPosition() {
        return ((IMixinEditBox)((Object)this)).getDisplayPosFancyMenu();
    }

    public void setDisplayPosition(int position) {
        ((IMixinEditBox)((Object)this)).setDisplayPosFancyMenu(position);
    }

    public int getHighlightPosition() {
        return ((IMixinEditBox)((Object)this)).getHighlightPosFancyMenu();
    }

    @Nullable
    public CharacterFilter getCharacterFilter() {
        return this.characterFilter;
    }

    public ExtendedEditBox setCharacterFilter(@Nullable CharacterFilter characterFilter) {
        this.characterFilter = characterFilter;
        return this;
    }

    @NotNull
    public ExtendedEditBox setDeleteAllAllowed(boolean allowed) {
        this.deleteAllAllowed = allowed;
        return this;
    }

    public boolean isDeleteAllAllowed() {
        return this.deleteAllAllowed;
    }

    public boolean hasTextShadow() {
        return this.textShadow;
    }

    public ExtendedEditBox setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
        return this;
    }

    @NotNull
    public DrawableColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public ExtendedEditBox setBackgroundColor(@NotNull DrawableColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @NotNull
    public DrawableColor getBorderNormalColor() {
        return this.borderNormalColor;
    }

    public ExtendedEditBox setBorderNormalColor(@NotNull DrawableColor borderNormalColor) {
        this.borderNormalColor = borderNormalColor;
        return this;
    }

    @NotNull
    public DrawableColor getBorderFocusedColor() {
        return this.borderFocusedColor;
    }

    public ExtendedEditBox setBorderFocusedColor(@NotNull DrawableColor borderFocusedColor) {
        this.borderFocusedColor = borderFocusedColor;
        return this;
    }

    @Nullable
    public CharacterRenderFormatter getCharacterRenderFormatter() {
        return this.characterRenderFormatter;
    }

    public ExtendedEditBox setCharacterRenderFormatter(@Nullable CharacterRenderFormatter characterRenderFormatter) {
        this.characterRenderFormatter = characterRenderFormatter;
        return this;
    }

    @NotNull
    public DrawableColor getTextColor() {
        return this.textColor;
    }

    public ExtendedEditBox setTextColor(@NotNull DrawableColor textColor) {
        this.textColor = textColor;
        return this;
    }

    @NotNull
    public DrawableColor getTextColorUneditable() {
        return this.textColorUneditable;
    }

    public ExtendedEditBox setTextColorUneditable(@NotNull DrawableColor textColorUneditable) {
        this.textColorUneditable = textColorUneditable;
        return this;
    }

    @NotNull
    public DrawableColor getSuggestionTextColor() {
        return this.suggestionTextColor;
    }

    public ExtendedEditBox setSuggestionTextColor(@NotNull DrawableColor suggestionTextColor) {
        this.suggestionTextColor = suggestionTextColor;
        return this;
    }

    public boolean canConsumeUserInput() {
        return this.canConsumeUserInput;
    }

    public ExtendedEditBox setCanConsumeUserInput(boolean canConsumeUserInput) {
        this.canConsumeUserInput = canConsumeUserInput;
        return this;
    }

    @Nullable
    public String getInputPrefix() {
        return this.inputPrefix;
    }

    public ExtendedEditBox setInputPrefix(@Nullable String inputPrefix) {
        this.inputPrefix = inputPrefix;
        this.method_1852(this.getValueWithoutPrefixSuffix());
        return this;
    }

    @Nullable
    public String getInputSuffix() {
        return this.inputSuffix;
    }

    public ExtendedEditBox setInputSuffix(@Nullable String inputSuffix) {
        this.inputSuffix = inputSuffix;
        this.method_1852(this.getValueWithoutPrefixSuffix());
        return this;
    }

    public ExtendedEditBox applyInputPrefixSuffixCharacterRenderFormatter() {
        this.setCharacterRenderFormatter((editBox, component, characterIndex, character, visiblePartOfLine, fullLine) -> {
            if (this.inputSuffix != null && characterIndex > Math.max(0, editBox.method_1882().length() - this.inputSuffix.length() - 1)) {
                component.method_27696(class_2583.field_24360.method_36139(this.getTextColorUneditable().getColorInt()));
            }
            if (this.inputPrefix != null && characterIndex < this.inputPrefix.length()) {
                component.method_27696(class_2583.field_24360.method_36139(this.getTextColorUneditable().getColorInt()));
            }
            return component;
        });
        return this;
    }

    public void setIsActiveSupplier(@Nullable ConsumingSupplier<ExtendedEditBox, Boolean> isActiveSupplier) {
        this.isActiveSupplier = isActiveSupplier;
    }

    public void setIsVisibleSupplier(@Nullable ConsumingSupplier<ExtendedEditBox, Boolean> isVisibleSupplier) {
        this.isVisibleSupplier = isVisibleSupplier;
    }

    @Deprecated
    public void method_1868(int color) {
        this.textColor = DrawableColor.of(new Color(color));
    }

    @Deprecated
    public void method_1860(int color) {
        this.textColorUneditable = DrawableColor.of(new Color(color));
    }

    public void method_1852(@NotNull String value) {
        Object v = this.getWithoutPrefixSuffix(value);
        if (this.inputPrefix != null) {
            v = this.inputPrefix + (String)v;
        }
        if (this.inputSuffix != null) {
            v = (String)v + this.inputSuffix;
        }
        super.method_1852((String)v);
    }

    public boolean method_25400(char character, int modifiers) {
        if (this.characterFilter != null && !this.characterFilter.isAllowedChar(character)) {
            return false;
        }
        return super.method_25400(character, modifiers);
    }

    public void method_1867(@NotNull String textToWrite) {
        if (this.isInPrefixSuffix(this.method_1881(), 0, 0)) {
            return;
        }
        if (this.isInPrefixSuffix(this.getHighlightPosition(), 0, 0)) {
            return;
        }
        if (this.characterFilter != null) {
            textToWrite = this.characterFilter.filterForAllowedChars(textToWrite);
        }
        super.method_1867(textToWrite);
    }

    public void method_1878(int i) {
        if (this.isInPrefixSuffix(this.method_1881(), -1, -1) || this.isInPrefixSuffix(this.method_1881(), 0, 0)) {
            return;
        }
        if (this.isInPrefixSuffix(this.getHighlightPosition(), 0, 0)) {
            return;
        }
        super.method_1878(i);
    }

    public boolean isInPrefixSuffix(int index, int prefixIndexOffset, int suffixIndexOffset) {
        int cursorPrefix = index + prefixIndexOffset;
        int cursorSuffix = index + suffixIndexOffset;
        if (this.inputPrefix != null && cursorPrefix < this.inputPrefix.length()) {
            return true;
        }
        if (this.inputSuffix != null) {
            int i;
            int n = i = this.inputPrefix != null ? this.inputPrefix.length() + this.getValueWithoutPrefixSuffix().length() : this.getValueWithoutPrefixSuffix().length();
            if (cursorSuffix > i) {
                return true;
            }
        }
        return false;
    }

    public String getValueWithoutPrefixSuffix() {
        return this.getWithoutPrefixSuffix(this.method_1882());
    }

    protected String getWithoutPrefixSuffix(@NotNull String value) {
        String v;
        if (value.isEmpty()) {
            return value;
        }
        boolean containsPrefix = this.inputPrefix != null && value.startsWith(this.inputPrefix);
        boolean containsSuffix = this.inputSuffix != null && value.endsWith(this.inputSuffix);
        String string = v = containsPrefix ? value.substring(this.inputPrefix.length()) : value;
        if (containsSuffix) {
            v = v.substring(0, Math.max(0, v.length() - this.inputSuffix.length()));
        }
        return v;
    }

    public void method_16873(int i) {
        if (this.deleteAllAllowed) {
            super.method_16873(i);
        } else {
            this.method_1878(i);
        }
    }

    public boolean method_25404(int keycode, int scancode, int modifiers) {
        if (!this.canConsumeUserInput) {
            return false;
        }
        if (class_437.method_25439((int)keycode) && (this.inputPrefix != null || this.inputSuffix != null)) {
            if (this.inputSuffix != null) {
                this.method_1883(this.method_1882().length() - this.inputSuffix.length());
            } else {
                this.method_1872();
            }
            this.method_1884(this.inputPrefix != null ? this.inputPrefix.length() : 0);
            return true;
        }
        return super.method_25404(keycode, scancode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.canConsumeUserInput) {
            return false;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return false;
    }

    public ExtendedEditBox setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    @Nullable
    public String getWidgetIdentifierFancyMenu() {
        return this.identifier;
    }

    public void method_25365(boolean focused) {
        if (!this.focusable) {
            super.method_25365(false);
            return;
        }
        super.method_25365(focused);
    }

    public boolean method_25370() {
        if (!this.focusable) {
            return false;
        }
        return super.method_25370();
    }

    @Override
    public boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    @Override
    public boolean isNavigatable() {
        return this.navigatable;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        this.navigatable = navigatable;
    }

    @FunctionalInterface
    public static interface CharacterRenderFormatter {
        @NotNull
        public class_5250 formatComponent(@NotNull ExtendedEditBox var1, @NotNull class_5250 var2, int var3, char var4, @NotNull String var5, @NotNull String var6);
    }
}

