/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.fastpaintings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.fastpaintings.PaintingBlock;
import net.mehvahdjukaar.fastpaintings.PaintingBlockEntity;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1535;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4044;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class PaintingBlockModel
implements CustomBakedModel {
    public static final class_2960 BACK_TEXTURE = new class_2960("painting/back");
    private final class_1087[] models = new class_1087[16];

    public PaintingBlockModel(Map<String, class_1087> paintingModels) {
        for (Map.Entry<String, class_1087> e : paintingModels.entrySet()) {
            String k = e.getKey();
            int i = this.getIndex(k.contains("top"), k.contains("bottom"), k.contains("left"), k.contains("right"));
            this.models[i] = e.getValue();
        }
    }

    public int getIndex(boolean top, boolean bottom, boolean left, boolean right) {
        int index = 0;
        index |= (top ? 1 : 0) << 3;
        index |= (bottom ? 1 : 0) << 2;
        index |= (left ? 1 : 0) << 1;
        return index |= right ? 1 : 0;
    }

    public List<class_777> getBlockQuads(class_2680 state, class_2350 side, class_5819 rand, class_1921 renderType, ExtraModelData data) {
        class_1535 variant = (class_1535)data.get(PaintingBlockEntity.MIMIC_KEY);
        if (variant == null) {
            return List.of();
        }
        class_4044 paintingTextureManager = class_310.method_1551().method_18321();
        class_2960 paintingTexture = paintingTextureManager.method_18345(variant).method_45851().method_45816();
        class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(new class_2960(paintingTexture.method_12836(), "painting/" + paintingTexture.method_12832()));
        float segmentWScale = (float)sprite.method_45851().method_45807() / (float)variant.method_6945();
        float segmentHScale = (float)sprite.method_45851().method_45815() / (float)variant.method_6943();
        int rightOffset = (Integer)state.method_11654((class_2769)PaintingBlock.RIGHT_OFFSET);
        int downOffset = (Integer)state.method_11654((class_2769)PaintingBlock.DOWN_OFFSET);
        int paintingW = variant.method_6945() / 16;
        int paintingH = variant.method_6943() / 16;
        float spriteRightOff = (float)rightOffset * (sprite.method_4577() - sprite.method_4594()) / (float)paintingW;
        float spriteDownOff = (float)downOffset * (sprite.method_4575() - sprite.method_4593()) / (float)paintingH;
        ArrayList<class_777> combinedQuads = new ArrayList<class_777>();
        ArrayList<class_1087> bakedModels = new ArrayList<class_1087>();
        bakedModels.add(this.models[0]);
        int index = this.getIndex(downOffset == 0, downOffset == paintingH - 1, rightOffset == 0, rightOffset == paintingW - 1);
        bakedModels.add(this.models[index]);
        for (class_1087 model : bakedModels) {
            if (model == null) continue;
            List quads = model.method_4707(null, side, rand);
            for (class_777 q : quads) {
                class_1058 oldSprite = q.method_35788();
                if (oldSprite.method_45851().method_45816().equals((Object)class_1047.method_4539())) {
                    int stride = class_290.field_1590.method_1359();
                    int[] v = Arrays.copyOf(q.method_3357(), q.method_3357().length);
                    for (int i = 0; i < v.length / stride; ++i) {
                        float originalU = Float.intBitsToFloat(v[i * stride + 4]);
                        float originalV = Float.intBitsToFloat(v[i * stride + 5]);
                        float u1 = (originalU - oldSprite.method_4594()) * segmentWScale + spriteRightOff;
                        v[i * stride + 4] = Float.floatToRawIntBits(u1 + sprite.method_4594());
                        float v1 = (originalV - oldSprite.method_4593()) * segmentHScale + spriteDownOff;
                        v[i * stride + 5] = Float.floatToRawIntBits(v1 + sprite.method_4593());
                    }
                    combinedQuads.add(new class_777(v, q.method_3359(), q.method_3358(), sprite, q.method_24874()));
                    continue;
                }
                combinedQuads.add(q);
            }
        }
        return combinedQuads;
    }

    public ExtraModelData getModelData(@Nullable ExtraModelData originalTileData, class_2338 pos, class_2680 state, class_1920 level) {
        PaintingBlockEntity tile;
        if (state.method_26204() instanceof PaintingBlock && !PaintingBlock.isMaster(state) && (tile = PaintingBlock.getMaster(state, pos, level)) != null) {
            return tile.getExtraModelData();
        }
        return originalTileData;
    }

    public class_1058 getBlockParticle(ExtraModelData data) {
        return this.models[0].method_4711();
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_24304() {
        return false;
    }

    public boolean method_4713() {
        return false;
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }

    public class_809 method_4709() {
        return class_809.field_4301;
    }
}

