/*
 * Decompiled with CFR 0.152.
 */
package net.forcemaster_rpg.item.weapons;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.forcemaster_rpg.ForcemasterClassMod;
import net.forcemaster_rpg.config.TweaksConfig;
import net.forcemaster_rpg.item.ForcemasterGroup;
import net.forcemaster_rpg.item.weapons.DragonKnuckle;
import net.forcemaster_rpg.item.weapons.GlacialKnuckle;
import net.forcemaster_rpg.item.weapons.KnuckleItem;
import net.forcemaster_rpg.item.weapons.OceanKnuckle;
import net.forcemaster_rpg.item.weapons.WitherKnuckle;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.spell_engine.api.item.ItemConfig;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellSchools;

public class WeaponsRegister {
    public static final ArrayList<Weapon.Entry> entries = new ArrayList();
    public static float knuckle_attackSpeed = -2.2f;
    public static final Weapon.Entry wooden_knuckle = WeaponsRegister.knuckles("wooden_knuckle", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8922, () -> class_1856.method_8106((class_6862)class_3489.field_15539)), 2.0f, false).attribute(WeaponsRegister.armorAddition(1.0f));
    public static final Weapon.Entry stone_knuckle = WeaponsRegister.knuckles("stone_knuckle", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8927, () -> class_1856.method_8106((class_6862)class_3489.field_23802)), 3.0f, false).attribute(WeaponsRegister.armorAddition(1.0f));
    public static final Weapon.Entry iron_knuckle = WeaponsRegister.knuckles("iron_knuckle", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8923, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620})), 4.0f, false).attribute(WeaponsRegister.armorAddition(2.0f)).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.ARCANE.id, (float)2.0f));
    public static final Weapon.Entry golden_knuckle = WeaponsRegister.knuckles("golden_knuckle", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8929, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8695})), 2.0f, false).attribute(WeaponsRegister.armorAddition(1.0f)).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.ARCANE.id, (float)2.0f));
    public static final Weapon.Entry diamond_knuckle = WeaponsRegister.knuckles("diamond_knuckle", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8930, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477})), 5.0f, false).attribute(WeaponsRegister.armorAddition(2.0f)).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.ARCANE.id, (float)3.0f));
    public static final Weapon.Entry netherite_knuckle = WeaponsRegister.knuckles("netherite_knuckle", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020})), 5.5f, true).attribute(WeaponsRegister.armorAddition(3.0f)).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.ARCANE.id, (float)4.0f));
    private static final float lneWeaponSpellPower = 2.0f;
    static Supplier<class_1856> dragonRepair = WeaponsRegister.ingredient("loot_n_explore:ender_dragon_scales");
    static Supplier<class_1856> elderGuardianRepair = WeaponsRegister.ingredient("loot_n_explore:elder_guardian_eye");
    static Supplier<class_1856> frostMonarchRepair = WeaponsRegister.ingredient("loot_n_explore:frozen_soul");
    static Supplier<class_1856> witherRepair = WeaponsRegister.ingredient("minecraft:nether_star");
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";
    private static final String LNE = "loot_n_explore";

    private static ItemConfig.Attribute armorAddition(float value) {
        return new ItemConfig.Attribute("generic.armor", value, class_1322.class_1323.field_6328);
    }

    private static Weapon.Entry entry(String name, Weapon.CustomMaterial material, class_1792 item, ItemConfig.Weapon defaults) {
        return WeaponsRegister.entry(null, name, material, item, defaults);
    }

    private static Weapon.Entry entry(String requiredMod, String name, Weapon.CustomMaterial material, class_1792 item, ItemConfig.Weapon defaults) {
        Weapon.Entry entry = new Weapon.Entry("forcemaster_rpg", name, material, item, defaults, null);
        if (entry.isRequiredModInstalled()) {
            entries.add(entry);
        }
        return entry;
    }

    private static Supplier<class_1856> ingredient(String idString, boolean requirement, class_1792 fallback) {
        class_2960 id = new class_2960(idString);
        if (requirement) {
            return () -> class_1856.method_8091((class_1935[])new class_1935[]{fallback});
        }
        return () -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            class_1792 ingredient = item != null ? item : fallback;
            return class_1856.method_8091((class_1935[])new class_1935[]{ingredient});
        };
    }

    private static Supplier<class_1856> ingredient(String idString) {
        return WeaponsRegister.ingredient(idString, class_1802.field_8477);
    }

    private static Supplier<class_1856> ingredient(String idString, class_1792 fallback) {
        class_2960 id = new class_2960(idString);
        return () -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            class_1792 ingredient = item != null ? item : fallback;
            return class_1856.method_8091((class_1935[])new class_1935[]{ingredient});
        };
    }

    private static Weapon.Entry knuckles(String name, Weapon.CustomMaterial material, float damage, boolean fireproof) {
        return WeaponsRegister.knuckles(null, name, material, damage, fireproof);
    }

    private static Weapon.Entry knuckles(String requiredMod, String name, Weapon.CustomMaterial material, float damage, boolean fireproof) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        if (fireproof) {
            settings = settings.method_24359();
        }
        KnuckleItem item = new KnuckleItem((class_1832)material, settings);
        return WeaponsRegister.entry(requiredMod, name, material, (class_1792)item, new ItemConfig.Weapon(damage, knuckle_attackSpeed));
    }

    private static Weapon.Entry dragonKnuckle(String requiredMod, String name, Weapon.CustomMaterial material, float damage, boolean fireproof) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        if (fireproof) {
            settings = settings.method_24359();
        }
        DragonKnuckle item = new DragonKnuckle((class_1832)material, settings);
        return WeaponsRegister.entry(requiredMod, name, material, (class_1792)item, new ItemConfig.Weapon(damage, knuckle_attackSpeed));
    }

    private static Weapon.Entry elderGuardianKnuckle(String requiredMod, String name, Weapon.CustomMaterial material, float damage, boolean fireproof) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        if (fireproof) {
            settings = settings.method_24359();
        }
        OceanKnuckle item = new OceanKnuckle((class_1832)material, settings);
        return WeaponsRegister.entry(requiredMod, name, material, (class_1792)item, new ItemConfig.Weapon(damage, knuckle_attackSpeed));
    }

    private static Weapon.Entry glacialKnuckle(String requiredMod, String name, Weapon.CustomMaterial material, float damage, boolean fireproof) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        if (fireproof) {
            settings = settings.method_24359();
        }
        GlacialKnuckle item = new GlacialKnuckle((class_1832)material, settings);
        return WeaponsRegister.entry(requiredMod, name, material, (class_1792)item, new ItemConfig.Weapon(damage, knuckle_attackSpeed));
    }

    private static Weapon.Entry witherKnuckle(String requiredMod, String name, Weapon.CustomMaterial material, float damage, boolean fireproof) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        if (fireproof) {
            settings = settings.method_24359();
        }
        WitherKnuckle item = new WitherKnuckle((class_1832)material, settings);
        return WeaponsRegister.entry(requiredMod, name, material, (class_1792)item, new ItemConfig.Weapon(damage, knuckle_attackSpeed));
    }

    public static void register(Map<String, ItemConfig.Weapon> configs) {
        Supplier<class_1856> repair;
        if (FabricLoader.getInstance().isModLoaded(BETTER_NETHER) || ((TweaksConfig)ForcemasterClassMod.tweaksConfig.value).ignore_items_required_mods) {
            repair = WeaponsRegister.ingredient("betternether:nether_ruby");
            WeaponsRegister.knuckles(BETTER_NETHER, "ruby_knuckle", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, repair), 7.0f, true).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.ARCANE.id, (float)4.5f)).attribute(WeaponsRegister.armorAddition(3.0f));
        }
        if (FabricLoader.getInstance().isModLoaded(BETTER_END) || ((TweaksConfig)ForcemasterClassMod.tweaksConfig.value).ignore_items_required_mods) {
            repair = WeaponsRegister.ingredient("betterend:aeternium_ingot");
            WeaponsRegister.knuckles(BETTER_END, "aeternium_knuckle", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, repair), 7.0f, true).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.ARCANE.id, (float)4.5f)).attribute(WeaponsRegister.armorAddition(3.0f));
        }
        if (FabricLoader.getInstance().isModLoaded(LNE) || ((TweaksConfig)ForcemasterClassMod.tweaksConfig.value).ignore_items_required_mods) {
            WeaponsRegister.dragonKnuckle(LNE, "ender_dragon_knuckle", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, dragonRepair), 7.0f, true).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.ARCANE.id, (float)4.5f)).attribute(WeaponsRegister.armorAddition(3.0f));
            WeaponsRegister.elderGuardianKnuckle(LNE, "elder_guardian_knuckle", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, elderGuardianRepair), 7.0f, true).attribute(ItemConfig.Attribute.bonus((class_2960)MoreSpellSchools.WATER.id, (float)2.0f)).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.ARCANE.id, (float)4.5f)).attribute(WeaponsRegister.armorAddition(3.0f));
            WeaponsRegister.glacialKnuckle(LNE, "glacial_knuckle", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, frostMonarchRepair), 7.0f, true).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.FROST.id, (float)2.0f)).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.ARCANE.id, (float)4.5f)).attribute(WeaponsRegister.armorAddition(3.0f));
            WeaponsRegister.witherKnuckle(LNE, "wither_knuckle", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, witherRepair), 7.0f, true).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.SOUL.id, (float)2.0f)).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.ARCANE.id, (float)4.5f)).attribute(WeaponsRegister.armorAddition(3.0f));
        }
        if (((TweaksConfig)ForcemasterClassMod.tweaksConfig.value).ignore_items_required_mods) {
            WeaponsRegister.knuckles("legendary_golden_knuckle", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8930, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8695})), 4.5f, true).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.ARCANE.id, (float)4.5f)).attribute(WeaponsRegister.armorAddition(3.0f)).attribute(ItemConfig.Attribute.multiply((class_2960)SpellPowerMechanics.HASTE.id, (float)0.05f)).attribute(ItemConfig.Attribute.multiply((class_2960)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.05f));
            WeaponsRegister.knuckles("guardian_knuckle", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8930, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620})), 5.0f, true).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.ARCANE.id, (float)4.5f)).attribute(WeaponsRegister.armorAddition(4.0f)).attribute(ItemConfig.Attribute.multiply((class_2960)SpellPowerMechanics.HASTE.id, (float)0.025f));
            WeaponsRegister.knuckles("bloody_knuckle", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020})), 6.5f, true).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.ARCANE.id, (float)4.5f)).attribute(WeaponsRegister.armorAddition(3.0f)).attribute(ItemConfig.Attribute.multiply((class_2960)Objects.requireNonNull(class_2960.method_12829((String)"more_rpg_classes:lifesteal_modifier")), (float)0.1f));
        }
        Weapon.register(configs, entries, ForcemasterGroup.FORCEMASTER_KEY);
    }
}

