/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.network.message.handshake;

import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.HandshakeMessage;
import com.mrcrayfish.framework.config.FrameworkConfigManager;
import java.util.concurrent.CountDownLatch;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class S2CLoginConfigData
extends HandshakeMessage<S2CLoginConfigData> {
    private class_2960 key;
    private byte[] data;

    public S2CLoginConfigData() {
    }

    public S2CLoginConfigData(class_2960 key, byte[] data) {
        this.key = key;
        this.data = data;
    }

    @Override
    public void encode(S2CLoginConfigData message, class_2540 buffer) {
        buffer.method_10812(message.key);
        buffer.method_10813(message.data);
    }

    @Override
    public S2CLoginConfigData decode(class_2540 buffer) {
        class_2960 key = buffer.method_10810();
        byte[] data = buffer.method_10795();
        return new S2CLoginConfigData(key, data);
    }

    @Override
    public void handle(S2CLoginConfigData message, MessageContext context) {
        Constants.LOG.debug("Received config data from server");
        boolean[] failed = new boolean[1];
        CountDownLatch block = new CountDownLatch(1);
        context.execute(() -> {
            try {
                if (!FrameworkConfigManager.getInstance().processConfigData(message)) {
                    failed[0] = true;
                }
            }
            catch (Exception e) {
                failed[0] = true;
                Constants.LOG.error("Failed to process config data from server: %s".formatted(message.key), (Throwable)e);
            }
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (failed[0]) {
            context.getNetworkManager().method_10747((class_2561)class_2561.method_43469((String)"framework.gui.process_config_fail", (Object[])new Object[]{message.key.toString()}));
        }
        context.setHandled(true);
        context.reply(new HandshakeMessage.Acknowledge());
    }

    public class_2960 getKey() {
        return this.key;
    }

    public byte[] getData() {
        return this.data;
    }
}

