/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.crops;

import dev.ftb.mods.ftbultimine.crops.ICropLikeHandler;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public enum CropLikeRegistry {
    INSTANCE;

    private final Set<ICropLikeHandler> handlers = ConcurrentHashMap.newKeySet();

    public static CropLikeRegistry getInstance() {
        return INSTANCE;
    }

    public void registerHandler(ICropLikeHandler handler) {
        this.handlers.add(handler);
    }

    public Optional<ICropLikeHandler> getHandlerFor(class_1937 level, class_2338 pos, class_2680 state) {
        return this.handlers.stream().filter(h -> h.isApplicable(level, pos, state)).findFirst();
    }

    public boolean areStatesEquivalent(class_2680 original, class_2680 state) {
        return this.handlers.stream().anyMatch(h -> h.isEquivalent(original, state));
    }
}

