/*
 * Decompiled with CFR 0.152.
 */
package dev.jdm.full_slabs.block;

import com.mojang.datafixers.util.Pair;
import dev.jdm.full_slabs.FullSlabsMod;
import dev.jdm.full_slabs.mixin.block.SlabBlockAccessor;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;

public class SlabBlockUtility {
    public static final class_265 TOP_SHAPE = SlabBlockAccessor.getTOP_SHAPE();
    public static final class_265 BOTTOM_SHAPE = SlabBlockAccessor.getBOTTOM_SHAPE();
    public static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    public static final class_265 EAST_SHAPE;
    public static final class_265 SOUTH_SHAPE;
    public static final class_265 WEST_SHAPE;
    private static Pair<class_2248, class_2248> fullSlabGhost;
    private static Pair<class_2248, class_1747> extraSlabGhost;

    public static class_265 getShape(class_2350 direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11043 -> NORTH_SHAPE;
            case class_2350.field_11034 -> EAST_SHAPE;
            case class_2350.field_11035 -> SOUTH_SHAPE;
            case class_2350.field_11039 -> WEST_SHAPE;
            case class_2350.field_11036 -> TOP_SHAPE;
            case class_2350.field_11033 -> BOTTOM_SHAPE;
        };
    }

    public static boolean isSlabBlock(class_1799 stack) {
        class_1747 blockItem;
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof class_2482;
    }

    public static class_2771 slabType(class_2350 direction) {
        return direction.method_10171() == class_2350.class_2352.field_11056 ? class_2771.field_12679 : class_2771.field_12681;
    }

    private static boolean isPositiveX(class_243 hit, class_2338 pos, class_2771 primary) {
        if (primary == class_2771.field_12679) {
            return hit.method_10216() - (double)pos.method_10263() >= 0.5;
        }
        return hit.method_10216() - (double)pos.method_10263() > 0.5;
    }

    private static boolean isPositiveY(class_243 hit, class_2338 pos, class_2771 primary) {
        if (primary == class_2771.field_12679) {
            return hit.method_10214() - (double)pos.method_10264() >= 0.5;
        }
        return hit.method_10214() - (double)pos.method_10264() > 0.5;
    }

    private static boolean isPositiveZ(class_243 hit, class_2338 pos, class_2771 primary) {
        if (primary == class_2771.field_12679) {
            return hit.method_10215() - (double)pos.method_10260() >= 0.5;
        }
        return hit.method_10215() - (double)pos.method_10260() > 0.5;
    }

    public static boolean isPositive(class_2350.class_2351 axis, class_243 hit, class_2338 pos) {
        return SlabBlockUtility.isPositive(axis, hit, pos, class_2771.field_12682);
    }

    public static boolean isPositive(class_2350.class_2351 axis, class_243 hit, class_2338 pos, class_2771 primary) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> SlabBlockUtility.isPositiveX(hit, pos, primary);
            case class_2350.class_2351.field_11052 -> SlabBlockUtility.isPositiveY(hit, pos, primary);
            case class_2350.class_2351.field_11051 -> SlabBlockUtility.isPositiveZ(hit, pos, primary);
        };
    }

    public static boolean tilted(class_2960 id) {
        return FullSlabsMod.TILTED_SLABS.contains(id) || id.method_12836().contains("minecraft") && id.method_12832().contains("slab");
    }

    public static class_2350 getDirection(class_2350.class_2351 axis, class_243 hit, class_2338 pos) {
        return SlabBlockUtility.getDirection(axis, hit, pos, class_2771.field_12682);
    }

    public static class_2350 getDirection(class_2350.class_2351 axis, class_243 hit, class_2338 pos, class_2771 primary) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> {
                if (SlabBlockUtility.isPositiveX(hit, pos, primary)) {
                    yield class_2350.field_11034;
                }
                yield class_2350.field_11039;
            }
            case class_2350.class_2351.field_11052 -> {
                if (SlabBlockUtility.isPositiveY(hit, pos, primary)) {
                    yield class_2350.field_11036;
                }
                yield class_2350.field_11033;
            }
            case class_2350.class_2351.field_11051 -> SlabBlockUtility.isPositiveZ(hit, pos, primary) ? class_2350.field_11035 : class_2350.field_11043;
        };
    }

    public static boolean insideSlab(class_2248 block, class_243 pos) {
        if (block instanceof class_2482) {
            if (SlabBlockUtility.modOne(pos.method_10216()) == 0.0) {
                return false;
            }
            if (SlabBlockUtility.modOne(pos.method_10214()) == 0.0) {
                return false;
            }
            return SlabBlockUtility.modOne(pos.method_10215()) != 0.0;
        }
        return false;
    }

    public static class_2680 getSlabState(Pair<class_2248, class_2248> pair, class_2350.class_2351 axis, class_243 hit, class_2338 pos) {
        return SlabBlockUtility.getSlabState(pair, axis, SlabBlockUtility.isPositive(axis, hit, pos));
    }

    public static class_2680 getSlabState(class_2248 block, class_2350 direction) {
        class_2771 type = direction.method_10171() == class_2350.class_2352.field_11056 ? class_2771.field_12679 : class_2771.field_12681;
        class_2350.class_2351 axis = direction.method_10166();
        return (class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)type)).method_11657((class_2769)class_2741.field_12496, (Comparable)axis);
    }

    public static class_2680 getSlabState(Pair<class_2248, class_2248> pair, class_2350.class_2351 axis, boolean positive) {
        return positive ? (class_2680)((class_2680)((class_2248)pair.getFirst()).method_9564().method_11657((class_2769)class_2741.field_12496, (Comparable)axis)).method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679) : (class_2680)((class_2680)((class_2248)pair.getSecond()).method_9564().method_11657((class_2769)class_2741.field_12496, (Comparable)axis)).method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
    }

    public static Pair<class_2248, class_2248> getFullSlabGhost() {
        return fullSlabGhost;
    }

    public static void setFullSlabGhost(class_2248 positive, class_2248 negative) {
        fullSlabGhost = Pair.of((Object)positive, (Object)negative);
    }

    public static Pair<class_2248, class_1747> getExtraSlabGhost() {
        return extraSlabGhost;
    }

    public static void setExtraSlabGhost(class_2248 base, class_1747 extra) {
        extraSlabGhost = Pair.of((Object)base, (Object)extra);
    }

    public static class_2350 getDirection(class_2771 type, class_2350.class_2351 axis) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case class_2771.field_12679 -> class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
            case class_2771.field_12681 -> class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11060, (class_2350.class_2351)axis);
            case class_2771.field_12682 -> throw new IllegalArgumentException("Slab type 'DOUBLE' is directionless!");
        };
    }

    private static double modOne(double value) {
        return value - Math.floor(value);
    }

    static {
        SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
        WEST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
        EAST_SHAPE = class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }
}

