/*
 * Decompiled with CFR 0.152.
 */
package dev.jdm.full_slabs.block.entity;

import dev.jdm.full_slabs.FullSlabsMod;
import dev.jdm.full_slabs.block.ExtraSlabBlock;
import dev.jdm.full_slabs.block.SlabBlockUtility;
import dev.jdm.full_slabs.block.entity.BaseBlockEntity;
import dev.jdm.full_slabs.config.ModConfig;
import dev.jdm.full_slabs.config.SlabExtra;
import dev.jdm.full_slabs.mixin.item.VerticallyAttachableBlockItemAccessor;
import dev.jdm.full_slabs.util.Utility;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_1747;
import net.minecraft.class_1827;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3726;
import org.jetbrains.annotations.Nullable;

public class ExtraSlabBlockEntity
extends BaseBlockEntity {
    public static final Map<class_2960, SlabExtra> allowedExtras = ((ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig()).getSlabExtras();
    private SlabExtra extra;
    private class_2248 base;

    public ExtraSlabBlockEntity(class_2338 pos, class_2680 state, class_2248 base, class_1747 item) {
        super(FullSlabsMod.EXTRA_SLAB_BLOCK_ENTITY, pos, state);
        class_2248 extraBlock;
        if (((class_2350.class_2351)state.method_11654(ExtraSlabBlock.AXIS)).method_10179() && item instanceof class_1827) {
            class_1827 wallItem = (class_1827)item;
            extraBlock = ((VerticallyAttachableBlockItemAccessor)wallItem).wallBlock();
        } else {
            extraBlock = item.method_7711();
        }
        if (!ExtraSlabBlockEntity.allowed(extraBlock)) {
            throw new RuntimeException("Not a valid extra");
        }
        this.extra = allowedExtras.get(Utility.getBlockId(extraBlock));
        this.base = base instanceof class_2482 ? base : class_2246.field_10136;
    }

    public ExtraSlabBlockEntity(class_2338 pos, class_2680 state) {
        super(FullSlabsMod.EXTRA_SLAB_BLOCK_ENTITY, pos, state);
        if (allowedExtras.keySet().isEmpty()) {
            this.extra = null;
            this.base = null;
        } else {
            this.extra = allowedExtras.values().stream().findFirst().get();
            this.base = class_2246.field_10136;
        }
    }

    public static boolean allowed(class_2248 block) {
        return allowedExtras.containsKey(Utility.getBlockId(block));
    }

    public static boolean allowed(class_2680 state, class_1747 extra) {
        class_2771 type = (class_2771)state.method_11654((class_2769)class_2482.field_11501);
        if (type == class_2771.field_12682) {
            return false;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496);
        SlabExtra ret = ExtraSlabBlockEntity.get(axis, extra);
        if (ret == null) {
            return false;
        }
        class_2350 direction = SlabBlockUtility.getDirection(type, axis);
        return ret.allowed(direction);
    }

    public static Optional<class_2680> getExtra(class_2680 state, class_1747 item) {
        if (!(state.method_26204() instanceof class_2482)) {
            return Optional.empty();
        }
        class_2771 type = (class_2771)state.method_11654((class_2769)class_2482.field_11501);
        if (type == class_2771.field_12682) {
            return Optional.empty();
        }
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496);
        SlabExtra retExtra = ExtraSlabBlockEntity.get(axis, item);
        if (retExtra == null) {
            return Optional.empty();
        }
        class_2350 direction = SlabBlockUtility.getDirection(type, axis);
        class_2680 retState = retExtra.getState(direction);
        return Optional.ofNullable(retState);
    }

    @Nullable
    public static SlabExtra get(class_2248 block) {
        return allowedExtras.get(Utility.getBlockId(block));
    }

    @Nullable
    public static SlabExtra get(class_2350.class_2351 axis, class_1747 item) {
        if (axis.method_10179() && item instanceof class_1827) {
            class_1827 wallItem = (class_1827)item;
            return ExtraSlabBlockEntity.get(((VerticallyAttachableBlockItemAccessor)wallItem).wallBlock());
        }
        return ExtraSlabBlockEntity.get(item.method_7711());
    }

    protected SlabExtra getExtra() {
        return this.extra;
    }

    public class_2680 getBaseState() {
        class_2680 state = this.method_11010();
        return (class_2680)((class_2680)this.getBase().method_9564().method_11657((class_2769)class_2741.field_12496, (Comparable)((class_2350.class_2351)state.method_11654(ExtraSlabBlock.AXIS)))).method_11657((class_2769)class_2482.field_11501, (Comparable)((class_2771)state.method_11654(ExtraSlabBlock.TYPE)));
    }

    public class_2680 getExtraState() {
        class_2680 state = this.method_11010();
        class_2771 type = (class_2771)state.method_11654(ExtraSlabBlock.TYPE);
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(ExtraSlabBlock.AXIS);
        return this.getExtra().getState(SlabBlockUtility.getDirection(type, axis));
    }

    public class_265 getBaseOutlineShape(class_1922 world, class_2338 pos, class_3726 context) {
        return this.getBaseState().method_26172(world, pos, context);
    }

    public class_265 getBaseCollisionShape(class_1922 world, class_2338 pos, class_3726 context) {
        return this.getBaseState().method_26194(world, pos, context);
    }

    public class_265 getExtraOutlineShape(class_1922 world, class_2338 pos, class_3726 context) {
        return this.getExtra().getOutlineShape(ExtraSlabBlock.getDirection(this.method_11010()), world, pos, context);
    }

    public class_265 getExtraCollisionShape(class_1922 world, class_2338 pos, class_3726 context) {
        return this.getExtra().getCollisionShape(ExtraSlabBlock.getDirection(this.method_11010()), world, pos, context);
    }

    public class_2680 getState(class_243 hit) {
        class_2350.class_2351 axis = (class_2350.class_2351)this.method_11010().method_11654(ExtraSlabBlock.AXIS);
        class_2771 type = (class_2771)this.method_11010().method_11654(ExtraSlabBlock.TYPE);
        boolean positive = SlabBlockUtility.isPositive(axis, hit, this.field_11867, type);
        return positive == (type == class_2771.field_12679) ? this.getBaseState() : this.getExtraState();
    }

    public class_2680 getOppositeState(class_243 hit) {
        class_2350.class_2351 axis = (class_2350.class_2351)this.method_11010().method_11654(ExtraSlabBlock.AXIS);
        class_2771 type = (class_2771)this.method_11010().method_11654(ExtraSlabBlock.TYPE);
        boolean positive = SlabBlockUtility.isPositive(axis, hit, this.field_11867, type);
        return positive != (type == class_2771.field_12679) ? this.getBaseState() : this.getExtraState();
    }

    protected class_2248 getBase() {
        return this.base;
    }

    public boolean waterloggable() {
        return this.getExtra().waterloggable();
    }

    @Override
    public void writeToNbt(class_2487 nbt) {
        nbt.method_10582("base_identifier", Utility.getBlockId(this.base).toString());
        nbt.method_10582("extra_identifier", Utility.getBlockId(this.extra.getBlock()).toString());
    }

    @Override
    public void readFromNbt(class_2487 nbt) {
        this.base = Utility.getBlock(new class_2960(nbt.method_10558("base_identifier")));
        if (!(this.base instanceof class_2482)) {
            this.base = class_2246.field_10136;
        }
        class_2960 extra = new class_2960(nbt.method_10558("extra_identifier"));
        this.extra = allowedExtras.getOrDefault(extra, null);
    }

    @Override
    public void writeToClientNbt(class_2487 nbt) {
        nbt.method_10582("base_identifier", Utility.getBlockId(this.base).toString());
        nbt.method_10582("extra_identifier", Utility.getBlockId(this.extra.getBlock()).toString());
    }

    @Override
    public void readFromClientNbt(class_2487 nbt) {
        this.base = Utility.getBlock(new class_2960(nbt.method_10558("base_identifier")));
        if (!(this.base instanceof class_2482)) {
            this.base = class_2246.field_10136;
        }
        class_2960 extra = new class_2960(nbt.method_10558("extra_identifier"));
        this.extra = allowedExtras.getOrDefault(extra, null);
    }
}

