/*
 * Decompiled with CFR 0.152.
 */
package dev.jdm.full_slabs.client.render;

import dev.jdm.full_slabs.FullSlabsMod;
import dev.jdm.full_slabs.block.ExtraSlabBlock;
import dev.jdm.full_slabs.block.FullSlabBlock;
import dev.jdm.full_slabs.block.SlabBlockUtility;
import dev.jdm.full_slabs.block.entity.ExtraSlabBlockEntity;
import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_310;
import net.minecraft.class_3726;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class OutlineRenderer {
    private static boolean renderSlabOutline(WorldRenderContext renderContext, WorldRenderContext.BlockOutlineContext outlineContext) {
        if (outlineContext.blockState().method_26204() instanceof class_2482) {
            OutlineRenderer.renderSlabOutlineShape(renderContext, outlineContext.blockState(), outlineContext.blockPos(), (class_1922)renderContext.world(), renderContext.camera().method_19326(), FullSlabType.Slab);
            return false;
        }
        return true;
    }

    private static boolean renderFullSlabOutline(WorldRenderContext renderContext, WorldRenderContext.BlockOutlineContext outlineContext) {
        if (outlineContext.blockState().method_27852(FullSlabsMod.FULL_SLAB_BLOCK)) {
            OutlineRenderer.renderSlabOutlineShape(renderContext, outlineContext.blockState(), outlineContext.blockPos(), (class_1922)renderContext.world(), renderContext.camera().method_19326(), FullSlabType.FullSlab);
            return false;
        }
        return true;
    }

    private static boolean renderExtraSlabOutline(WorldRenderContext renderContext, WorldRenderContext.BlockOutlineContext outlineContext) {
        if (outlineContext.blockState().method_27852(FullSlabsMod.EXTRA_SLAB_BLOCK)) {
            OutlineRenderer.renderSlabOutlineShape(renderContext, outlineContext.blockState(), outlineContext.blockPos(), (class_1922)renderContext.world(), renderContext.camera().method_19326(), FullSlabType.ExtraSlab);
            return false;
        }
        return true;
    }

    private static void renderSlabOutlineShape(WorldRenderContext renderContext, class_2680 state, class_2338 pos, class_1922 world, class_243 cam, FullSlabType type) {
        class_4587.class_4665 entry = renderContext.matrixStack().method_23760();
        Matrix3f normalmatrix = entry.method_23762();
        class_4588 shape = Objects.requireNonNull(renderContext.consumers()).getBuffer((class_1921)class_1921.field_21695);
        Matrix4f matrix = entry.method_23761();
        class_265 shapeToRender = type == FullSlabType.Slab ? OutlineRenderer.getRenderedSlabOutlineShape(state, pos) : (type == FullSlabType.FullSlab ? OutlineRenderer.getRenderedFullSlabOutlineShape(state, pos) : OutlineRenderer.getRenderedExtraSlabOutlineShape(state, pos, world));
        shapeToRender.method_1104((startX, startY, startZ, endX, endY, endZ) -> {
            float nx = (float)(endX - startX);
            float ny = (float)(endY - startY);
            float nz = (float)(endZ - startZ);
            shape.method_22918(matrix, (float)(startX + (double)pos.method_10263() - cam.method_10216()), (float)(startY + (double)pos.method_10264() - cam.method_10214()), (float)(startZ + (double)pos.method_10260() - cam.method_10215())).method_22915(0.0f, 0.0f, 0.0f, 0.4f).method_23763(normalmatrix, nx, ny, nz).method_1344();
            shape.method_22918(matrix, (float)(endX + (double)pos.method_10263() - cam.method_10216()), (float)(endY + (double)pos.method_10264() - cam.method_10214()), (float)(endZ + (double)pos.method_10260() - cam.method_10215())).method_22915(0.0f, 0.0f, 0.0f, 0.4f).method_23763(normalmatrix, nx, ny, nz).method_1344();
        });
    }

    private static class_265 getRenderedFullSlabOutlineShape(class_2680 state, class_2338 pos) {
        class_239 hitResult = class_310.method_1551().field_1765;
        if (hitResult == null) {
            return class_259.method_1077();
        }
        return SlabBlockUtility.getShape(SlabBlockUtility.getDirection((class_2350.class_2351)state.method_11654(FullSlabBlock.AXIS), hitResult.method_17784(), pos));
    }

    private static class_265 getRenderedSlabOutlineShape(class_2680 state, class_2338 pos) {
        class_2350 direction;
        class_2771 type = (class_2771)state.method_11654((class_2769)class_2482.field_11501);
        if (type == class_2771.field_12682) {
            class_239 hitResult = class_310.method_1551().field_1765;
            if (hitResult == null) {
                return class_259.method_1077();
            }
            direction = SlabBlockUtility.getDirection((class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496), hitResult.method_17784(), pos);
        } else {
            direction = SlabBlockUtility.getDirection(type, (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496));
        }
        return SlabBlockUtility.getShape(direction);
    }

    private static class_265 getRenderedExtraSlabOutlineShape(class_2680 state, class_2338 pos, class_1922 world) {
        class_2350 hitDir;
        class_2350.class_2351 axis;
        class_239 hitResult = class_310.method_1551().field_1765;
        if (hitResult == null) {
            return class_259.method_1077();
        }
        class_2771 type = (class_2771)state.method_11654(ExtraSlabBlock.TYPE);
        class_2350 slabDir = SlabBlockUtility.getDirection(type, axis = (class_2350.class_2351)state.method_11654(ExtraSlabBlock.AXIS));
        if (slabDir == (hitDir = SlabBlockUtility.getDirection(axis, hitResult.method_17784(), pos, type))) {
            return SlabBlockUtility.getShape(slabDir);
        }
        ExtraSlabBlockEntity entity = (ExtraSlabBlockEntity)world.method_8321(pos);
        if (entity == null) {
            return SlabBlockUtility.getShape(hitDir);
        }
        return entity.getExtraOutlineShape(world, pos, class_3726.method_16194());
    }

    public static void init() {
        WorldRenderEvents.BLOCK_OUTLINE.register(OutlineRenderer::renderSlabOutline);
        WorldRenderEvents.BLOCK_OUTLINE.register(OutlineRenderer::renderFullSlabOutline);
        WorldRenderEvents.BLOCK_OUTLINE.register(OutlineRenderer::renderExtraSlabOutline);
    }

    private static enum FullSlabType {
        Slab,
        FullSlab,
        ExtraSlab;

    }
}

