/*
 * Decompiled with CFR 0.152.
 */
package dev.jdm.full_slabs.client.render;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.jdm.full_slabs.block.SlabBlockUtility;
import dev.jdm.full_slabs.util.Utility;
import dev.jdm.full_slabs.util.malilib.HitPart;
import dev.jdm.full_slabs.util.malilib.HitPartQuad;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7833;

public class RenderUtility {
    public static void renderBlockVerticalHalfOverlay(class_1297 entity, class_2338 pos, class_2350 side, class_243 hitVec, class_2680 state, class_310 mc) {
        class_2350 playerFacing = entity.method_5735();
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double x = (double)pos.method_10263() + 0.5 - cameraPos.field_1352;
        double y = (double)pos.method_10264() + 0.5 - cameraPos.field_1351;
        double z = (double)pos.method_10260() + 0.5 - cameraPos.field_1350;
        boolean top = hitVec.method_10214() - (double)pos.method_10264() > 0.5;
        float topOff = top ? 0.5f : 0.0f;
        class_4587 globalStack = RenderSystem.getModelViewStack();
        globalStack.method_22903();
        RenderUtility.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, globalStack);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        int hr = 0;
        int hg = 127;
        int hb = 255;
        int ha = 63;
        int c = 255;
        if (side.method_10166().method_10179()) {
            buffer.method_22912(x - 0.5, y - 0.5 + (double)topOff, z).method_1336(hr, hg, hb, ha).method_1344();
            buffer.method_22912(x + 0.5, y - 0.5 + (double)topOff, z).method_1336(hr, hg, hb, ha).method_1344();
            buffer.method_22912(x + 0.5, y + (double)topOff, z).method_1336(hr, hg, hb, ha).method_1344();
            buffer.method_22912(x - 0.5, y + (double)topOff, z).method_1336(hr, hg, hb, ha).method_1344();
        } else {
            buffer.method_22912(x - 0.5, y - 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
            buffer.method_22912(x + 0.5, y - 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
            buffer.method_22912(x + 0.5, y + 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
            buffer.method_22912(x - 0.5, y + 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
        }
        tessellator.method_1350();
        if (side.method_10166().method_10179()) {
            RenderSystem.lineWidth((float)1.6f);
            buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
            buffer.method_22912(x - 0.5, y, z).method_1336(c, c, c, c).method_1344();
            buffer.method_22912(x + 0.5, y, z).method_1336(c, c, c, c).method_1344();
            tessellator.method_1350();
        }
        globalStack.method_22909();
    }

    public static void renderBlockTargetingOverlay(class_1297 entity, class_2338 pos, class_2350 side, class_243 hitVec, class_2680 state, class_310 mc) {
        HitPart cut;
        class_2350 playerFacing = entity.method_5735();
        HitPart part = Utility.getHitPart(side, playerFacing, pos, hitVec);
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double x = (double)pos.method_10263() + 0.5 - cameraPos.field_1352;
        double y = (double)pos.method_10264() + 0.5 - cameraPos.field_1351;
        double z = (double)pos.method_10260() + 0.5 - cameraPos.field_1350;
        class_4587 globalStack = RenderSystem.getModelViewStack();
        globalStack.method_22903();
        RenderUtility.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, globalStack);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        int hr = 0;
        int hg = 127;
        int hb = 255;
        int ha = 63;
        int c = 255;
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        if (state.method_26204() instanceof class_2482 && state.method_11654((class_2769)class_2482.field_11501) != class_2771.field_12682) {
            class_2350 dir = SlabBlockUtility.getDirection((class_2771)state.method_11654((class_2769)class_2482.field_11501), (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496));
            cut = RenderUtility.getCut(dir, playerFacing, side);
        } else {
            cut = HitPart.CENTER;
        }
        HitPartQuad quad = RenderUtility.getHitQuad(part, cut);
        ImmutableList<class_243> vecs = RenderUtility.hitQuads(quad);
        for (class_243 v : vecs) {
            buffer.method_22912(x + v.method_10216(), y + v.method_10214(), z + v.method_10215()).method_1336(hr, hg, hb, ha).method_1344();
        }
        tessellator.method_1350();
        RenderSystem.lineWidth((float)1.6f);
        buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        vecs = RenderUtility.hitLines(cut);
        for (class_243 v : vecs) {
            buffer.method_22912(x + v.method_10216(), y + v.method_10214(), z + v.method_10215()).method_1336(c, c, c, c).method_1344();
        }
        tessellator.method_1350();
        globalStack.method_22909();
    }

    private static void blockTargetingOverlayTranslations(double x, double y, double z, class_2350 side, class_2350 playerFacing, class_4587 matrixStack) {
        matrixStack.method_22904(x, y, z);
        switch (side) {
            case field_11033: {
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - playerFacing.method_10144()));
                matrixStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                break;
            }
            case field_11036: {
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - playerFacing.method_10144()));
                matrixStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                break;
            }
            case field_11043: {
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11035: {
                break;
            }
            case field_11039: {
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
                break;
            }
            case field_11034: {
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            }
        }
        matrixStack.method_22904(-x, -y, -z + 0.51);
    }

    private static class_243 vec(double x, double y) {
        return new class_243(x, y, 0.0);
    }

    public static HitPart getCut(class_2350 slab, class_2350 facing, class_2350 hitFace) {
        boolean bottom;
        if (slab == hitFace) {
            return HitPart.CENTER;
        }
        class_2350.class_2351 hitAxis = hitFace.method_10166();
        boolean hitH = hitAxis.method_10179();
        boolean hitV = hitAxis.method_10178();
        if (slab.method_10166().method_10179()) {
            if (slab.method_10170() == hitFace) {
                return HitPart.RIGHT;
            }
            if (slab.method_10160() == hitFace) {
                return HitPart.LEFT;
            }
            if (hitV) {
                if (slab.method_10160() == facing) {
                    return HitPart.RIGHT;
                }
                if (slab.method_10170() == facing) {
                    return HitPart.LEFT;
                }
            }
        }
        boolean bl = bottom = hitFace == class_2350.field_11033;
        if (hitV && slab == facing) {
            return bottom ? HitPart.BOTTOM : HitPart.TOP;
        }
        if (hitH && slab == class_2350.field_11036) {
            return HitPart.TOP;
        }
        if (hitV && slab == facing.method_10153()) {
            return bottom ? HitPart.TOP : HitPart.BOTTOM;
        }
        if (hitH && slab == class_2350.field_11033) {
            return HitPart.BOTTOM;
        }
        throw new IllegalArgumentException("Something has gone very wrong");
    }

    private static HitPartQuad getHitQuad(HitPart hitPart, HitPart hitCut) {
        return switch (hitCut) {
            default -> throw new IncompatibleClassChangeError();
            case HitPart.CENTER -> {
                switch (hitPart) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CENTER: {
                        yield HitPartQuad.CENTER_FULL;
                    }
                    case LEFT: {
                        yield HitPartQuad.LEFT_FULL;
                    }
                    case RIGHT: {
                        yield HitPartQuad.RIGHT_FULL;
                    }
                    case BOTTOM: {
                        yield HitPartQuad.BOTTOM_FULL;
                    }
                    case TOP: 
                }
                yield HitPartQuad.TOP_FULL;
            }
            case HitPart.LEFT -> {
                switch (hitPart) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CENTER: {
                        yield HitPartQuad.CENTER_LEFT;
                    }
                    case LEFT: {
                        yield HitPartQuad.LEFT_FULL;
                    }
                    case RIGHT: {
                        throw new AssertionError();
                    }
                    case BOTTOM: {
                        yield HitPartQuad.BOTTOM_LEFT;
                    }
                    case TOP: 
                }
                yield HitPartQuad.TOP_LEFT;
            }
            case HitPart.RIGHT -> {
                switch (hitPart) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CENTER: {
                        yield HitPartQuad.CENTER_RIGHT;
                    }
                    case LEFT: {
                        throw new AssertionError();
                    }
                    case RIGHT: {
                        yield HitPartQuad.RIGHT_FULL;
                    }
                    case BOTTOM: {
                        yield HitPartQuad.BOTTOM_RIGHT;
                    }
                    case TOP: 
                }
                yield HitPartQuad.TOP_RIGHT;
            }
            case HitPart.BOTTOM -> {
                switch (hitPart) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CENTER: {
                        yield HitPartQuad.CENTER_BOTTOM;
                    }
                    case LEFT: {
                        yield HitPartQuad.LEFT_BOTTOM;
                    }
                    case RIGHT: {
                        yield HitPartQuad.RIGHT_BOTTOM;
                    }
                    case BOTTOM: {
                        yield HitPartQuad.BOTTOM_FULL;
                    }
                    case TOP: 
                }
                throw new AssertionError();
            }
            case HitPart.TOP -> {
                switch (hitPart) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CENTER: {
                        yield HitPartQuad.CENTER_TOP;
                    }
                    case LEFT: {
                        yield HitPartQuad.LEFT_TOP;
                    }
                    case RIGHT: {
                        yield HitPartQuad.RIGHT_TOP;
                    }
                    case BOTTOM: {
                        throw new AssertionError();
                    }
                    case TOP: 
                }
                yield HitPartQuad.TOP_FULL;
            }
        };
    }

    private static ImmutableList<class_243> hitQuads(HitPartQuad hit) {
        return switch (hit) {
            default -> throw new IncompatibleClassChangeError();
            case HitPartQuad.CENTER_FULL -> ImmutableList.of((Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(0.25, -0.25), (Object)RenderUtility.vec(0.25, 0.25), (Object)RenderUtility.vec(-0.25, 0.25));
            case HitPartQuad.CENTER_TOP -> ImmutableList.of((Object)RenderUtility.vec(-0.25, -0.0), (Object)RenderUtility.vec(0.25, -0.0), (Object)RenderUtility.vec(0.25, 0.25), (Object)RenderUtility.vec(-0.25, 0.25));
            case HitPartQuad.CENTER_LEFT -> ImmutableList.of((Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(0.0, -0.25), (Object)RenderUtility.vec(0.0, 0.25), (Object)RenderUtility.vec(-0.25, 0.25));
            case HitPartQuad.CENTER_RIGHT -> ImmutableList.of((Object)RenderUtility.vec(-0.0, -0.25), (Object)RenderUtility.vec(0.25, -0.25), (Object)RenderUtility.vec(0.25, 0.25), (Object)RenderUtility.vec(-0.0, 0.25));
            case HitPartQuad.CENTER_BOTTOM -> ImmutableList.of((Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(0.25, -0.25), (Object)RenderUtility.vec(0.25, 0.0), (Object)RenderUtility.vec(-0.25, 0.0));
            case HitPartQuad.LEFT_FULL -> ImmutableList.of((Object)RenderUtility.vec(-0.5, -0.5), (Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(-0.25, 0.25), (Object)RenderUtility.vec(-0.5, 0.5));
            case HitPartQuad.LEFT_TOP -> ImmutableList.of((Object)RenderUtility.vec(-0.5, -0.0), (Object)RenderUtility.vec(-0.25, -0.0), (Object)RenderUtility.vec(-0.25, 0.25), (Object)RenderUtility.vec(-0.5, 0.5));
            case HitPartQuad.LEFT_BOTTOM -> ImmutableList.of((Object)RenderUtility.vec(-0.5, -0.5), (Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(-0.25, 0.0), (Object)RenderUtility.vec(-0.5, 0.0));
            case HitPartQuad.RIGHT_FULL -> ImmutableList.of((Object)RenderUtility.vec(0.5, -0.5), (Object)RenderUtility.vec(0.25, -0.25), (Object)RenderUtility.vec(0.25, 0.25), (Object)RenderUtility.vec(0.5, 0.5));
            case HitPartQuad.RIGHT_TOP -> ImmutableList.of((Object)RenderUtility.vec(0.5, -0.0), (Object)RenderUtility.vec(0.25, -0.0), (Object)RenderUtility.vec(0.25, 0.25), (Object)RenderUtility.vec(0.5, 0.5));
            case HitPartQuad.RIGHT_BOTTOM -> ImmutableList.of((Object)RenderUtility.vec(0.5, -0.5), (Object)RenderUtility.vec(0.25, -0.25), (Object)RenderUtility.vec(0.25, 0.0), (Object)RenderUtility.vec(0.5, 0.0));
            case HitPartQuad.BOTTOM_FULL -> ImmutableList.of((Object)RenderUtility.vec(-0.5, -0.5), (Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(0.25, -0.25), (Object)RenderUtility.vec(0.5, -0.5));
            case HitPartQuad.BOTTOM_LEFT -> ImmutableList.of((Object)RenderUtility.vec(-0.5, -0.5), (Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(0.0, -0.25), (Object)RenderUtility.vec(0.0, -0.5));
            case HitPartQuad.BOTTOM_RIGHT -> ImmutableList.of((Object)RenderUtility.vec(-0.0, -0.5), (Object)RenderUtility.vec(-0.0, -0.25), (Object)RenderUtility.vec(0.25, -0.25), (Object)RenderUtility.vec(0.5, -0.5));
            case HitPartQuad.TOP_FULL -> ImmutableList.of((Object)RenderUtility.vec(-0.5, 0.5), (Object)RenderUtility.vec(-0.25, 0.25), (Object)RenderUtility.vec(0.25, 0.25), (Object)RenderUtility.vec(0.5, 0.5));
            case HitPartQuad.TOP_LEFT -> ImmutableList.of((Object)RenderUtility.vec(-0.5, 0.5), (Object)RenderUtility.vec(-0.25, 0.25), (Object)RenderUtility.vec(0.0, 0.25), (Object)RenderUtility.vec(0.0, 0.5));
            case HitPartQuad.TOP_RIGHT -> ImmutableList.of((Object)RenderUtility.vec(-0.0, 0.5), (Object)RenderUtility.vec(-0.0, 0.25), (Object)RenderUtility.vec(0.25, 0.25), (Object)RenderUtility.vec(0.5, 0.5));
        };
    }

    public static ImmutableList<class_243> hitLines(HitPart cut) {
        return switch (cut) {
            default -> throw new IncompatibleClassChangeError();
            case HitPart.CENTER -> ImmutableList.of((Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(0.25, -0.25), (Object)RenderUtility.vec(0.25, -0.25), (Object)RenderUtility.vec(0.25, 0.25), (Object)RenderUtility.vec(-0.25, 0.25), (Object)RenderUtility.vec(0.25, 0.25), (Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(-0.25, 0.25), (Object)RenderUtility.vec(-0.5, -0.5), (Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(-0.5, 0.5), (Object)RenderUtility.vec(-0.25, 0.25), (Object[])new class_243[]{RenderUtility.vec(0.5, -0.5), RenderUtility.vec(0.25, -0.25), RenderUtility.vec(0.5, 0.5), RenderUtility.vec(0.25, 0.25)});
            case HitPart.LEFT -> ImmutableList.of((Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(0.0, -0.25), (Object)RenderUtility.vec(-0.25, 0.25), (Object)RenderUtility.vec(0.0, 0.25), (Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(-0.25, 0.25), (Object)RenderUtility.vec(-0.5, -0.5), (Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(-0.5, 0.5), (Object)RenderUtility.vec(-0.25, 0.25));
            case HitPart.RIGHT -> ImmutableList.of((Object)RenderUtility.vec(-0.0, -0.25), (Object)RenderUtility.vec(0.25, -0.25), (Object)RenderUtility.vec(0.25, -0.25), (Object)RenderUtility.vec(0.25, 0.25), (Object)RenderUtility.vec(-0.0, 0.25), (Object)RenderUtility.vec(0.25, 0.25), (Object)RenderUtility.vec(0.5, -0.5), (Object)RenderUtility.vec(0.25, -0.25), (Object)RenderUtility.vec(0.5, 0.5), (Object)RenderUtility.vec(0.25, 0.25));
            case HitPart.BOTTOM -> ImmutableList.of((Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(0.25, -0.25), (Object)RenderUtility.vec(0.25, -0.25), (Object)RenderUtility.vec(0.25, 0.0), (Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(-0.25, 0.0), (Object)RenderUtility.vec(-0.5, -0.5), (Object)RenderUtility.vec(-0.25, -0.25), (Object)RenderUtility.vec(0.5, -0.5), (Object)RenderUtility.vec(0.25, -0.25));
            case HitPart.TOP -> ImmutableList.of((Object)RenderUtility.vec(0.25, -0.0), (Object)RenderUtility.vec(0.25, 0.25), (Object)RenderUtility.vec(-0.25, 0.25), (Object)RenderUtility.vec(0.25, 0.25), (Object)RenderUtility.vec(-0.25, -0.0), (Object)RenderUtility.vec(-0.25, 0.25), (Object)RenderUtility.vec(-0.5, 0.5), (Object)RenderUtility.vec(-0.25, 0.25), (Object)RenderUtility.vec(0.5, 0.5), (Object)RenderUtility.vec(0.25, 0.25));
        };
    }
}

