/*
 * Decompiled with CFR 0.152.
 */
package dev.jdm.full_slabs.config;

import dev.jdm.full_slabs.FullSlabsMod;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3675;
import net.minecraft.server.MinecraftServer;

public class CustomControls {
    private static final Map<UUID, Boolean> verticalEnabledMap = new HashMap<UUID, Boolean>();
    private static boolean showWidget = true;
    private static class_304 toggleWidget;
    private static class_304 toggleVertical;

    @Environment(value=EnvType.CLIENT)
    public static boolean getShowWidget() {
        return showWidget;
    }

    @Environment(value=EnvType.CLIENT)
    public static void toggleShowWidget() {
        showWidget = !showWidget;
    }

    public static boolean getVerticalEnabled(UUID player) {
        return verticalEnabledMap.computeIfAbsent(player, x -> true);
    }

    public static void toggleVerticalEnabled(UUID player) {
        if (verticalEnabledMap.isEmpty()) {
            CustomControls.getVerticalEnabled(player);
        }
        verticalEnabledMap.put(player, verticalEnabledMap.get(player) == false);
    }

    public static void setVerticalEnabled(UUID player, boolean value) {
        verticalEnabledMap.put(player, value);
    }

    @Environment(value=EnvType.CLIENT)
    private static void handleVerticalToggle(class_310 client) {
        boolean wasPressed = false;
        while (toggleVertical.method_1436() && client.field_1724 != null) {
            CustomControls.toggleVerticalEnabled(client.field_1724.method_5667());
            wasPressed = true;
        }
        if (wasPressed) {
            class_2540 buf = PacketByteBufs.create();
            buf.writeBoolean(CustomControls.getVerticalEnabled(client.field_1724.method_5667()));
            ClientPlayNetworking.send((class_2960)FullSlabsMod.id("toggle_vertical"), (class_2540)buf);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void handleWidgetToggle(class_310 client) {
        while (toggleWidget.method_1436()) {
            CustomControls.toggleShowWidget();
        }
    }

    private static class_304 register(String nameKey, String categoryKey, int code) {
        return KeyBindingHelper.registerKeyBinding((class_304)new class_304(nameKey, code, categoryKey));
    }

    private static class_304 register(String nameKey, String categoryKey, int code, class_3675.class_307 type) {
        return KeyBindingHelper.registerKeyBinding((class_304)new class_304(nameKey, type, code, categoryKey));
    }

    @Environment(value=EnvType.CLIENT)
    public static void clientInit() {
        toggleVertical = CustomControls.register("key.full_slabs.toggle_vertical", "category.full_slabs.full_slabs", class_3675.field_16237.method_1444());
        toggleWidget = CustomControls.register("key.full_slabs.toggle_widget", "category.full_slabs.full_slabs", 86);
        ClientTickEvents.END_CLIENT_TICK.register(CustomControls::handleVerticalToggle);
        ClientTickEvents.END_CLIENT_TICK.register(CustomControls::handleWidgetToggle);
    }

    @Environment(value=EnvType.SERVER)
    public static void serverInit() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FullSlabsMod.id("toggle_vertical"), CustomControls::receiveVerticalToggle);
    }

    @Environment(value=EnvType.SERVER)
    private static void receiveVerticalToggle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        CustomControls.setVerticalEnabled(player.method_5667(), buf.readBoolean());
    }
}

