/*
 * Decompiled with CFR 0.152.
 */
package dev.jdm.full_slabs.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.jdm.full_slabs.util.Utility;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import org.jetbrains.annotations.Nullable;

public class SlabExtra {
    private final class_2248 block;
    @Nullable
    private final class_2680 bottomState;
    @Nullable
    private final class_2680 topState;
    @Nullable
    private final class_2680 northState;
    @Nullable
    private final class_2680 southState;
    @Nullable
    private final class_2680 eastState;
    @Nullable
    private final class_2680 westState;

    public SlabExtra(class_2248 block, @Nullable String bottom, @Nullable String top, @Nullable String north, @Nullable String south, @Nullable String east, @Nullable String west) {
        this(block, Utility.getStateFromString(block, bottom), Utility.getStateFromString(block, top), Utility.getStateFromString(block, north), Utility.getStateFromString(block, south), Utility.getStateFromString(block, east), Utility.getStateFromString(block, west));
    }

    public SlabExtra(class_2248 block, @Nullable class_2680 bottom, @Nullable class_2680 top, @Nullable class_2680 north, @Nullable class_2680 south, @Nullable class_2680 east, @Nullable class_2680 west) {
        this.block = block;
        class_2960 id = Utility.getBlockId(block);
        if (bottom != null && !bottom.method_27852(block)) {
            throw new IllegalArgumentException(String.format("Argument 'bottom' is not of '%s'; Is of '%s'", id, Utility.getBlockId(bottom.method_26204())));
        }
        if (top != null && !top.method_27852(block)) {
            throw new IllegalArgumentException(String.format("Argument 'top' is not of '%s'; Is of '%s'", id, Utility.getBlockId(top.method_26204())));
        }
        if (north != null && !north.method_27852(block)) {
            throw new IllegalArgumentException(String.format("Argument 'north' is not of '%s'; Is of '%s'", id, Utility.getBlockId(north.method_26204())));
        }
        if (south != null && !south.method_27852(block)) {
            throw new IllegalArgumentException(String.format("Argument 'south' is not of '%s'; Is of '%s'", id, Utility.getBlockId(south.method_26204())));
        }
        if (east != null && !east.method_27852(block)) {
            throw new IllegalArgumentException(String.format("Argument 'east' is not of '%s'; Is of '%s'", id, Utility.getBlockId(east.method_26204())));
        }
        if (west != null && !west.method_27852(block)) {
            throw new IllegalArgumentException(String.format("Argument 'west' is not of '%s'; Is of '%s'", id, Utility.getBlockId(west.method_26204())));
        }
        this.bottomState = bottom;
        this.topState = top;
        this.northState = north;
        this.southState = south;
        this.eastState = east;
        this.westState = west;
    }

    public class_2248 getBlock() {
        return this.block;
    }

    public boolean waterloggable() {
        return this.block instanceof class_3737;
    }

    private class_265 getShape(class_2350 direction, class_1922 world, class_2338 pos, class_3726 context, FGetShape supplier) {
        class_2680 state = this.getState(direction);
        if (state == null) {
            return class_259.method_1073();
        }
        class_265 shape = supplier.get(state, world, pos, context);
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> shape.method_1096(0.0, 0.5, 0.0);
            case class_2350.field_11036 -> shape.method_1096(0.0, -0.5, 0.0);
            case class_2350.field_11043 -> shape.method_1096(0.0, 0.0, 0.5);
            case class_2350.field_11035 -> shape.method_1096(0.0, 0.0, -0.5);
            case class_2350.field_11039 -> shape.method_1096(0.5, 0.0, 0.0);
            case class_2350.field_11034 -> shape.method_1096(-0.5, 0.0, 0.0);
        };
    }

    public class_265 getOutlineShape(class_2350 direction, class_1922 world, class_2338 pos, class_3726 context) {
        return this.getShape(direction, world, pos, context, (arg_0, arg_1, arg_2, arg_3) -> ((class_2248)this.block).method_9530(arg_0, arg_1, arg_2, arg_3));
    }

    public class_265 getCollisionShape(class_2350 direction, class_1922 world, class_2338 pos, class_3726 context) {
        return this.getShape(direction, world, pos, context, (arg_0, arg_1, arg_2, arg_3) -> ((class_2248)this.block).method_9549(arg_0, arg_1, arg_2, arg_3));
    }

    @Nullable
    public class_2680 getState(class_2350 direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> this.bottomState;
            case class_2350.field_11036 -> this.topState;
            case class_2350.field_11043 -> this.northState;
            case class_2350.field_11035 -> this.southState;
            case class_2350.field_11039 -> this.westState;
            case class_2350.field_11034 -> this.eastState;
        };
    }

    public boolean allowed(class_2350 direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> {
                if (this.bottomState != null) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11036 -> {
                if (this.topState != null) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11043 -> {
                if (this.northState != null) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11035 -> {
                if (this.southState != null) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11039 -> {
                if (this.westState != null) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11034 -> this.eastState != null;
        };
    }

    @FunctionalInterface
    private static interface FGetShape {
        public class_265 get(class_2680 var1, class_1922 var2, class_2338 var3, class_3726 var4);
    }

    public static class Deserializer
    implements JsonDeserializer<SlabExtra> {
        public SlabExtra deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                if (json.isJsonObject()) {
                    JsonObject object = json.getAsJsonObject();
                    class_2248 block = Utility.getBlock(new class_2960(object.get("block").getAsString()));
                    class_2680 bottom = this.getState(block, "bottom", object);
                    class_2680 top = this.getState(block, "top", object);
                    class_2680 north = this.getState(block, "north", object);
                    class_2680 south = this.getState(block, "south", object);
                    class_2680 east = this.getState(block, "east", object);
                    class_2680 west = this.getState(block, "west", object);
                    return new SlabExtra(block, bottom, top, north, south, east, west);
                }
                throw new RuntimeException("Nope");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }

        @Nullable
        private class_2680 getState(class_2248 block, String key, JsonObject object) {
            return object.has(key) ? this.stateFromString(block, object.get(key).getAsString()) : null;
        }

        @Nullable
        private class_2680 stateFromString(class_2248 block, String str) {
            if (str == null) {
                return null;
            }
            class_2680 ret = block.method_9564();
            for (class_2769 property : block.method_9595().method_11659()) {
                Pattern pattern = Pattern.compile(property.method_11899() + "=(?<value>\\w+)");
                Matcher matcher = pattern.matcher(str);
                if (!matcher.matches()) continue;
                String value = matcher.group("value");
                Optional<class_2680> with = this.with(ret, property, value);
                if (with.isPresent()) {
                    ret = with.get();
                    continue;
                }
                throw new IllegalArgumentException("word");
            }
            return ret;
        }

        private <T extends Comparable<T>> Optional<class_2680> with(class_2680 state, class_2769<T> property, String name) {
            return property.method_11900(name).map(t -> (class_2680)state.method_11657(property, t));
        }
    }
}

