/*
 * Decompiled with CFR 0.152.
 */
package dev.jdm.full_slabs.mixin.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.jdm.full_slabs.FullSlabsMod;
import dev.jdm.full_slabs.block.SlabBlockUtility;
import dev.jdm.full_slabs.mixin.client.render.model.json.JsonUnbakedModelAccessor;
import dev.jdm.full_slabs.util.MixinSelf;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoaderHooks;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2960;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_790;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import net.minecraft.class_813;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1088.class})
public abstract class ModelLoaderMixin
implements MixinSelf<class_1088> {
    private static final String templateBlockstateJson = "{\"variants\":{\"type=double\":{\"model\":\"%s\"},\"type=bottom,axis=y\":{\"model\":\"%s\"},\"type=top,axis=y\":{\"model\":\"%s\"},\"type=bottom,axis=z\":{\"model\":\"%s\"},\"type=bottom,axis=x\":{\"model\":\"%s\"},\"type=top,axis=z\":{\"model\":\"%s\"},\"type=top,axis=x\":{\"model\":\"%s\"}}}";
    private static final String templateTiltedBlockstateJson = "{\"variants\":{\"type=double,axis=y\":{\"model\":\"%1$s\"},\"type=bottom,axis=y\":{\"model\":\"%2$s\"},\"type=top,axis=y\":{\"model\":\"%3$s\"},\"type=double,axis=x\":{\"model\":\"%1$s\",\"x\":90,\"y\":90},\"type=bottom,axis=x\":{\"model\":\"%2$s\",\"x\":90,\"y\":90},\"type=top,axis=x\":{\"model\":\"%3$s\",\"x\":90,\"y\":90},\"type=double,axis=z\":{\"model\":\"%1$s\",\"x\":270},\"type=bottom,axis=z\":{\"model\":\"%2$s\",\"x\":270},\"type=top,axis=z\":{\"model\":\"%3$s\",\"x\":270}}}";
    private static final String templateModelJson = "{\"parent\":\"%s\",\"textures\":{\"bottom\":\"%s\",\"top\":\"%s\",\"side\":\"%s\"}}";
    boolean processingSlab = false;
    Map<class_2960, class_2350> needToCreate;
    Map<class_2350, String> creationFaces;
    @Shadow
    @Final
    private class_790.class_791 field_5399;
    @Shadow
    @Final
    private Map<class_2960, class_1100> field_5376;
    private class_2960 _loadModelId;

    private static class_2960 getVariantLocation(class_790 map, String variant) {
        return ((class_813)map.method_35792(variant).method_3497().get(0)).method_3510();
    }

    private static class_2960 append(class_2960 prefix, String suffix) {
        return FullSlabsMod.id(prefix.method_12832() + suffix);
    }

    private static class_793 fetchParent(class_793 model, Function<class_2960, class_1100> loader) {
        JsonUnbakedModelAccessor accessor = (JsonUnbakedModelAccessor)model;
        class_793 parent = accessor.getParent();
        if (parent == null) {
            parent = (class_793)loader.apply(accessor.getParentId());
        }
        return parent;
    }

    private static Map<class_2350, String> getDirectionalFaces(class_793 model, Function<class_2960, class_1100> loader) {
        class_793 prev = model;
        class_793 checking = model;
        HashMap<class_2350, String> mapping = new HashMap<class_2350, String>();
        while (true) {
            List elements;
            if (!(elements = checking.method_3433()).isEmpty()) {
                class_785 element = (class_785)elements.get(0);
                Map faces = element.field_4230;
                for (class_2350 key : faces.keySet()) {
                    class_783 face = (class_783)faces.get(key);
                    mapping.put(key, face.field_4224);
                }
                break;
            }
            prev = checking;
            checking = ModelLoaderMixin.fetchParent(checking, loader);
        }
        for (class_2350 key : mapping.keySet()) {
            String str = (String)mapping.get(key);
            if (!str.startsWith("#")) continue;
            mapping.put(key, prev.method_24077(str.substring(1)).method_24147().toString());
        }
        return mapping;
    }

    @Shadow
    protected abstract class_793 method_4718(class_2960 var1) throws IOException;

    @Shadow
    protected abstract void method_4729(class_2960 var1, class_1100 var2);

    private String createBlockstateJson(class_2960 bottomId, class_2960 topId, class_2960 doubleId) {
        class_2960 northId = ModelLoaderMixin.append(bottomId, "_north");
        class_2960 eastId = ModelLoaderMixin.append(bottomId, "_east");
        class_2960 southId = ModelLoaderMixin.append(bottomId, "_south");
        class_2960 westId = ModelLoaderMixin.append(bottomId, "_west");
        this.needToCreate = ImmutableMap.of((Object)northId, (Object)class_2350.field_11043, (Object)eastId, (Object)class_2350.field_11034, (Object)southId, (Object)class_2350.field_11035, (Object)westId, (Object)class_2350.field_11039);
        return String.format(templateBlockstateJson, doubleId, bottomId, topId, northId, eastId, southId, westId);
    }

    private String createTiltedBlockstateJson(class_2960 bottomId, class_2960 topId, class_2960 doubleId) {
        return String.format(templateTiltedBlockstateJson, doubleId, bottomId, topId);
    }

    private String createModelJson(class_2960 parent, String bottom, String top, String side) {
        return String.format(templateModelJson, parent, bottom, top, side);
    }

    private class_793 fetchJsonModel(class_2960 id) throws IOException {
        if (this.field_5376.containsKey(id)) {
            return (class_793)this.field_5376.get(id);
        }
        return this.method_4718(id);
    }

    @Inject(method={"loadModel"}, at={@At(value="HEAD")})
    private void skimLoadModelId(class_2960 id, CallbackInfo ci) {
        this._loadModelId = id;
    }

    @ModifyVariable(method={"loadModel"}, at=@At(value="INVOKE_ASSIGN", target="Ljava/util/List;iterator()Ljava/util/Iterator;", ordinal=0))
    private Iterator<Pair<String, class_790>> replaceSlabVariantFiles(Iterator<Pair<String, class_790>> iterator) {
        ArrayList list = Lists.newArrayList(iterator);
        class_2960 id = this._loadModelId;
        try {
            class_2960 pure = new class_2960(id.method_12836(), id.method_12832());
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(pure);
            this.processingSlab = false;
            this.creationFaces = null;
            this.needToCreate = null;
            if (block instanceof class_2482) {
                this.processingSlab = true;
                this.needToCreate = new HashMap<class_2960, class_2350>();
                boolean tilted = SlabBlockUtility.tilted(pure);
                class_793 creationModel = this.fetchJsonModel(ModelLoaderMixin.getVariantLocation((class_790)((Pair)list.get(0)).getSecond(), "type=bottom"));
                this.creationFaces = ModelLoaderMixin.getDirectionalFaces(creationModel, arg_0 -> ((ModelLoaderHooks)((ModelLoaderHooks)this.self())).fabric_getOrLoadModel(arg_0));
                for (int i = 0; i < list.size(); ++i) {
                    Pair pair = (Pair)list.get(i);
                    class_790 map = (class_790)pair.getSecond();
                    String jsonStr = tilted ? this.createTiltedBlockstateJson(ModelLoaderMixin.getVariantLocation(map, "type=bottom"), ModelLoaderMixin.getVariantLocation(map, "type=top"), ModelLoaderMixin.getVariantLocation(map, "type=double")) : this.createBlockstateJson(ModelLoaderMixin.getVariantLocation(map, "type=bottom"), ModelLoaderMixin.getVariantLocation(map, "type=top"), ModelLoaderMixin.getVariantLocation(map, "type=double"));
                    StringReader reader = new StringReader(jsonStr);
                    list.set(i, Pair.of((Object)((String)pair.getFirst()), (Object)class_790.method_3424((class_790.class_791)this.field_5399, (Reader)reader)));
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list.iterator();
    }

    @Inject(method={"loadModel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/model/ModelLoader;loadModelFromJson(Lnet/minecraft/util/Identifier;)Lnet/minecraft/client/render/model/json/JsonUnbakedModel;", ordinal=0)}, cancellable=true)
    private void interceptSlabLoad(class_2960 id, CallbackInfo ci) {
        if (!this.processingSlab || !this.needToCreate.containsKey(id)) {
            return;
        }
        class_2350 direction = this.needToCreate.get(id);
        String bottom = this.creationFaces.get(class_2350.field_11033);
        String top = this.creationFaces.get(class_2350.field_11036);
        String side = this.creationFaces.get(class_2350.field_11043);
        String jsonStr = switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033, class_2350.field_11036 -> "{}";
            case class_2350.field_11043 -> this.createModelJson(FullSlabsMod.id("block/slab_north"), bottom, top, side);
            case class_2350.field_11034 -> this.createModelJson(FullSlabsMod.id("block/slab_east"), bottom, top, side);
            case class_2350.field_11035 -> this.createModelJson(FullSlabsMod.id("block/slab_south"), bottom, top, side);
            case class_2350.field_11039 -> this.createModelJson(FullSlabsMod.id("block/slab_west"), bottom, top, side);
        };
        this.method_4729(id, (class_1100)class_793.method_3430((String)jsonStr));
        ci.cancel();
    }
}

