/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import software.bernie.geckolib.animatable.stateless.StatelessAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.network.AbstractPacket;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.RenderUtils;

public class StatelessEntityStopAnimPacket
extends AbstractPacket {
    private final int entityId;
    private final boolean isReplacedEntity;
    private final String animation;

    public StatelessEntityStopAnimPacket(int entityId, String animation) {
        this(entityId, false, animation);
    }

    public StatelessEntityStopAnimPacket(int entityId, boolean isReplacedEntity, String animation) {
        this.entityId = entityId;
        this.isReplacedEntity = isReplacedEntity;
        this.animation = animation;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(this.entityId);
        buf.writeBoolean(this.isReplacedEntity);
        buf.method_10814(this.animation);
        return buf;
    }

    @Override
    public class_2960 getPacketID() {
        return GeckoLibNetwork.STATELESS_ENTITY_STOP_ANIM_PACKET_ID;
    }

    public static void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int entityId = buf.method_10816();
        boolean isReplacedEntity = buf.readBoolean();
        String animation = buf.method_19772();
        client.execute(() -> StatelessEntityStopAnimPacket.runOnThread(entityId, isReplacedEntity, animation));
    }

    private static void runOnThread(int entityId, boolean isReplacedEntity, String animation) {
        GeoAnimatable entityAnimatable;
        GeoAnimatable animatable;
        class_1297 entity = ClientUtils.getLevel().method_8469(entityId);
        if (entity == null) {
            return;
        }
        GeoAnimatable geoAnimatable = isReplacedEntity ? RenderUtils.getReplacedAnimatable(entity.method_5864()) : (animatable = entity instanceof GeoAnimatable ? (entityAnimatable = (GeoAnimatable)entity) : null);
        if (animatable instanceof StatelessAnimatable) {
            StatelessAnimatable statelessAnimatable = (StatelessAnimatable)((Object)animatable);
            statelessAnimatable.handleClientAnimationStop(animatable, entityId, animation);
        }
    }
}

