/*
 * Decompiled with CFR 0.152.
 */
package net.yeoxuhang.geode_plus.server.config;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Properties;
import java.util.function.Function;
import net.yeoxuhang.geode_plus.GeodePlus;
import net.yeoxuhang.geode_plus.util.BooleanEnumGetter;

public class ServerConfigs {
    public ServerConfigs(Path path) {
        File configDir = path.resolve("Geode Plus").toFile();
        if (!configDir.exists() && !configDir.mkdir()) {
            GeodePlus.logWarning("Could not create configuration directory: " + configDir.getAbsolutePath());
        }
        Path geodePlus = configDir.toPath();
        WORLDGEN.setUpConfig(geodePlus);
        BLOCKS.setUpConfig(geodePlus);
    }

    public static class WORLDGEN {
        public static boolean shouldGenerateEchoGeodes;
        public static boolean shouldGenerateDiamondGeodes;
        public static boolean shouldGenerateEmeraldGeodes;
        public static boolean shouldGenerateLapisGeodes;
        public static boolean shouldGenerateRedstoneGeodes;
        public static boolean shouldGenerateCelestiteGeodes;
        public static boolean shouldGeneratePinkTopazGeodes;
        public static boolean shouldGeneratePrismarineGeodes;
        public static boolean shouldGenerateNetherDebrisGeodes;
        public static boolean shouldGenerateNetherGlowstoneGeodes;
        public static boolean shouldGenerateNetherGoldNuggetGeodes;
        public static boolean shouldGenerateNetherQuartzGeodes;
        public static boolean shouldGenerateWrappistGeodes;
        public static boolean shouldGenerateEchoCrystal;
        public static boolean shouldGeneratePrismarineCrystal;
        public static boolean shouldGenerateQuartzCrystal;
        public static boolean shouldGenerateGlowstoneCrystal;
        public static boolean shouldGenerateWrappistCrystal;

        public static void setUpConfig(Path path) {
            Closeable stream;
            Closeable stream2;
            Closeable stream3;
            Closeable stream4;
            File configDir = path.resolve("worldgen").toFile();
            if (!configDir.exists() && !configDir.mkdir()) {
                GeodePlus.logWarning("Could not create configuration directory: " + configDir.getAbsolutePath());
            }
            File overworldGeode = new File(configDir, "overworldGeodes.properties");
            Properties overworldGeodeProperties = new Properties();
            if (overworldGeode.exists()) {
                try {
                    stream4 = new FileInputStream(overworldGeode);
                    try {
                        overworldGeodeProperties.load((InputStream)stream4);
                    }
                    finally {
                        ((FileInputStream)stream4).close();
                    }
                }
                catch (IOException e) {
                    GeodePlus.logWarning("Could not read property file '" + overworldGeode.getAbsolutePath() + "'", e);
                }
            }
            shouldGenerateEchoGeodes = BooleanEnumGetter.asBoolean((String)overworldGeodeProperties.computeIfAbsent("shouldGenerateEchoGeodes", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            shouldGenerateDiamondGeodes = BooleanEnumGetter.asBoolean((String)overworldGeodeProperties.computeIfAbsent("shouldGenerateDiamondGeodes", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            shouldGenerateEmeraldGeodes = BooleanEnumGetter.asBoolean((String)overworldGeodeProperties.computeIfAbsent("shouldGenerateEmeraldGeodes", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            shouldGenerateLapisGeodes = BooleanEnumGetter.asBoolean((String)overworldGeodeProperties.computeIfAbsent("shouldGenerateLapisGeodes", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            shouldGenerateRedstoneGeodes = BooleanEnumGetter.asBoolean((String)overworldGeodeProperties.computeIfAbsent("shouldGenerateRedstoneGeodes", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            shouldGeneratePinkTopazGeodes = BooleanEnumGetter.asBoolean((String)overworldGeodeProperties.computeIfAbsent("shouldGeneratePinkTopazGeodes", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            shouldGenerateCelestiteGeodes = BooleanEnumGetter.asBoolean((String)overworldGeodeProperties.computeIfAbsent("shouldGenerateCelestiteGeodes", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            shouldGeneratePrismarineGeodes = BooleanEnumGetter.asBoolean((String)overworldGeodeProperties.computeIfAbsent("shouldGeneratePrismarineGeodes", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            try {
                stream4 = new FileOutputStream(overworldGeode);
                try {
                    overworldGeodeProperties.store((OutputStream)stream4, "Overworld Geodes properties file");
                }
                finally {
                    ((FileOutputStream)stream4).close();
                }
            }
            catch (IOException e) {
                GeodePlus.logWarning("Could not store property file '" + overworldGeode.getAbsolutePath() + "'", e);
            }
            File netherGeode = new File(configDir, "netherGeodes.properties");
            Properties netherGeodeProperties = new Properties();
            if (netherGeode.exists()) {
                try {
                    stream3 = new FileInputStream(netherGeode);
                    try {
                        netherGeodeProperties.load((InputStream)stream3);
                    }
                    finally {
                        ((FileInputStream)stream3).close();
                    }
                }
                catch (IOException e) {
                    GeodePlus.logWarning("Could not read property file '" + netherGeode.getAbsolutePath() + "'", e);
                }
            }
            shouldGenerateNetherDebrisGeodes = BooleanEnumGetter.asBoolean((String)netherGeodeProperties.computeIfAbsent("shouldGenerateNetherDebrisGeodes", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false")), false);
            shouldGenerateNetherGlowstoneGeodes = BooleanEnumGetter.asBoolean((String)netherGeodeProperties.computeIfAbsent("shouldGenerateNetherGlowstoneGeodes", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            shouldGenerateNetherGoldNuggetGeodes = BooleanEnumGetter.asBoolean((String)netherGeodeProperties.computeIfAbsent("shouldGenerateNetherGoldNuggetGeodes", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            shouldGenerateNetherQuartzGeodes = BooleanEnumGetter.asBoolean((String)netherGeodeProperties.computeIfAbsent("shouldGenerateNetherQuartzGeodes", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            try {
                stream3 = new FileOutputStream(netherGeode);
                try {
                    netherGeodeProperties.store((OutputStream)stream3, "Nether Geodes properties file");
                }
                finally {
                    ((FileOutputStream)stream3).close();
                }
            }
            catch (IOException e) {
                GeodePlus.logWarning("Could not store property file '" + netherGeode.getAbsolutePath() + "'", e);
            }
            File theEndGeode = new File(configDir, "theEndGeodes.properties");
            Properties theEndGeodeProperties = new Properties();
            if (theEndGeode.exists()) {
                try {
                    stream2 = new FileInputStream(theEndGeode);
                    try {
                        theEndGeodeProperties.load((InputStream)stream2);
                    }
                    finally {
                        ((FileInputStream)stream2).close();
                    }
                }
                catch (IOException e) {
                    GeodePlus.logWarning("Could not read property file '" + theEndGeode.getAbsolutePath() + "'", e);
                }
            }
            shouldGenerateWrappistGeodes = BooleanEnumGetter.asBoolean((String)theEndGeodeProperties.computeIfAbsent("shouldGenerateWrappistGeode", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            try {
                stream2 = new FileOutputStream(theEndGeode);
                try {
                    theEndGeodeProperties.store((OutputStream)stream2, "The End Geodes properties file");
                }
                finally {
                    ((FileOutputStream)stream2).close();
                }
            }
            catch (IOException e) {
                GeodePlus.logWarning("Could not store property file '" + theEndGeode.getAbsolutePath() + "'", e);
            }
            File largeCrystals = new File(configDir, "largeCrystal.properties");
            Properties largeCrystalsProperties = new Properties();
            if (largeCrystals.exists()) {
                try {
                    stream = new FileInputStream(largeCrystals);
                    try {
                        largeCrystalsProperties.load((InputStream)stream);
                    }
                    finally {
                        ((FileInputStream)stream).close();
                    }
                }
                catch (IOException e) {
                    GeodePlus.logWarning("Could not read property file '" + largeCrystals.getAbsolutePath() + "'", e);
                }
            }
            shouldGenerateEchoCrystal = BooleanEnumGetter.asBoolean((String)largeCrystalsProperties.computeIfAbsent("shouldGenerateEchoCrystal", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            shouldGeneratePrismarineCrystal = BooleanEnumGetter.asBoolean((String)largeCrystalsProperties.computeIfAbsent("shouldGeneratePrismarineCrystal", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            shouldGenerateQuartzCrystal = BooleanEnumGetter.asBoolean((String)largeCrystalsProperties.computeIfAbsent("shouldGenerateQuartzCrystal", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            shouldGenerateGlowstoneCrystal = BooleanEnumGetter.asBoolean((String)largeCrystalsProperties.computeIfAbsent("shouldGenerateGlowstoneCrystal", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            shouldGenerateWrappistCrystal = BooleanEnumGetter.asBoolean((String)largeCrystalsProperties.computeIfAbsent("shouldGenerateWrappistCrystal", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")), true);
            try {
                stream = new FileOutputStream(largeCrystals);
                try {
                    largeCrystalsProperties.store((OutputStream)stream, "Large Crystal properties file");
                }
                finally {
                    ((FileOutputStream)stream).close();
                }
            }
            catch (IOException e) {
                GeodePlus.logWarning("Could not store property file '" + largeCrystals.getAbsolutePath() + "'", e);
            }
        }
    }

    public static class BLOCKS {
        public static boolean allowSilkTouch;

        public static void setUpConfig(Path path) {
            Closeable stream;
            File configDir = path.resolve("blocks").toFile();
            if (!configDir.exists() && !configDir.mkdir()) {
                GeodePlus.logWarning("Could not create configuration directory: " + configDir.getAbsolutePath());
            }
            File configFile = new File(configDir, "blocks.properties");
            Properties properties = new Properties();
            if (configFile.exists()) {
                try {
                    stream = new FileInputStream(configFile);
                    try {
                        properties.load((InputStream)stream);
                    }
                    finally {
                        ((FileInputStream)stream).close();
                    }
                }
                catch (IOException e) {
                    GeodePlus.logWarning("Could not read property file '" + configFile.getAbsolutePath() + "'", e);
                }
            }
            allowSilkTouch = BooleanEnumGetter.asBoolean((String)properties.computeIfAbsent("allowSilkTouch", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false")), false);
            try {
                stream = new FileOutputStream(configFile);
                try {
                    properties.store((OutputStream)stream, "Blocks properties file");
                }
                finally {
                    ((FileOutputStream)stream).close();
                }
            }
            catch (IOException e) {
                GeodePlus.logWarning("Could not store property file '" + configFile.getAbsolutePath() + "'", e);
            }
        }
    }
}

